/*
 * Decompiled with CFR 0.152.
 */
package jpos.config.simple;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import jpos.config.JposConfigException;
import jpos.config.JposEntry;
import jpos.config.JposRegPopulator;
import jpos.util.JposEntryUtility;

public class SimpleEntry
implements JposEntry,
Serializable,
Comparable {
    private Hashtable properties = new Hashtable();
    private transient JposRegPopulator regPopulator = null;
    public static final long serialVersionUID = 6937048853319310114L;

    public SimpleEntry() {
        this.regPopulator = null;
    }

    public SimpleEntry(JposRegPopulator populator) {
        this.regPopulator = populator;
    }

    public SimpleEntry(String logicalName, JposRegPopulator populator) {
        this(populator);
        this.addProperty("logicalName", logicalName);
    }

    SimpleEntry(String logicalName) {
        this.addProperty("logicalName", logicalName);
    }

    public int getPropertyCount() {
        return this.properties.size();
    }

    public Enumeration getPropertyNames() {
        return this.properties.keys();
    }

    public boolean hasPropertyWithName(String propName) {
        return this.properties.containsKey(propName);
    }

    public boolean hasPropertyWithValue(Object propValue) {
        return this.properties.contains(propValue);
    }

    public Object getPropertyValue(String propName) {
        return this.properties.get(propName);
    }

    public Class getPropertyType(String propName) {
        return this.getPropertyValue(propName).getClass();
    }

    public Object modifyPropertyValue(String propName, Object propValue) throws IllegalArgumentException {
        SimpleEntry.checkNull(propName);
        SimpleEntry.checkNull(propValue);
        if (!this.hasPropertyWithName(propName)) {
            return null;
        }
        Object oldValue = this.removeProperty(propName);
        this.addProperty(propName, propValue);
        return oldValue;
    }

    public Object addProperty(String propName, Object propValue) throws IllegalArgumentException {
        SimpleEntry.checkNull(propName);
        SimpleEntry.checkNull(propValue);
        return this.properties.put(propName, propValue);
    }

    public Object removeProperty(String propName) {
        return this.properties.remove(propName);
    }

    public boolean equals(JposEntry otherEntry) {
        if (otherEntry == null) {
            return false;
        }
        if (this.getPropertyCount() != otherEntry.getPropertyCount()) {
            return false;
        }
        Enumeration otherPropNames = otherEntry.getPropertyNames();
        while (otherPropNames.hasMoreElements()) {
            String name = (String)otherPropNames.nextElement();
            Object value = otherEntry.getPropertyValue(name);
            if (!this.hasPropertyWithName(name)) {
                return false;
            }
            if (this.getPropertyValue(name).equals(value)) continue;
            return false;
        }
        return true;
    }

    public JposEntry copy() {
        SimpleEntry entryCopy = new SimpleEntry();
        Enumeration entryNames = this.getPropertyNames();
        while (entryNames.hasMoreElements()) {
            String propName = (String)entryNames.nextElement();
            entryCopy.addProperty(propName, this.getPropertyValue(propName));
        }
        return entryCopy;
    }

    public JposRegPopulator getRegPopulator() {
        return this.regPopulator;
    }

    public String getLogicalName() {
        return (String)this.getPropertyValue("logicalName");
    }

    public JposEntry.Prop getProp(String propName) {
        Object propValue = this.getPropertyValue(propName);
        if (propValue == null) {
            return null;
        }
        return new Prop(propName, propValue);
    }

    public Iterator getProps() {
        ArrayList<Prop> list = new ArrayList<Prop>();
        Enumeration names = this.getPropertyNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            list.add(new Prop(name, this.getPropertyValue(name)));
        }
        return list.iterator();
    }

    public void add(JposEntry.Prop prop) throws IllegalArgumentException {
        SimpleEntry.checkNull(prop);
        this.addProperty(prop.getName(), prop.getValue());
    }

    public void remove(JposEntry.Prop prop) {
        this.removeProperty(prop.getName());
    }

    public void modify(JposEntry.Prop prop) throws IllegalArgumentException {
        SimpleEntry.checkNull(prop);
        if (!this.hasPropertyWithName(prop.getName())) {
            return;
        }
        this.modifyPropertyValue(prop.getName(), prop.getValue());
    }

    public boolean hasProp(JposEntry.Prop prop) {
        return this.hasPropertyWithName(prop.getName());
    }

    public JposEntry.Prop createProp(String propName, Object propValue, Class propType) throws JposConfigException {
        if (propName == null || propValue == null || propType == null) {
            throw new JposConfigException("Cannot create JposEntry.Prop with null argument");
        }
        if (!JposEntryUtility.validatePropValue(propValue, propType)) {
            throw new JposConfigException("Cannot create JposEntry.Prop with invalid value or type");
        }
        return new Prop(propName, propValue);
    }

    public boolean equals(Object object) {
        if (object instanceof JposEntry) {
            return this.equals((JposEntry)object);
        }
        return false;
    }

    public int compareTo(Object other) {
        if (other == null || !(other instanceof JposEntry)) {
            throw new RuntimeException("Cannot compare: " + other + " with JposEntry: " + this);
        }
        JposEntry otherEntry = (JposEntry)other;
        if (this.equals(otherEntry)) {
            return 0;
        }
        return this.getLogicalName().compareTo(otherEntry.getLogicalName());
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("<JposEntry logicalName=\"" + this.getPropertyValue("logicalName") + "\">\n");
        sb.append("\t<creation factoryClass=\"" + this.getPropertyValue("serviceInstanceFactoryClass") + "\" serviceClass=\"" + this.getPropertyValue("serviceClass") + "\"/>\n");
        sb.append("\t<vendor name=\"" + this.getPropertyValue("vendorName") + "\" url=\"" + this.getPropertyValue("vendorURL") + "\"/>\n");
        sb.append("\t<jpos category=\"" + this.getPropertyValue("deviceCategory") + "\" version=\"" + this.getPropertyValue("jposVersion") + "\"/>\n");
        sb.append("\t<product description=\"" + this.getPropertyValue("productDescription") + "\" name=\"" + this.getPropertyValue("productName") + "\" url=\"" + this.getPropertyValue("productURL") + "\"/>\n");
        sb.append("\n");
        Enumeration otherPropNames = JposEntryUtility.getNonRequiredPropNames(this);
        while (otherPropNames.hasMoreElements()) {
            String name = (String)otherPropNames.nextElement();
            String value = this.getPropertyValue(name).toString();
            String typeClassName = JposEntryUtility.shortClassName(this.getPropertyValue(name).getClass());
            sb.append("\t<prop name=\"" + name + "\" value=\"" + value + "\" type=\"" + typeClassName + "\"/>\n");
        }
        sb.append("</JposEntry>\n");
        return sb.toString();
    }

    void setRegPopulator(JposRegPopulator populator) {
        this.regPopulator = populator;
    }

    protected static void checkNull(Object object) throws IllegalArgumentException {
        if (object == null) {
            throw new IllegalArgumentException("Invalid null argument passed for a JposEntry property value or name");
        }
    }

    public static class Prop
    implements JposEntry.Prop,
    Comparable {
        private String name = "";
        private Object value = null;
        private Class typeClass = null;

        public Prop(String name, Object value) throws IllegalArgumentException {
            SimpleEntry.checkNull(name);
            SimpleEntry.checkNull(value);
            this.name = name;
            this.value = value;
            this.typeClass = value.getClass();
        }

        public String getName() {
            return this.name;
        }

        public Object getValue() {
            return this.value;
        }

        public String getValueAsString() {
            return String.valueOf(this.value);
        }

        public Class getType() {
            return this.typeClass;
        }

        public void setName(String s) throws IllegalArgumentException {
            SimpleEntry.checkNull(s);
            this.name = s;
        }

        public void setValue(Object objValue) throws IllegalArgumentException {
            SimpleEntry.checkNull(objValue);
            if (!JposEntryUtility.validatePropValue(objValue, objValue.getClass())) {
                throw new IllegalArgumentException("Cannot set property named = " + this.getName() + " with value = " + objValue + " invalid value or type");
            }
            this.setValue(objValue, objValue.getClass());
        }

        public boolean isOfType(Class type) {
            if (type == null || this.typeClass == null) {
                return false;
            }
            return this.typeClass.equals(type);
        }

        public JposEntry.Prop copy() {
            return new Prop(this.getName(), this.getValue());
        }

        public boolean equals(Object otherProp) {
            if (otherProp == null) {
                return false;
            }
            if (!(otherProp instanceof JposEntry.Prop)) {
                return false;
            }
            JposEntry.Prop prop = (JposEntry.Prop)otherProp;
            return this.getName().equals(prop.getName()) && this.getValue().equals(prop.getValue());
        }

        public int compareTo(Object other) {
            if (other == null || !(other instanceof JposEntry.Prop)) {
                throw new RuntimeException("Cannot compare: " + other + " with JposEntry.Prop: " + this);
            }
            JposEntry.Prop otherEntryProp = (JposEntry.Prop)other;
            if (this.equals(otherEntryProp)) {
                return 0;
            }
            return this.getName().compareTo(otherEntryProp.getName());
        }

        public int hashCode() {
            return this.getName().hashCode();
        }

        private void setValue(Object object, Class type) throws IllegalArgumentException {
            SimpleEntry.checkNull(object);
            SimpleEntry.checkNull(type);
            if (!object.getClass().equals(type)) {
                throw new IllegalArgumentException("Value and value type not in agreement for property named = " + this.name);
            }
            this.value = object;
            this.typeClass = type;
        }
    }
}

