/*
 * Decompiled with CFR 0.152.
 */
package jpos;

import java.util.Vector;
import jpos.BaseControl;
import jpos.BaseJposControl;
import jpos.JposConst;
import jpos.JposException;
import jpos.POSKeyboardControl114;
import jpos.events.DataEvent;
import jpos.events.DataListener;
import jpos.events.DirectIOEvent;
import jpos.events.DirectIOListener;
import jpos.events.ErrorEvent;
import jpos.events.ErrorListener;
import jpos.events.OutputCompleteEvent;
import jpos.events.StatusUpdateEvent;
import jpos.events.StatusUpdateListener;
import jpos.services.BaseService;
import jpos.services.EventCallbacks;
import jpos.services.POSKeyboardService110;
import jpos.services.POSKeyboardService111;
import jpos.services.POSKeyboardService112;
import jpos.services.POSKeyboardService113;
import jpos.services.POSKeyboardService114;
import jpos.services.POSKeyboardService12;
import jpos.services.POSKeyboardService13;
import jpos.services.POSKeyboardService14;
import jpos.services.POSKeyboardService15;
import jpos.services.POSKeyboardService16;
import jpos.services.POSKeyboardService17;
import jpos.services.POSKeyboardService18;
import jpos.services.POSKeyboardService19;

public class POSKeyboard
extends BaseJposControl
implements POSKeyboardControl114,
JposConst {
    protected POSKeyboardService12 service12;
    protected POSKeyboardService13 service13;
    protected POSKeyboardService14 service14;
    protected POSKeyboardService15 service15;
    protected POSKeyboardService16 service16;
    protected POSKeyboardService17 service17;
    protected POSKeyboardService18 service18;
    protected POSKeyboardService19 service19;
    protected POSKeyboardService110 service110;
    protected POSKeyboardService111 service111;
    protected POSKeyboardService112 service112;
    protected POSKeyboardService113 service113;
    protected POSKeyboardService114 service114;
    protected Vector dataListeners;
    protected Vector directIOListeners;
    protected Vector errorListeners;
    protected Vector statusUpdateListeners;

    public POSKeyboard() {
        this.deviceControlDescription = "JavaPOS POSKeyboard Device Control";
        this.deviceControlVersion = 1014000;
        this.dataListeners = new Vector();
        this.directIOListeners = new Vector();
        this.errorListeners = new Vector();
        this.statusUpdateListeners = new Vector();
    }

    public boolean getCapKeyUp() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service12.getCapKeyUp();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public int getCapPowerReporting() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1003000) {
            throw new JposException(104, "Device Service is not 1.3.0 compliant.");
        }
        try {
            return this.service13.getCapPowerReporting();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public boolean getCapStatisticsReporting() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1008000) {
            throw new JposException(104, "Device Service is not 1.8.0 compliant.");
        }
        try {
            return this.service18.getCapStatisticsReporting();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public boolean getCapUpdateStatistics() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1008000) {
            throw new JposException(104, "Device Service is not 1.8.0 compliant.");
        }
        try {
            return this.service18.getCapUpdateStatistics();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public boolean getCapCompareFirmwareVersion() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1009000) {
            throw new JposException(104, "Device Service is not 1.9.0 compliant.");
        }
        try {
            return this.service19.getCapCompareFirmwareVersion();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public boolean getCapUpdateFirmware() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1009000) {
            throw new JposException(104, "Device Service is not 1.9.0 compliant.");
        }
        try {
            return this.service19.getCapUpdateFirmware();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public boolean getAutoDisable() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service12.getAutoDisable();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public void setAutoDisable(boolean autoDisable) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service12.setAutoDisable(autoDisable);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public int getDataCount() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service12.getDataCount();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public boolean getDataEventEnabled() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service12.getDataEventEnabled();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public void setDataEventEnabled(boolean dataEventEnabled) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service12.setDataEventEnabled(dataEventEnabled);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public int getEventTypes() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service12.getEventTypes();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public void setEventTypes(int eventTypes) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service12.setEventTypes(eventTypes);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public int getPOSKeyData() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service12.getPOSKeyData();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public int getPOSKeyEventType() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service12.getPOSKeyEventType();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public int getPowerNotify() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1003000) {
            throw new JposException(104, "Device Service is not 1.3.0 compliant.");
        }
        try {
            return this.service13.getPowerNotify();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public void setPowerNotify(int powerNotify) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1003000) {
            throw new JposException(104, "Device Service is not 1.3.0 compliant.");
        }
        try {
            this.service13.setPowerNotify(powerNotify);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public int getPowerState() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1003000) {
            throw new JposException(104, "Device Service is not 1.3.0 compliant.");
        }
        try {
            return this.service13.getPowerState();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public void clearInput() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service12.clearInput();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public void resetStatistics(String statisticsBuffer) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1008000) {
            throw new JposException(104, "Device Service is not 1.8.0 compliant.");
        }
        try {
            this.service18.resetStatistics(statisticsBuffer);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public void retrieveStatistics(String[] statisticsBuffer) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1008000) {
            throw new JposException(104, "Device Service is not 1.8.0 compliant.");
        }
        try {
            this.service18.retrieveStatistics(statisticsBuffer);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public void updateStatistics(String statisticsBuffer) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1008000) {
            throw new JposException(104, "Device Service is not 1.8.0 compliant.");
        }
        try {
            this.service18.updateStatistics(statisticsBuffer);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public void compareFirmwareVersion(String firmwareFileName, int[] result) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1009000) {
            throw new JposException(104, "Device Service is not 1.9.0 compliant.");
        }
        try {
            this.service19.compareFirmwareVersion(firmwareFileName, result);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public void updateFirmware(String firmwareFileName) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1009000) {
            throw new JposException(104, "Device Service is not 1.9.0 compliant.");
        }
        try {
            this.service19.updateFirmware(firmwareFileName);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    protected EventCallbacks createEventCallbacks() {
        return new POSKeyboardCallbacks();
    }

    protected void setDeviceService(BaseService service, int nServiceVersion) throws JposException {
        if (service == null) {
            this.service12 = null;
            this.service13 = null;
            this.service14 = null;
            this.service15 = null;
            this.service16 = null;
            this.service17 = null;
            this.service18 = null;
            this.service19 = null;
            this.service110 = null;
            this.service111 = null;
            this.service112 = null;
            this.service113 = null;
            this.service114 = null;
        } else {
            if (this.serviceVersion >= 1002000) {
                try {
                    this.service12 = (POSKeyboardService12)service;
                }
                catch (Exception e) {
                    throw new JposException(104, "Service does not fully implement POSKeyboardService12 interface", e);
                }
            }
            if (this.serviceVersion >= 1003000) {
                try {
                    this.service13 = (POSKeyboardService13)service;
                }
                catch (Exception e) {
                    throw new JposException(104, "Service does not fully implement POSKeyboardService13 interface", e);
                }
            }
            if (this.serviceVersion >= 1004000) {
                try {
                    this.service14 = (POSKeyboardService14)service;
                }
                catch (Exception e) {
                    throw new JposException(104, "Service does not fully implement POSKeyboardService14 interface", e);
                }
            }
            if (this.serviceVersion >= 1005000) {
                try {
                    this.service15 = (POSKeyboardService15)service;
                }
                catch (Exception e) {
                    throw new JposException(104, "Service does not fully implement POSKeyboardService15 interface", e);
                }
            }
            if (this.serviceVersion >= 1006000) {
                try {
                    this.service16 = (POSKeyboardService16)service;
                }
                catch (Exception e) {
                    throw new JposException(104, "Service does not fully implement POSKeyboardService16 interface", e);
                }
            }
            if (this.serviceVersion >= 1007000) {
                try {
                    this.service17 = (POSKeyboardService17)service;
                }
                catch (Exception e) {
                    throw new JposException(104, "Service does not fully implement POSKeyboardService17 interface", e);
                }
            }
            if (this.serviceVersion >= 1008000) {
                try {
                    this.service18 = (POSKeyboardService18)service;
                }
                catch (Exception e) {
                    throw new JposException(104, "Service does not fully implement POSKeyboardService18 interface", e);
                }
            }
            if (this.serviceVersion >= 1009000) {
                try {
                    this.service19 = (POSKeyboardService19)service;
                }
                catch (Exception e) {
                    throw new JposException(104, "Service does not fully implement POSKeyboardService19 interface", e);
                }
            }
            if (this.serviceVersion >= 1010000) {
                try {
                    this.service110 = (POSKeyboardService110)service;
                }
                catch (Exception e) {
                    throw new JposException(104, "Service does not fully implement POSKeyboardService110 interface", e);
                }
            }
            if (this.serviceVersion >= 1011000) {
                try {
                    this.service111 = (POSKeyboardService111)service;
                }
                catch (Exception e) {
                    throw new JposException(104, "Service does not fully implement POSKeyboardService111 interface", e);
                }
            }
            if (this.serviceVersion >= 1012000) {
                try {
                    this.service112 = (POSKeyboardService112)service;
                }
                catch (Exception e) {
                    throw new JposException(104, "Service does not fully implement POSKeyboardService112 interface", e);
                }
            }
            if (this.serviceVersion >= 1013000) {
                try {
                    this.service113 = (POSKeyboardService113)service;
                }
                catch (Exception e) {
                    throw new JposException(104, "Service does not fully implement POSKeyboardService113 interface", e);
                }
            }
            if (this.serviceVersion >= 1014000) {
                try {
                    this.service114 = (POSKeyboardService114)service;
                }
                catch (Exception e) {
                    throw new JposException(104, "Service does not fully implement POSKeyboardService114 interface", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDataListener(DataListener l) {
        Vector vector = this.dataListeners;
        synchronized (vector) {
            this.dataListeners.addElement(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDataListener(DataListener l) {
        Vector vector = this.dataListeners;
        synchronized (vector) {
            this.dataListeners.removeElement(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDirectIOListener(DirectIOListener l) {
        Vector vector = this.directIOListeners;
        synchronized (vector) {
            this.directIOListeners.addElement(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDirectIOListener(DirectIOListener l) {
        Vector vector = this.directIOListeners;
        synchronized (vector) {
            this.directIOListeners.removeElement(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addErrorListener(ErrorListener l) {
        Vector vector = this.errorListeners;
        synchronized (vector) {
            this.errorListeners.addElement(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeErrorListener(ErrorListener l) {
        Vector vector = this.errorListeners;
        synchronized (vector) {
            this.errorListeners.removeElement(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStatusUpdateListener(StatusUpdateListener l) {
        Vector vector = this.statusUpdateListeners;
        synchronized (vector) {
            this.statusUpdateListeners.addElement(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeStatusUpdateListener(StatusUpdateListener l) {
        Vector vector = this.statusUpdateListeners;
        synchronized (vector) {
            this.statusUpdateListeners.removeElement(l);
        }
    }

    protected class POSKeyboardCallbacks
    implements EventCallbacks {
        protected POSKeyboardCallbacks() {
        }

        public BaseControl getEventSource() {
            return POSKeyboard.this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fireDataEvent(DataEvent e) {
            Vector vector = POSKeyboard.this.dataListeners;
            synchronized (vector) {
                for (int x = 0; x < POSKeyboard.this.dataListeners.size(); ++x) {
                    ((DataListener)POSKeyboard.this.dataListeners.elementAt(x)).dataOccurred(e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fireDirectIOEvent(DirectIOEvent e) {
            Vector vector = POSKeyboard.this.directIOListeners;
            synchronized (vector) {
                for (int x = 0; x < POSKeyboard.this.directIOListeners.size(); ++x) {
                    ((DirectIOListener)POSKeyboard.this.directIOListeners.elementAt(x)).directIOOccurred(e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fireErrorEvent(ErrorEvent e) {
            Vector vector = POSKeyboard.this.errorListeners;
            synchronized (vector) {
                for (int x = 0; x < POSKeyboard.this.errorListeners.size(); ++x) {
                    ((ErrorListener)POSKeyboard.this.errorListeners.elementAt(x)).errorOccurred(e);
                }
            }
        }

        public void fireOutputCompleteEvent(OutputCompleteEvent e) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fireStatusUpdateEvent(StatusUpdateEvent e) {
            Vector vector = POSKeyboard.this.statusUpdateListeners;
            synchronized (vector) {
                for (int x = 0; x < POSKeyboard.this.statusUpdateListeners.size(); ++x) {
                    ((StatusUpdateListener)POSKeyboard.this.statusUpdateListeners.elementAt(x)).statusUpdateOccurred(e);
                }
            }
        }
    }
}

