/*
 * Decompiled with CFR 0.152.
 */
package pl.novitus.javapos.service.impl.printer;

import java.math.BigDecimal;
import java.util.LinkedHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pl.novitus.javapos.data.POSReport;
import pl.novitus.javapos.data.TaxRate;
import pl.novitus.javapos.service.impl.printer.LegacyServiceBase;
import pl.novitus.javapos.service.impl.printer.LegacyTaxRatesService;
import pl.novitus.javapos.utils.FiscalDeviceException;
import pl.novitus.javapos.utils.printer.LegacyPacketBuilder;
import pl.novitus.javapos.utils.printer.LegacyPacketParser;

public class LegacyPOSReportService
extends LegacyServiceBase {
    private static final Logger log = LogManager.getLogger(LegacyTaxRatesService.class);

    public POSReport getReport(int mode) throws FiscalDeviceException {
        LegacyPacketBuilder builder = new LegacyPacketBuilder();
        String request = builder.begin().add("", mode).addType("#s").end().toString();
        this.getProtocol().sendPacket(request);
        String response = this.getProtocol().receivePacket();
        LegacyPacketParser parser = new LegacyPacketParser("2#X");
        parser.parse(response);
        POSReport result = new POSReport();
        result.setLastError(Integer.parseInt(parser.getValues().get("1")));
        result.setFiscal(Integer.parseInt(parser.getValues().get("1")) == 1);
        result.setInTransaction(Integer.parseInt(parser.getValues().get("3")) == 1);
        result.setTransactionOk(Integer.parseInt(parser.getValues().get("4")) == 1);
        result.setResetCount(Integer.parseInt(parser.getValues().get("6")));
        result.setYear(Integer.parseInt(parser.getValues().get("7")) + 2000);
        result.setMonth(Integer.parseInt(parser.getValues().get("8")));
        result.setDay(Integer.parseInt(parser.getValues().get("9")));
        result.setReceiptCount(Integer.parseInt(parser.getValues().get("17")));
        result.setCash(new BigDecimal(parser.getValues().get("25")));
        result.setUniqueNumber(parser.getValues().get("26"));
        LinkedHashMap<String, TaxRate> taxRates = result.getTaxRates();
        for (int i = 0; i < 7; ++i) {
            String dkey = String.valueOf((char)(65 + i));
            String skey = Integer.toString(i + 10);
            String v = parser.getValues().get(skey);
            BigDecimal dv = v.isEmpty() ? new BigDecimal("98.99") : new BigDecimal(v);
            TaxRate tr = new TaxRate(dv);
            taxRates.put(dkey, tr);
            log.debug("getTaxRates(): Tax rate " + dkey + ": " + tr.toString());
        }
        LinkedHashMap<String, BigDecimal> totalizers = result.getTotalizers();
        for (int i = 0; i < 7; ++i) {
            String dkey = String.valueOf((char)(65 + i));
            String skey = Integer.toString(i + 18);
            String v = parser.getValues().get(skey);
            BigDecimal dv = v.isEmpty() ? new BigDecimal("99.99") : new BigDecimal(v);
            totalizers.put(dkey, dv);
            log.debug("getTaxRates(): Totalizer " + dkey + ": " + dv);
        }
        log.debug("getReport(): result: " + result.toString());
        return result;
    }

    public String getLastInvoiceNumber() throws FiscalDeviceException {
        LegacyPacketBuilder builder = new LegacyPacketBuilder();
        String request = builder.begin().addType("50#s").end().toString();
        this.getProtocol().sendPacket(request);
        String response = this.getProtocol().receivePacket();
        LegacyPacketParser parser = new LegacyPacketParser("50#X");
        parser.parse(response);
        String result = "0";
        result = parser.getValues().size() > 6 ? parser.getValues().get("3") : parser.getValues().get("2");
        return result;
    }

    public String getFirmwareVersion() throws FiscalDeviceException {
        LegacyPacketBuilder builder = new LegacyPacketBuilder();
        String request = builder.begin().addType("#v").end().toString();
        this.getProtocol().sendPacket(request);
        String response = this.getProtocol().receivePacket(true);
        LegacyPacketParser parser = new LegacyPacketParser("1#R");
        parser.parse(response);
        String result = parser.getValues().get("1") + " " + parser.getValues().get("2");
        return result;
    }

    public String getLastDailyReportNumber() throws FiscalDeviceException {
        LegacyPacketBuilder builder = new LegacyPacketBuilder();
        String request = builder.begin().addType("24#s").end().toString();
        this.getProtocol().sendPacket(request);
        String response = this.getProtocol().receivePacket();
        LegacyPacketParser parser = new LegacyPacketParser("3#X");
        parser.parse(response);
        String result = parser.getValues().get("4");
        return result;
    }

    public static interface Mode {
        public static final int TRANSACTION = 22;
        public static final int DAY = 23;
        public static final int CURRENCY = 99;
    }
}

