/*
 * Decompiled with CFR 0.152.
 */
package pl.novitus.javapos.data;

import java.math.BigDecimal;
import pl.novitus.javapos.utils.FiscalDeviceException;

public final class TaxRate {
    private Type type;
    private BigDecimal rate;

    public TaxRate() {
        this.setRate(Type.UNUSED);
    }

    public TaxRate(Type type) {
        this.setRate(type);
    }

    public TaxRate(BigDecimal rate) throws FiscalDeviceException {
        this.setRate(rate);
    }

    public Type getType() {
        return this.type;
    }

    public BigDecimal getRate() {
        return this.rate;
    }

    public void setRate(BigDecimal rate) throws FiscalDeviceException {
        if (rate.compareTo(new BigDecimal("98.99")) == 0) {
            this.type = Type.FREE;
        } else if (rate.compareTo(new BigDecimal("99.99")) == 0) {
            this.type = Type.UNUSED;
        } else if (rate.compareTo(new BigDecimal("100")) == 0) {
            this.type = Type.FREE;
            rate = new BigDecimal("98.99");
        } else if (rate.compareTo(new BigDecimal("101")) == 0) {
            this.type = Type.UNUSED;
            rate = new BigDecimal("99.99");
        } else {
            if (rate.longValue() < 0L || rate.longValue() > 100L) {
                throw new FiscalDeviceException("Percentage tax rate out of range.");
            }
            this.type = Type.PERCENT;
        }
        this.rate = rate;
    }

    public void setRate(Type type) {
        this.rate = new BigDecimal(0);
        this.type = type;
    }

    public String toString() {
        return this.type == Type.PERCENT ? this.rate.toString() : (this.type == Type.FREE ? "FREE" : "UNUSED");
    }

    public static char taxIndexToTaxId(int index) {
        return (char)(65 + (char)(index - 1));
    }

    public static int taxIdToTaxIndex(char taxId) {
        return taxId - 65 + 1;
    }

    public static enum Type {
        UNUSED,
        FREE,
        PERCENT;

    }
}

