/*
 * Decompiled with CFR 0.152.
 */
package jpos.util;

import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Dictionary;
import java.util.Hashtable;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import jpos.util.PopupListener;

public class PopupHelper {
    static Dictionary dictionary = new Hashtable();
    static MouseListener popupMouseListener = new MouseAdapter(){

        void tryPopup(MouseEvent evt) {
            if (!evt.isPopupTrigger()) {
                return;
            }
            Component mouseEvtComp = evt.getComponent();
            Object[] o = (Object[])dictionary.get(mouseEvtComp);
            if (o == null) {
                return;
            }
            JPopupMenu popupMenu = (JPopupMenu)o[0];
            PopupListener popupListener = (PopupListener)o[1];
            int x = evt.getX();
            int y = evt.getY();
            boolean go = true;
            if (popupListener != null) {
                go = popupListener.startPopup(x, y);
            }
            if (go) {
                popupMenu.show(mouseEvtComp, x - 20, y - 10);
            }
        }

        public void mousePressed(MouseEvent evt) {
            this.tryPopup(evt);
        }

        public void mouseReleased(MouseEvent evt) {
            this.tryPopup(evt);
        }
    };

    public static void setPopup(JComponent mouseEvtComp, JPopupMenu popupMenu) {
        PopupHelper.setPopup(mouseEvtComp, popupMenu, null);
    }

    public static void setPopup(JComponent mouseEvtComp, JPopupMenu popupMenu, PopupListener popupListener) {
        Object[] o = new Object[]{popupMenu, popupListener};
        dictionary.put(mouseEvtComp, o);
        mouseEvtComp.addMouseListener(popupMouseListener);
    }

    public static void removePopup(JComponent mouseEvtComp) {
        dictionary.remove(mouseEvtComp);
    }
}

