/*
 * Decompiled with CFR 0.152.
 */
package pl.novitus.javapos.utils.i18n;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pl.novitus.javapos.utils.i18n.XMLResourceBundleControl;

public class I18n {
    private static final Logger log = LogManager.getLogger(I18n.class);
    private static I18n instance = new I18n();
    ResourceBundle bundle = null;

    private I18n() {
        try {
            this.bundle = ResourceBundle.getBundle("messages", new XMLResourceBundleControl());
        }
        catch (Exception ex) {
            this.bundle = null;
            log.warn("Unable to find messages bundle for locale " + Locale.getDefault().toString());
        }
        if (this.bundle == null) {
            try {
                ResourceBundle.clearCache();
                this.bundle = ResourceBundle.getBundle("messages", new XMLResourceBundleControl(Locale.ENGLISH));
            }
            catch (Exception ex) {
                log.error("Unable to find English messages bundle. " + ex.getMessage());
                throw ex;
            }
        }
        log.debug("Translation services created for locale " + this.bundle.getLocale());
    }

    private static I18n getInstance() {
        return instance;
    }

    public static String tr(String key) {
        String s = "[[" + key + "]]";
        try {
            s = I18n.getInstance().bundle.getString(key);
        }
        catch (MissingResourceException ex) {
            log.error(String.format("Translation for [%s] not found.", key));
        }
        catch (Exception ex) {
            log.error(String.format("Error retrieving translation for [%s]: %s", key, ex.getMessage()));
        }
        return s;
    }
}

