/*
 * Decompiled with CFR 0.152.
 */
package pl.novitus.javapos.utils.printer;

import java.math.BigDecimal;
import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pl.novitus.javapos.utils.PacketBuilder;
import pl.novitus.javapos.utils.printer.LegacyPacketFieldSeparators;

public class LegacyPacketBuilder
implements PacketBuilder {
    private static final Logger log = LogManager.getLogger(PacketBuilder.class);
    private String data;

    @Override
    public PacketBuilder addRaw(String rawData) {
        this.data = this.data + rawData;
        return this;
    }

    @Override
    public PacketBuilder add(String name, String value) {
        return this.add(name, value, -1);
    }

    @Override
    public PacketBuilder add(String name, String value, int length) {
        if (length < 0 || length >= value.length()) {
            return this.addRaw(value);
        }
        return this.addRaw(value.substring(0, length));
    }

    @Override
    public PacketBuilder add(String name, String value, int length, char padding) {
        String tmp = "";
        if ((length -= value.length()) > 0) {
            tmp = new String(new char[length]).replace('\u0000', padding);
        }
        return this.addRaw(value + tmp);
    }

    @Override
    public PacketBuilder add(String name, int value) {
        return this.add(name, Integer.toString(value));
    }

    @Override
    public PacketBuilder add(String name, int value, int length) {
        return this.add(name, Integer.toString(value), length);
    }

    @Override
    public PacketBuilder add(String name, int value, int length, boolean zeroPadded) {
        return this.add(name, Integer.toString(value), length, zeroPadded ? (char)'0' : ' ');
    }

    @Override
    public PacketBuilder add(String name, double value) {
        return this.add(name, Double.toString(value));
    }

    @Override
    public PacketBuilder add(String name, double value, int decimals) {
        return this.add(name, value, decimals, -1);
    }

    @Override
    public PacketBuilder add(String name, double value, int decimals, int length) {
        String fmt = String.format("%%.%df", decimals);
        return this.add(name, String.format(Locale.ROOT, fmt, value), length);
    }

    @Override
    public PacketBuilder add(String name, boolean value) {
        return this.add(name, value, "0", "1");
    }

    @Override
    public PacketBuilder add(String name, boolean value, String falseVal, String trueVal) {
        return this.addRaw(value ? trueVal : falseVal);
    }

    @Override
    public PacketBuilder end() {
        return this;
    }

    @Override
    public PacketBuilder begin() {
        this.data = "";
        return this;
    }

    @Override
    public PacketBuilder fieldSeparator() {
        LegacyPacketFieldSeparators.instance();
        return this.addRaw(LegacyPacketFieldSeparators.getFieldSeparator());
    }

    @Override
    public PacketBuilder optionalFieldSeparator() {
        LegacyPacketFieldSeparators.instance();
        return this.addRaw(LegacyPacketFieldSeparators.getOptionalFieldSeparator());
    }

    @Override
    public PacketBuilder valueSeparator() {
        LegacyPacketFieldSeparators.instance();
        return this.addRaw(LegacyPacketFieldSeparators.getValueSeparator());
    }

    @Override
    public PacketBuilder stringSeparator() {
        LegacyPacketFieldSeparators.instance();
        return this.addRaw(LegacyPacketFieldSeparators.getStringSeparator());
    }

    @Override
    public PacketBuilder addType(String type) {
        return this.addRaw(type);
    }

    @Override
    public String toString() {
        return this.data;
    }

    public String getData() {
        return this.data;
    }

    @Override
    public PacketBuilder add(String name, BigDecimal value, int length) {
        return this.add("", value.toString(), length);
    }

    @Override
    public PacketBuilder add(String name, BigDecimal value) {
        return this.add("", value.toString(), -1);
    }
}

