/*
 * Decompiled with CFR 0.152.
 */
package jpos;

import java.util.Vector;
import jpos.BaseControl;
import jpos.BaseJposControl;
import jpos.JposConst;
import jpos.JposException;
import jpos.ToneIndicatorControl114;
import jpos.events.DataEvent;
import jpos.events.DirectIOEvent;
import jpos.events.DirectIOListener;
import jpos.events.ErrorEvent;
import jpos.events.ErrorListener;
import jpos.events.OutputCompleteEvent;
import jpos.events.OutputCompleteListener;
import jpos.events.StatusUpdateEvent;
import jpos.events.StatusUpdateListener;
import jpos.services.BaseService;
import jpos.services.EventCallbacks;
import jpos.services.ToneIndicatorService110;
import jpos.services.ToneIndicatorService111;
import jpos.services.ToneIndicatorService112;
import jpos.services.ToneIndicatorService113;
import jpos.services.ToneIndicatorService114;
import jpos.services.ToneIndicatorService12;
import jpos.services.ToneIndicatorService13;
import jpos.services.ToneIndicatorService14;
import jpos.services.ToneIndicatorService15;
import jpos.services.ToneIndicatorService16;
import jpos.services.ToneIndicatorService17;
import jpos.services.ToneIndicatorService18;
import jpos.services.ToneIndicatorService19;

public class ToneIndicator
extends BaseJposControl
implements ToneIndicatorControl114,
JposConst {
    protected ToneIndicatorService12 service12;
    protected ToneIndicatorService13 service13;
    protected ToneIndicatorService14 service14;
    protected ToneIndicatorService15 service15;
    protected ToneIndicatorService16 service16;
    protected ToneIndicatorService17 service17;
    protected ToneIndicatorService18 service18;
    protected ToneIndicatorService19 service19;
    protected ToneIndicatorService110 service110;
    protected ToneIndicatorService111 service111;
    protected ToneIndicatorService112 service112;
    protected ToneIndicatorService113 service113;
    protected ToneIndicatorService114 service114;
    protected Vector directIOListeners;
    protected Vector errorListeners;
    protected Vector outputCompleteListeners;
    protected Vector statusUpdateListeners;

    public ToneIndicator() {
        this.deviceControlDescription = "JavaPOS ToneIndicator Device Control";
        this.deviceControlVersion = 1014000;
        this.directIOListeners = new Vector();
        this.errorListeners = new Vector();
        this.outputCompleteListeners = new Vector();
        this.statusUpdateListeners = new Vector();
    }

    public boolean getCapPitch() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service12.getCapPitch();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public boolean getCapVolume() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service12.getCapVolume();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public int getCapPowerReporting() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1003000) {
            throw new JposException(104, "Device Service is not 1.3.0 compliant.");
        }
        try {
            return this.service13.getCapPowerReporting();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public boolean getCapStatisticsReporting() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1008000) {
            throw new JposException(104, "Device Service is not 1.8.0 compliant.");
        }
        try {
            return this.service18.getCapStatisticsReporting();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public boolean getCapUpdateStatistics() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1008000) {
            throw new JposException(104, "Device Service is not 1.8.0 compliant.");
        }
        try {
            return this.service18.getCapUpdateStatistics();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public boolean getCapCompareFirmwareVersion() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1009000) {
            throw new JposException(104, "Device Service is not 1.9.0 compliant.");
        }
        try {
            return this.service19.getCapCompareFirmwareVersion();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public boolean getCapUpdateFirmware() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1009000) {
            throw new JposException(104, "Device Service is not 1.9.0 compliant.");
        }
        try {
            return this.service19.getCapUpdateFirmware();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public int getCapMelody() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1013000) {
            throw new JposException(104, "Device Service is not 1.13.0 compliant.");
        }
        try {
            return this.service113.getCapMelody();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public boolean getAsyncMode() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service12.getAsyncMode();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public void setAsyncMode(boolean asyncMode) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service12.setAsyncMode(asyncMode);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public int getInterToneWait() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service12.getInterToneWait();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public void setInterToneWait(int interToneWait) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service12.setInterToneWait(interToneWait);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public int getOutputID() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service12.getOutputID();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public int getTone1Duration() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service12.getTone1Duration();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public void setTone1Duration(int tone1Duration) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service12.setTone1Duration(tone1Duration);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public int getTone1Pitch() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service12.getTone1Pitch();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public void setTone1Pitch(int tone1Pitch) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service12.setTone1Pitch(tone1Pitch);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public int getTone1Volume() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service12.getTone1Volume();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public void setTone1Volume(int tone1Volume) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service12.setTone1Volume(tone1Volume);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public int getTone2Duration() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service12.getTone2Duration();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public void setTone2Duration(int tone2Duration) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service12.setTone2Duration(tone2Duration);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public int getTone2Pitch() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service12.getTone2Pitch();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public void setTone2Pitch(int tone2Pitch) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service12.setTone2Pitch(tone2Pitch);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public int getTone2Volume() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service12.getTone2Volume();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public void setTone2Volume(int tone2Volume) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service12.setTone2Volume(tone2Volume);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public int getPowerNotify() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1003000) {
            throw new JposException(104, "Device Service is not 1.3.0 compliant.");
        }
        try {
            return this.service13.getPowerNotify();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public void setPowerNotify(int powerNotify) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1003000) {
            throw new JposException(104, "Device Service is not 1.3.0 compliant.");
        }
        try {
            this.service13.setPowerNotify(powerNotify);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public int getPowerState() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1003000) {
            throw new JposException(104, "Device Service is not 1.3.0 compliant.");
        }
        try {
            return this.service13.getPowerState();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public int getMelodyType() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1013000) {
            throw new JposException(104, "Device Service is not 1.13.0 compliant.");
        }
        try {
            return this.service113.getMelodyType();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public void setMelodyType(int melodyType) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1013000) {
            throw new JposException(104, "Device Service is not 1.13.0 compliant.");
        }
        try {
            this.service113.setMelodyType(melodyType);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public int getMelodyVolume() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1013000) {
            throw new JposException(104, "Device Service is not 1.13.0 compliant.");
        }
        try {
            return this.service113.getMelodyVolume();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public void setMelodyVolume(int melodyVolume) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1013000) {
            throw new JposException(104, "Device Service is not 1.13.0 compliant.");
        }
        try {
            this.service113.setMelodyVolume(melodyVolume);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public void clearOutput() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service12.clearOutput();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public void sound(int numberOfCycles, int interSoundWait) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service12.sound(numberOfCycles, interSoundWait);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public void soundImmediate() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service12.soundImmediate();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public void resetStatistics(String statisticsBuffer) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1008000) {
            throw new JposException(104, "Device Service is not 1.8.0 compliant.");
        }
        try {
            this.service18.resetStatistics(statisticsBuffer);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public void retrieveStatistics(String[] statisticsBuffer) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1008000) {
            throw new JposException(104, "Device Service is not 1.8.0 compliant.");
        }
        try {
            this.service18.retrieveStatistics(statisticsBuffer);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public void updateStatistics(String statisticsBuffer) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1008000) {
            throw new JposException(104, "Device Service is not 1.8.0 compliant.");
        }
        try {
            this.service18.updateStatistics(statisticsBuffer);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public void compareFirmwareVersion(String firmwareFileName, int[] result) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1009000) {
            throw new JposException(104, "Device Service is not 1.9.0 compliant.");
        }
        try {
            this.service19.compareFirmwareVersion(firmwareFileName, result);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public void updateFirmware(String firmwareFileName) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1009000) {
            throw new JposException(104, "Device Service is not 1.9.0 compliant.");
        }
        try {
            this.service19.updateFirmware(firmwareFileName);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    protected EventCallbacks createEventCallbacks() {
        return new ToneIndicatorCallbacks();
    }

    protected void setDeviceService(BaseService service, int nServiceVersion) throws JposException {
        if (service == null) {
            this.service12 = null;
            this.service13 = null;
            this.service14 = null;
            this.service15 = null;
            this.service16 = null;
            this.service17 = null;
            this.service18 = null;
            this.service19 = null;
            this.service110 = null;
            this.service111 = null;
            this.service112 = null;
            this.service113 = null;
            this.service114 = null;
        } else {
            if (this.serviceVersion >= 1002000) {
                try {
                    this.service12 = (ToneIndicatorService12)service;
                }
                catch (Exception e) {
                    throw new JposException(104, "Service does not fully implement ToneIndicatorService12 interface", e);
                }
            }
            if (this.serviceVersion >= 1003000) {
                try {
                    this.service13 = (ToneIndicatorService13)service;
                }
                catch (Exception e) {
                    throw new JposException(104, "Service does not fully implement ToneIndicatorService13 interface", e);
                }
            }
            if (this.serviceVersion >= 1004000) {
                try {
                    this.service14 = (ToneIndicatorService14)service;
                }
                catch (Exception e) {
                    throw new JposException(104, "Service does not fully implement ToneIndicatorService14 interface", e);
                }
            }
            if (this.serviceVersion >= 1005000) {
                try {
                    this.service15 = (ToneIndicatorService15)service;
                }
                catch (Exception e) {
                    throw new JposException(104, "Service does not fully implement ToneIndicatorService15 interface", e);
                }
            }
            if (this.serviceVersion >= 1006000) {
                try {
                    this.service16 = (ToneIndicatorService16)service;
                }
                catch (Exception e) {
                    throw new JposException(104, "Service does not fully implement ToneIndicatorService16 interface", e);
                }
            }
            if (this.serviceVersion >= 1007000) {
                try {
                    this.service17 = (ToneIndicatorService17)service;
                }
                catch (Exception e) {
                    throw new JposException(104, "Service does not fully implement ToneIndicatorService17 interface", e);
                }
            }
            if (this.serviceVersion >= 1008000) {
                try {
                    this.service18 = (ToneIndicatorService18)service;
                }
                catch (Exception e) {
                    throw new JposException(104, "Service does not fully implement ToneIndicatorService18 interface", e);
                }
            }
            if (this.serviceVersion >= 1009000) {
                try {
                    this.service19 = (ToneIndicatorService19)service;
                }
                catch (Exception e) {
                    throw new JposException(104, "Service does not fully implement ToneIndicatorService19 interface", e);
                }
            }
            if (this.serviceVersion >= 1010000) {
                try {
                    this.service110 = (ToneIndicatorService110)service;
                }
                catch (Exception e) {
                    throw new JposException(104, "Service does not fully implement ToneIndicatorService110 interface", e);
                }
            }
            if (this.serviceVersion >= 1011000) {
                try {
                    this.service111 = (ToneIndicatorService111)service;
                }
                catch (Exception e) {
                    throw new JposException(104, "Service does not fully implement ToneIndicatorService111 interface", e);
                }
            }
            if (this.serviceVersion >= 1012000) {
                try {
                    this.service112 = (ToneIndicatorService112)service;
                }
                catch (Exception e) {
                    throw new JposException(104, "Service does not fully implement ToneIndicatorService112 interface", e);
                }
            }
            if (this.serviceVersion >= 1013000) {
                try {
                    this.service113 = (ToneIndicatorService113)service;
                }
                catch (Exception e) {
                    throw new JposException(104, "Service does not fully implement ToneIndicatorService113 interface", e);
                }
            }
            if (this.serviceVersion >= 1014000) {
                try {
                    this.service114 = (ToneIndicatorService114)service;
                }
                catch (Exception e) {
                    throw new JposException(104, "Service does not fully implement ToneIndicatorService114 interface", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDirectIOListener(DirectIOListener l) {
        Vector vector = this.directIOListeners;
        synchronized (vector) {
            this.directIOListeners.addElement(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDirectIOListener(DirectIOListener l) {
        Vector vector = this.directIOListeners;
        synchronized (vector) {
            this.directIOListeners.removeElement(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addErrorListener(ErrorListener l) {
        Vector vector = this.errorListeners;
        synchronized (vector) {
            this.errorListeners.addElement(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeErrorListener(ErrorListener l) {
        Vector vector = this.errorListeners;
        synchronized (vector) {
            this.errorListeners.removeElement(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOutputCompleteListener(OutputCompleteListener l) {
        Vector vector = this.outputCompleteListeners;
        synchronized (vector) {
            this.outputCompleteListeners.addElement(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeOutputCompleteListener(OutputCompleteListener l) {
        Vector vector = this.outputCompleteListeners;
        synchronized (vector) {
            this.outputCompleteListeners.removeElement(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStatusUpdateListener(StatusUpdateListener l) {
        Vector vector = this.statusUpdateListeners;
        synchronized (vector) {
            this.statusUpdateListeners.addElement(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeStatusUpdateListener(StatusUpdateListener l) {
        Vector vector = this.statusUpdateListeners;
        synchronized (vector) {
            this.statusUpdateListeners.removeElement(l);
        }
    }

    protected class ToneIndicatorCallbacks
    implements EventCallbacks {
        protected ToneIndicatorCallbacks() {
        }

        public BaseControl getEventSource() {
            return ToneIndicator.this;
        }

        public void fireDataEvent(DataEvent e) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fireDirectIOEvent(DirectIOEvent e) {
            Vector vector = ToneIndicator.this.directIOListeners;
            synchronized (vector) {
                for (int x = 0; x < ToneIndicator.this.directIOListeners.size(); ++x) {
                    ((DirectIOListener)ToneIndicator.this.directIOListeners.elementAt(x)).directIOOccurred(e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fireErrorEvent(ErrorEvent e) {
            Vector vector = ToneIndicator.this.errorListeners;
            synchronized (vector) {
                for (int x = 0; x < ToneIndicator.this.errorListeners.size(); ++x) {
                    ((ErrorListener)ToneIndicator.this.errorListeners.elementAt(x)).errorOccurred(e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fireOutputCompleteEvent(OutputCompleteEvent e) {
            Vector vector = ToneIndicator.this.outputCompleteListeners;
            synchronized (vector) {
                for (int x = 0; x < ToneIndicator.this.outputCompleteListeners.size(); ++x) {
                    ((OutputCompleteListener)ToneIndicator.this.outputCompleteListeners.elementAt(x)).outputCompleteOccurred(e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fireStatusUpdateEvent(StatusUpdateEvent e) {
            Vector vector = ToneIndicator.this.statusUpdateListeners;
            synchronized (vector) {
                for (int x = 0; x < ToneIndicator.this.statusUpdateListeners.size(); ++x) {
                    ((StatusUpdateListener)ToneIndicator.this.statusUpdateListeners.elementAt(x)).statusUpdateOccurred(e);
                }
            }
        }
    }
}

