/*
 * Decompiled with CFR 0.152.
 */
package pl.novitus.javapos.utils.connection;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Arrays;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pl.novitus.javapos.utils.ConnectionException;
import pl.novitus.javapos.utils.ConnectionTimeoutException;
import pl.novitus.javapos.utils.connection.SocketConnection;
import pl.novitus.javapos.utils.i18n.I18n;

public class UDPConnection
extends SocketConnection {
    private static final Logger log = LogManager.getLogger(UDPConnection.class);
    private DatagramSocket udpSocket;
    private InetAddress serverAddress;

    @Override
    protected void assertPortOpen() throws ConnectionException {
        if (this.udpSocket == null || !this.udpSocket.isConnected()) {
            throw new ConnectionException("strSocketNotConnected");
        }
    }

    @Override
    public int read() throws ConnectionException {
        byte[] res = this.read(1);
        try {
            return res[0];
        }
        catch (Exception ex) {
            String msg = String.format(I18n.tr("strSocketReadErrorNoData"), this.getServer(), this.getPort());
            log.error(msg);
            throw new ConnectionException(msg);
        }
    }

    @Override
    public byte[] read(int count) throws ConnectionException {
        this.assertPortOpen();
        byte[] buf = new byte[count];
        DatagramPacket p = new DatagramPacket(buf, count);
        try {
            this.udpSocket.receive(p);
            return Arrays.copyOf(buf, p.getLength());
        }
        catch (InterruptedIOException ex) {
            String msg = String.format(I18n.tr("strPortReadTimeout"), this.getServer());
            log.error(msg);
            throw new ConnectionTimeoutException(msg);
        }
        catch (IOException ex) {
            String msg = String.format(I18n.tr("strSocketReadError"), this.getServer(), this.getPort(), ex.getMessage());
            log.error(msg);
            throw new ConnectionException(msg);
        }
    }

    @Override
    public void write(int data) throws ConnectionException {
        byte[] buf = new byte[]{new Integer(data).byteValue()};
        this.write(buf);
    }

    @Override
    public void write(byte[] data) throws ConnectionException {
        this.assertPortOpen();
        DatagramPacket p = new DatagramPacket(data, data.length, this.serverAddress, this.getPort());
        try {
            this.udpSocket.send(p);
        }
        catch (IOException ex) {
            String msg = String.format(I18n.tr("strSocketWriteError"), this.getServer(), this.getPort(), ex.getMessage());
            log.error(msg);
            throw new ConnectionException(msg);
        }
    }

    @Override
    public void open() throws ConnectionException {
        try {
            log.debug(String.format("Opening UDP connection to %s, port %d", this.getServer(), this.getPort()));
            this.serverAddress = InetAddress.getByName(this.getServer());
            this.udpSocket = new DatagramSocket(this.getPort());
            this.udpSocket.setSoTimeout(this.getTimeout());
            this.udpSocket.connect(this.serverAddress, this.getPort());
            log.debug(String.format("Connection to %s:%d succeeded.", this.getServer(), this.getPort()));
        }
        catch (UnknownHostException ex) {
            log.error(String.format("Error: unknown host %s", this.getServer()));
            throw new ConnectionException(String.format(I18n.tr("strSocketUnknownHost"), this.getServer()));
        }
        catch (SocketException ex) {
            log.error(String.format("Error opening UDP socket: %s", ex.getMessage()));
            throw new ConnectionException(String.format(I18n.tr("strSocketSocketError"), ex.getMessage()));
        }
    }

    @Override
    public void close() throws ConnectionException {
        log.debug("Closing UDP connection");
        if (this.udpSocket != null) {
            this.udpSocket.close();
        }
        this.udpSocket = null;
        log.debug("UDP connection closed");
    }
}

