/*
 * Decompiled with CFR 0.152.
 */
package pl.novitus.javapos.utils.printer;

import java.util.LinkedHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pl.novitus.javapos.utils.FiscalDeviceException;
import pl.novitus.javapos.utils.PacketParser;
import pl.novitus.javapos.utils.i18n.I18n;
import pl.novitus.javapos.utils.printer.LegacyPacketFieldSeparators;

public final class LegacyPacketParser
implements PacketParser {
    private static final Logger log = LogManager.getLogger(LegacyPacketParser.class);
    private String packetType;
    private LinkedHashMap<String, String> values;

    public LegacyPacketParser(String packetType) {
        this.packetType = packetType;
        this.values = new LinkedHashMap();
    }

    @Override
    public void parse(String data) throws FiscalDeviceException {
        try {
            log.debug("Packet to parse: " + data);
            if (data == null || data.isEmpty()) {
                throw new Exception(I18n.tr("strNoPacketData"));
            }
            String packet = data;
            if (!packet.contains(this.packetType)) {
                throw new Exception(I18n.tr("strPacketTypeNotFound"));
            }
            int pti = packet.indexOf(this.packetType);
            String rpType = pti > 0 && !LegacyPacketFieldSeparators.instance().isSeparator(packet.charAt(pti - 1)) ? ";" + this.packetType + ";" : this.packetType + ";";
            String[] parts = (packet = packet.replace(this.packetType, rpType)).split(LegacyPacketFieldSeparators.instance().getSeparatorsAsRegex());
            if (parts.length < 1) {
                throw new Exception(I18n.tr("strPacketFieldsNotFound"));
            }
            this.values.clear();
            log.debug("Found " + parts.length + " fields.");
            for (int i = 0; i < parts.length; ++i) {
                log.debug("  field #" + i + ", value: " + parts[i]);
                this.values.put(Integer.toString(i), parts[i]);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new FiscalDeviceException(-1, e.getMessage());
        }
    }

    @Override
    public LinkedHashMap<String, String> getValues() {
        return this.values;
    }
}

