/*
 * Decompiled with CFR 0.152.
 */
package pl.novitus.javapos.factory;

import jpos.JposException;
import jpos.config.JposEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pl.novitus.javapos.factory.SerialPortConnectionFactory;
import pl.novitus.javapos.factory.SocketConnectionFactory;
import pl.novitus.javapos.utils.Connection;
import pl.novitus.javapos.utils.i18n.I18n;

public class DefaultConnectionFactory {
    private static final Logger log = LogManager.getLogger(DefaultConnectionFactory.class);
    protected static final String P_CONNECTION = "connection";
    protected static final String V_SERIAL = "serial";
    protected static final String V_TCP = "tcp";
    protected static final String V_UDP = "udp";

    private Connection createSerialConnection(JposEntry jposentry) throws JposException {
        return new SerialPortConnectionFactory().createSerialConnection(jposentry);
    }

    private Connection createTcpConnection(JposEntry jposentry) throws JposException {
        return new SocketConnectionFactory().createTCPConnection(jposentry);
    }

    private Connection createUdpConnection(JposEntry jposentry) throws JposException {
        return new SocketConnectionFactory().createUDPConnection(jposentry);
    }

    public Connection createInstance(JposEntry jposentry) throws JposException {
        if (!jposentry.hasPropertyWithName(P_CONNECTION)) {
            String msg = String.format(I18n.tr("strConnPropertyMissing"), P_CONNECTION);
            log.error(msg);
            throw new JposException(111, msg);
        }
        String conn = jposentry.getPropertyValue(P_CONNECTION).toString();
        log.debug(String.format("Service has connection type '%s'", conn));
        try {
            if (conn.equals(V_SERIAL)) {
                return this.createSerialConnection(jposentry);
            }
            if (conn.equals(V_TCP)) {
                return this.createTcpConnection(jposentry);
            }
            if (conn.equals(V_UDP)) {
                return this.createUdpConnection(jposentry);
            }
        }
        catch (JposException e) {
            log.error(String.format("Unable to create service. %s", e.getMessage()));
            throw e;
        }
        throw new JposException(111, String.format("Unknown connection type: '%s'", conn));
    }
}

