/*
 * Decompiled with CFR 0.152.
 */
package jpos.loader;

import java.lang.reflect.Constructor;
import jpos.JposException;
import jpos.loader.JposServiceConnection;
import jpos.loader.JposServiceManager;
import jpos.loader.simple.SimpleServiceManager;
import jpos.util.DefaultProperties;
import jpos.util.tracing.Tracer;
import jpos.util.tracing.TracerFactory;

public final class JposServiceLoader {
    private static Tracer tracer = TracerFactory.getInstance().createTracer("JposServiceLoader");
    private static JposServiceManager manager = null;

    public static JposServiceConnection findService(String logicalName) throws JposException {
        if (manager == null) {
            String msg = "Did not find a valid jpos.config.serviceManagerClass to create";
            tracer.println(msg);
            throw new JposException(104, msg);
        }
        tracer.println("findService: " + logicalName);
        return manager.createConnection(logicalName);
    }

    public static JposServiceManager getManager() {
        return manager;
    }

    static {
        DefaultProperties jposProperties = new DefaultProperties();
        jposProperties.loadJposProperties();
        boolean customManagerDefined = false;
        String customManagerClassName = "";
        if (jposProperties.isPropertyDefined("jpos.config.serviceManagerClass")) {
            customManagerDefined = true;
            customManagerClassName = jposProperties.getPropertyString("jpos.config.serviceManagerClass");
        } else if (jposProperties.isPropertyDefined("jpos.loader.serviceManagerClass")) {
            customManagerDefined = true;
            customManagerClassName = jposProperties.getPropertyString("jpos.loader.serviceManagerClass");
        }
        if (customManagerDefined) {
            tracer.println("Custom manager is defined: className= " + customManagerClassName);
            try {
                Class<?> managerClass = Class.forName(customManagerClassName);
                Class<?> arg1Class = Class.forName("jpos.util.JposProperties");
                Class[] argsClass = new Class[]{arg1Class};
                Constructor<?> oneArgCtor = managerClass.getConstructor(argsClass);
                Object[] args = new Object[]{jposProperties};
                manager = (JposServiceManager)oneArgCtor.newInstance(args);
            }
            catch (Exception e) {
                tracer.println("Error creating instance of specified jpos.config.serviceManagerClass class: " + customManagerClassName);
                tracer.println("Using default manager class: jpos.loader.simple.SimpleServiceManager");
                manager = new SimpleServiceManager(jposProperties);
            }
        } else {
            manager = new SimpleServiceManager(jposProperties);
        }
        manager.getEntryRegistry().load();
        tracer.println("manager.getEntryRegistry().load() OK");
    }
}

