/*
 * Decompiled with CFR 0.152.
 */
package pl.novitus.javapos.service.impl.printer;

import java.math.BigDecimal;
import jpos.JposException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pl.novitus.javapos.utils.FiscalDeviceException;
import pl.novitus.javapos.utils.Protocol;
import pl.novitus.javapos.utils.i18n.I18n;

public class LegacyServiceBase {
    private static final Logger log = LogManager.getLogger(LegacyServiceBase.class);
    private Protocol protocol;

    public Protocol getProtocol() {
        return this.protocol;
    }

    public void setProtocol(Protocol protocol) {
        this.protocol = protocol;
    }

    public String getErrorDescription(FiscalDeviceException e) {
        String msg = I18n.tr(String.format("strFPLError-%d", e.getError()));
        if (msg.startsWith("[[")) {
            msg = String.format(I18n.tr("strFPLError-unknown"), e.getError());
        }
        return msg;
    }

    public void translateError(FiscalDeviceException e) throws JposException {
        try {
            throw new JposException(111, e.getError(), this.getErrorDescription(e), (Exception)e);
        }
        catch (JposException ex) {
            log.error(ex.getMessage());
            throw ex;
        }
        catch (Exception ex) {
            log.error("Unexpected error: " + ex.getMessage());
            throw ex;
        }
    }

    public BigDecimal jposQuantityToQuantity(long quantity) {
        BigDecimal result = new BigDecimal(quantity);
        result = result.scaleByPowerOfTen(-3);
        return result;
    }

    public BigDecimal jposValueToValue(long value) {
        BigDecimal result = new BigDecimal(value);
        result = result.scaleByPowerOfTen(-4);
        return result;
    }
}

