/*
 * Decompiled with CFR 0.152.
 */
package jpos;

import java.util.Vector;
import jpos.BaseControl;
import jpos.BaseJposControl;
import jpos.JposConst;
import jpos.JposException;
import jpos.PointCardRWControl114;
import jpos.events.DataEvent;
import jpos.events.DataListener;
import jpos.events.DirectIOEvent;
import jpos.events.DirectIOListener;
import jpos.events.ErrorEvent;
import jpos.events.ErrorListener;
import jpos.events.OutputCompleteEvent;
import jpos.events.OutputCompleteListener;
import jpos.events.StatusUpdateEvent;
import jpos.events.StatusUpdateListener;
import jpos.services.BaseService;
import jpos.services.EventCallbacks;
import jpos.services.PointCardRWService110;
import jpos.services.PointCardRWService111;
import jpos.services.PointCardRWService112;
import jpos.services.PointCardRWService113;
import jpos.services.PointCardRWService114;
import jpos.services.PointCardRWService15;
import jpos.services.PointCardRWService16;
import jpos.services.PointCardRWService17;
import jpos.services.PointCardRWService18;
import jpos.services.PointCardRWService19;

public class PointCardRW
extends BaseJposControl
implements PointCardRWControl114,
JposConst {
    protected PointCardRWService15 service15;
    protected PointCardRWService16 service16;
    protected PointCardRWService17 service17;
    protected PointCardRWService18 service18;
    protected PointCardRWService19 service19;
    protected PointCardRWService110 service110;
    protected PointCardRWService111 service111;
    protected PointCardRWService112 service112;
    protected PointCardRWService113 service113;
    protected PointCardRWService114 service114;
    protected Vector dataListeners;
    protected Vector directIOListeners;
    protected Vector errorListeners;
    protected Vector outputCompleteListeners;
    protected Vector statusUpdateListeners;

    public PointCardRW() {
        this.deviceControlDescription = "JavaPOS PointCardRW Device Control";
        this.deviceControlVersion = 1014000;
        this.dataListeners = new Vector();
        this.directIOListeners = new Vector();
        this.errorListeners = new Vector();
        this.outputCompleteListeners = new Vector();
        this.statusUpdateListeners = new Vector();
    }

    public boolean getCapBold() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service15.getCapBold();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public int getCapCardEntranceSensor() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service15.getCapCardEntranceSensor();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public int getCapCharacterSet() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service15.getCapCharacterSet();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public boolean getCapCleanCard() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service15.getCapCleanCard();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public boolean getCapClearPrint() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service15.getCapClearPrint();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public boolean getCapDhigh() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service15.getCapDhigh();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public boolean getCapDwide() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service15.getCapDwide();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public boolean getCapDwideDhigh() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service15.getCapDwideDhigh();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public boolean getCapItalic() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service15.getCapItalic();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public boolean getCapLeft90() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service15.getCapLeft90();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public int getCapPowerReporting() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service15.getCapPowerReporting();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public boolean getCapPrint() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service15.getCapPrint();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public boolean getCapPrintMode() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service15.getCapPrintMode();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public boolean getCapRight90() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service15.getCapRight90();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public boolean getCapRotate180() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service15.getCapRotate180();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public int getCapTracksToRead() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service15.getCapTracksToRead();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public int getCapTracksToWrite() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service15.getCapTracksToWrite();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public boolean getCapMapCharacterSet() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1007000) {
            throw new JposException(104, "Device Service is not 1.7.0 compliant.");
        }
        try {
            return this.service17.getCapMapCharacterSet();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public boolean getCapStatisticsReporting() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1008000) {
            throw new JposException(104, "Device Service is not 1.8.0 compliant.");
        }
        try {
            return this.service18.getCapStatisticsReporting();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public boolean getCapUpdateStatistics() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1008000) {
            throw new JposException(104, "Device Service is not 1.8.0 compliant.");
        }
        try {
            return this.service18.getCapUpdateStatistics();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public boolean getCapCompareFirmwareVersion() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1009000) {
            throw new JposException(104, "Device Service is not 1.9.0 compliant.");
        }
        try {
            return this.service19.getCapCompareFirmwareVersion();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public boolean getCapUpdateFirmware() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1009000) {
            throw new JposException(104, "Device Service is not 1.9.0 compliant.");
        }
        try {
            return this.service19.getCapUpdateFirmware();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public int getCardState() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service15.getCardState();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public int getCharacterSet() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service15.getCharacterSet();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public void setCharacterSet(int charSet) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service15.setCharacterSet(charSet);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public String getCharacterSetList() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service15.getCharacterSetList();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public int getDataCount() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service15.getDataCount();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public boolean getDataEventEnabled() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service15.getDataEventEnabled();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public void setDataEventEnabled(boolean dataEventEnabled) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service15.setDataEventEnabled(dataEventEnabled);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public String getFontTypeFaceList() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service15.getFontTypeFaceList();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public int getLineChars() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service15.getLineChars();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public void setLineChars(int lineChars) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service15.setLineChars(lineChars);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public String getLineCharsList() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service15.getLineCharsList();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public int getLineHeight() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service15.getLineHeight();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public void setLineHeight(int lineHeight) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service15.setLineHeight(lineHeight);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public int getLineSpacing() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service15.getLineSpacing();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public void setLineSpacing(int lineSpacing) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service15.setLineSpacing(lineSpacing);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public int getLineWidth() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service15.getLineWidth();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public int getMapMode() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service15.getMapMode();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public void setMapMode(int mapMode) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service15.setMapMode(mapMode);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public int getMaxLines() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service15.getMaxLines();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public int getOutputID() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service15.getOutputID();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public int getPowerNotify() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service15.getPowerNotify();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public void setPowerNotify(int powerNotify) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service15.setPowerNotify(powerNotify);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public int getPowerState() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service15.getPowerState();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public int getPrintHeight() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service15.getPrintHeight();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public int getReadState1() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service15.getReadState1();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public int getReadState2() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service15.getReadState2();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public int getRecvLength1() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service15.getRecvLength1();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public int getRecvLength2() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service15.getRecvLength2();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public int getSidewaysMaxChars() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service15.getSidewaysMaxChars();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public int getSidewaysMaxLines() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service15.getSidewaysMaxLines();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public int getTracksToRead() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service15.getTracksToRead();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public void setTracksToRead(int tracksToRead) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service15.setTracksToRead(tracksToRead);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public int getTracksToWrite() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service15.getTracksToWrite();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public void setTracksToWrite(int tracksToWrite) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service15.setTracksToWrite(tracksToWrite);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public String getTrack1Data() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service15.getTrack1Data();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public String getTrack2Data() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service15.getTrack2Data();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public String getTrack3Data() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service15.getTrack3Data();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public String getTrack4Data() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service15.getTrack4Data();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public String getTrack5Data() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service15.getTrack5Data();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public String getTrack6Data() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service15.getTrack6Data();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public int getWriteState1() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service15.getWriteState1();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public int getWriteState2() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service15.getWriteState2();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public String getWrite1Data() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service15.getWrite1Data();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public void setWrite1Data(String data) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service15.setWrite1Data(data);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public String getWrite2Data() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service15.getWrite2Data();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public void setWrite2Data(String data) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service15.setWrite2Data(data);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public String getWrite3Data() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service15.getWrite3Data();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public void setWrite3Data(String data) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service15.setWrite3Data(data);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public String getWrite4Data() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service15.getWrite4Data();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public void setWrite4Data(String data) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service15.setWrite4Data(data);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public String getWrite5Data() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service15.getWrite5Data();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public void setWrite5Data(String data) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service15.setWrite5Data(data);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public String getWrite6Data() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service15.getWrite6Data();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public void setWrite6Data(String data) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service15.setWrite6Data(data);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public boolean getMapCharacterSet() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1007000) {
            throw new JposException(104, "Device Service is not 1.7.0 compliant.");
        }
        try {
            return this.service17.getMapCharacterSet();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public void setMapCharacterSet(boolean mapCharacterSet) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1007000) {
            throw new JposException(104, "Device Service is not 1.7.0 compliant.");
        }
        try {
            this.service17.setMapCharacterSet(mapCharacterSet);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public void beginInsertion(int timeout) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service15.beginInsertion(timeout);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public void beginRemoval(int timeout) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service15.beginRemoval(timeout);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public void cleanCard() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service15.cleanCard();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public void clearInput() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service15.clearInput();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public void clearOutput() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service15.clearOutput();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public void clearPrintWrite(int kind, int hPosition, int vPosition, int width, int height) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service15.clearPrintWrite(kind, hPosition, vPosition, width, height);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public void endInsertion() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service15.endInsertion();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public void endRemoval() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service15.endRemoval();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public void printWrite(int kind, int hPosition, int vPosition, String data) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service15.printWrite(kind, hPosition, vPosition, data);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public void rotatePrint(int rotation) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service15.rotatePrint(rotation);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public void validateData(String data) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service15.validateData(data);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public void resetStatistics(String statisticsBuffer) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1008000) {
            throw new JposException(104, "Device Service is not 1.8.0 compliant.");
        }
        try {
            this.service18.resetStatistics(statisticsBuffer);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public void retrieveStatistics(String[] statisticsBuffer) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1008000) {
            throw new JposException(104, "Device Service is not 1.8.0 compliant.");
        }
        try {
            this.service18.retrieveStatistics(statisticsBuffer);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public void updateStatistics(String statisticsBuffer) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1008000) {
            throw new JposException(104, "Device Service is not 1.8.0 compliant.");
        }
        try {
            this.service18.updateStatistics(statisticsBuffer);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public void compareFirmwareVersion(String firmwareFileName, int[] result) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1009000) {
            throw new JposException(104, "Device Service is not 1.9.0 compliant.");
        }
        try {
            this.service19.compareFirmwareVersion(firmwareFileName, result);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public void updateFirmware(String firmwareFileName) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1009000) {
            throw new JposException(104, "Device Service is not 1.9.0 compliant.");
        }
        try {
            this.service19.updateFirmware(firmwareFileName);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public void clearInputProperties() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1010000) {
            throw new JposException(104, "Device Service is not 1.10.0 compliant.");
        }
        try {
            this.service110.clearInputProperties();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    protected EventCallbacks createEventCallbacks() {
        return new PointCardRWCallbacks();
    }

    protected void setDeviceService(BaseService service, int nServiceVersion) throws JposException {
        if (service == null) {
            this.service15 = null;
            this.service16 = null;
            this.service17 = null;
            this.service18 = null;
            this.service19 = null;
            this.service110 = null;
            this.service111 = null;
            this.service112 = null;
            this.service113 = null;
            this.service114 = null;
        } else {
            if (this.serviceVersion >= 1005000) {
                try {
                    this.service15 = (PointCardRWService15)service;
                }
                catch (Exception e) {
                    throw new JposException(104, "Service does not fully implement PointCardRWService15 interface", e);
                }
            }
            if (this.serviceVersion >= 1006000) {
                try {
                    this.service16 = (PointCardRWService16)service;
                }
                catch (Exception e) {
                    throw new JposException(104, "Service does not fully implement PointCardRWService16 interface", e);
                }
            }
            if (this.serviceVersion >= 1007000) {
                try {
                    this.service17 = (PointCardRWService17)service;
                }
                catch (Exception e) {
                    throw new JposException(104, "Service does not fully implement PointCardRWService17 interface", e);
                }
            }
            if (this.serviceVersion >= 1008000) {
                try {
                    this.service18 = (PointCardRWService18)service;
                }
                catch (Exception e) {
                    throw new JposException(104, "Service does not fully implement PointCardRWService18 interface", e);
                }
            }
            if (this.serviceVersion >= 1009000) {
                try {
                    this.service19 = (PointCardRWService19)service;
                }
                catch (Exception e) {
                    throw new JposException(104, "Service does not fully implement PointCardRWService19 interface", e);
                }
            }
            if (this.serviceVersion >= 1010000) {
                try {
                    this.service110 = (PointCardRWService110)service;
                }
                catch (Exception e) {
                    throw new JposException(104, "Service does not fully implement PointCardRWService110 interface", e);
                }
            }
            if (this.serviceVersion >= 1011000) {
                try {
                    this.service111 = (PointCardRWService111)service;
                }
                catch (Exception e) {
                    throw new JposException(104, "Service does not fully implement PointCardRWService111 interface", e);
                }
            }
            if (this.serviceVersion >= 1012000) {
                try {
                    this.service112 = (PointCardRWService112)service;
                }
                catch (Exception e) {
                    throw new JposException(104, "Service does not fully implement PointCardRWService112 interface", e);
                }
            }
            if (this.serviceVersion >= 1013000) {
                try {
                    this.service113 = (PointCardRWService113)service;
                }
                catch (Exception e) {
                    throw new JposException(104, "Service does not fully implement PointCardRWService113 interface", e);
                }
            }
            if (this.serviceVersion >= 1014000) {
                try {
                    this.service114 = (PointCardRWService114)service;
                }
                catch (Exception e) {
                    throw new JposException(104, "Service does not fully implement PointCardRWService114 interface", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDataListener(DataListener l) {
        Vector vector = this.dataListeners;
        synchronized (vector) {
            this.dataListeners.addElement(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDataListener(DataListener l) {
        Vector vector = this.dataListeners;
        synchronized (vector) {
            this.dataListeners.removeElement(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDirectIOListener(DirectIOListener l) {
        Vector vector = this.directIOListeners;
        synchronized (vector) {
            this.directIOListeners.addElement(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDirectIOListener(DirectIOListener l) {
        Vector vector = this.directIOListeners;
        synchronized (vector) {
            this.directIOListeners.removeElement(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addErrorListener(ErrorListener l) {
        Vector vector = this.errorListeners;
        synchronized (vector) {
            this.errorListeners.addElement(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeErrorListener(ErrorListener l) {
        Vector vector = this.errorListeners;
        synchronized (vector) {
            this.errorListeners.removeElement(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOutputCompleteListener(OutputCompleteListener l) {
        Vector vector = this.outputCompleteListeners;
        synchronized (vector) {
            this.outputCompleteListeners.addElement(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeOutputCompleteListener(OutputCompleteListener l) {
        Vector vector = this.outputCompleteListeners;
        synchronized (vector) {
            this.outputCompleteListeners.removeElement(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStatusUpdateListener(StatusUpdateListener l) {
        Vector vector = this.statusUpdateListeners;
        synchronized (vector) {
            this.statusUpdateListeners.addElement(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeStatusUpdateListener(StatusUpdateListener l) {
        Vector vector = this.statusUpdateListeners;
        synchronized (vector) {
            this.statusUpdateListeners.removeElement(l);
        }
    }

    protected class PointCardRWCallbacks
    implements EventCallbacks {
        protected PointCardRWCallbacks() {
        }

        public BaseControl getEventSource() {
            return PointCardRW.this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fireDataEvent(DataEvent e) {
            Vector vector = PointCardRW.this.dataListeners;
            synchronized (vector) {
                for (int x = 0; x < PointCardRW.this.dataListeners.size(); ++x) {
                    ((DataListener)PointCardRW.this.dataListeners.elementAt(x)).dataOccurred(e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fireDirectIOEvent(DirectIOEvent e) {
            Vector vector = PointCardRW.this.directIOListeners;
            synchronized (vector) {
                for (int x = 0; x < PointCardRW.this.directIOListeners.size(); ++x) {
                    ((DirectIOListener)PointCardRW.this.directIOListeners.elementAt(x)).directIOOccurred(e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fireErrorEvent(ErrorEvent e) {
            Vector vector = PointCardRW.this.errorListeners;
            synchronized (vector) {
                for (int x = 0; x < PointCardRW.this.errorListeners.size(); ++x) {
                    ((ErrorListener)PointCardRW.this.errorListeners.elementAt(x)).errorOccurred(e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fireOutputCompleteEvent(OutputCompleteEvent e) {
            Vector vector = PointCardRW.this.outputCompleteListeners;
            synchronized (vector) {
                for (int x = 0; x < PointCardRW.this.outputCompleteListeners.size(); ++x) {
                    ((OutputCompleteListener)PointCardRW.this.outputCompleteListeners.elementAt(x)).outputCompleteOccurred(e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fireStatusUpdateEvent(StatusUpdateEvent e) {
            Vector vector = PointCardRW.this.statusUpdateListeners;
            synchronized (vector) {
                for (int x = 0; x < PointCardRW.this.statusUpdateListeners.size(); ++x) {
                    ((StatusUpdateListener)PointCardRW.this.statusUpdateListeners.elementAt(x)).statusUpdateOccurred(e);
                }
            }
        }
    }
}

