/*
 * Decompiled with CFR 0.152.
 */
package jpos.loader.simple;

import java.lang.reflect.Constructor;
import java.util.Hashtable;
import jpos.JposException;
import jpos.config.JposEntry;
import jpos.loader.JposServiceConnection;
import jpos.loader.JposServiceInstance;
import jpos.loader.JposServiceInstanceFactory;
import jpos.util.tracing.Tracer;
import jpos.util.tracing.TracerFactory;

public class SimpleServiceConnection
implements JposServiceConnection {
    private static Hashtable siFactoryTable = new Hashtable();
    private JposServiceInstance service = null;
    private JposEntry entry = null;
    private String logicalName = null;
    private String siFactoryClassName = null;
    private Tracer tracer = TracerFactory.getInstance().createTracer("SimpleServiceConnection");

    SimpleServiceConnection(String logicalName, JposEntry entry, String siFactoryClassName) {
        this.logicalName = logicalName;
        this.entry = entry;
        this.siFactoryClassName = siFactoryClassName;
    }

    public JposServiceInstance getService() {
        return this.service;
    }

    public String getLogicalName() {
        return this.logicalName;
    }

    public void connect() throws JposException {
        try {
            Class[] parameterTypes = new Class[]{Class.forName("java.lang.String"), Class.forName("jpos.config.JposEntry")};
            JposServiceInstanceFactory siFactory = null;
            if (siFactoryTable.containsKey(this.siFactoryClassName)) {
                siFactory = (JposServiceInstanceFactory)siFactoryTable.get(this.siFactoryClassName);
            } else {
                Class<?> instanceClass = Class.forName(this.siFactoryClassName);
                Constructor<?> defaultCtor = instanceClass.getConstructor(new Class[0]);
                siFactory = (JposServiceInstanceFactory)defaultCtor.newInstance(new Object[0]);
                siFactoryTable.put(this.siFactoryClassName, siFactory);
            }
            this.service = siFactory.createInstance(this.logicalName, this.entry);
        }
        catch (Exception e) {
            String msg = "Could not connect to service with logicalName = " + this.logicalName + ": Exception.message=" + e.getMessage();
            this.tracer.println(msg);
            throw new JposException(104, msg, e);
        }
    }

    public void disconnect() throws JposException {
        if (this.service != null) {
            this.service.deleteInstance();
            this.service = null;
        }
        this.tracer.println("Disconnected to service OK");
    }

    protected void finalize() throws JposException {
        this.disconnect();
    }
}

