/*
 * Decompiled with CFR 0.152.
 */
package jpos.config.simple;

import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import jpos.config.JposEntry;
import jpos.config.JposEntryRegistry;
import jpos.config.JposEntryRegistryEvent;
import jpos.config.JposEntryRegistryListener;
import jpos.config.JposRegPopulator;
import jpos.util.tracing.Tracer;
import jpos.util.tracing.TracerFactory;

public class SimpleEntryRegistry
implements JposEntryRegistry {
    public Hashtable jposEntries = new Hashtable();
    private Vector listeners = new Vector();
    private JposRegPopulator regPopulator = null;
    private boolean loaded = false;
    private Tracer tracer = TracerFactory.getInstance().createTracer("SimpleEntryRegistry");

    public SimpleEntryRegistry() {
    }

    public SimpleEntryRegistry(JposRegPopulator populator) {
        this.regPopulator = populator;
    }

    public boolean hasJposEntry(String logicalName) {
        return this.jposEntries.containsKey(logicalName);
    }

    public Enumeration getEntries() {
        Vector vector = new Vector();
        Enumeration entries = this.jposEntries.elements();
        while (entries.hasMoreElements()) {
            vector.addElement(entries.nextElement());
        }
        return vector.elements();
    }

    public JposEntry getJposEntry(String logicalName) {
        return (JposEntry)this.jposEntries.get(logicalName);
    }

    public void modifyJposEntry(String logicalName, JposEntry newEntry) {
        this.jposEntries.put(logicalName, newEntry);
        this.tracer.println("Modified entry.logicalName = " + logicalName);
        this.fireJposEntryRegistryEventModified(new JposEntryRegistryEvent(this, newEntry));
    }

    public void addJposEntry(String logicalName, JposEntry entry) {
        this.jposEntries.put(logicalName, entry);
        this.tracer.println("Added entry.logicalName = " + logicalName);
        this.fireJposEntryRegistryEventAdded(new JposEntryRegistryEvent(this, entry));
    }

    public void addJposEntry(JposEntry entry) {
        this.addJposEntry(entry.getLogicalName(), entry);
    }

    public void removeJposEntry(JposEntry entry) {
        Enumeration entries = this.jposEntries.elements();
        while (entries.hasMoreElements()) {
            JposEntry jposEntry = (JposEntry)entries.nextElement();
            if (!jposEntry.hasPropertyWithName("logicalName")) continue;
            JposEntry removedEntry = (JposEntry)this.jposEntries.remove(entry.getPropertyValue("logicalName"));
            this.tracer.println("Removed entry.logicalName = " + entry.getLogicalName());
            this.fireJposEntryRegistryEventRemoved(new JposEntryRegistryEvent(this, removedEntry));
            return;
        }
        this.tracer.println("Could not find entry to remove entry.logicalName = " + entry.getLogicalName());
    }

    public void removeJposEntry(String logicalName) {
        JposEntry entry = (JposEntry)this.jposEntries.get(logicalName);
        if (entry != null) {
            this.jposEntries.remove(logicalName);
            this.fireJposEntryRegistryEventRemoved(new JposEntryRegistryEvent(this, entry));
        }
    }

    public void addJposEntryRegistryListener(JposEntryRegistryListener l) {
        this.listeners.addElement(l);
    }

    public void removeJposEntryRegistryListener(JposEntryRegistryListener l) {
        this.listeners.removeElement(l);
    }

    public void save() throws Exception {
        this.getRegPopulator().save(this.getEntries());
    }

    public void saveToFile(File file) throws Exception {
        this.getRegPopulator().save(this.getEntries(), file.getCanonicalPath());
    }

    public JposRegPopulator getRegPopulator() {
        return this.regPopulator;
    }

    public void load() {
        this.jposEntries.clear();
        this.getRegPopulator().load();
        Enumeration entries = this.getRegPopulator().getEntries();
        while (entries.hasMoreElements()) {
            try {
                JposEntry jposEntry = (JposEntry)entries.nextElement();
                this.jposEntries.put(jposEntry.getPropertyValue("logicalName"), jposEntry);
            }
            catch (Exception e) {
                this.tracer.print(e);
            }
        }
        this.loaded = true;
    }

    public int getSize() {
        return this.jposEntries.size();
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("<SimpleEntryRegistry>\n");
        sb.append("<size=\"" + this.getSize() + "\"\n/>");
        sb.append("<populatorUniqueId=\"" + this.getRegPopulator().getUniqueId() + "\"\n/>");
        sb.append("numberOfListeners=\"" + this.listeners.size() + "\"\n/>");
        sb.append("<entries>\n");
        Enumeration entries = this.getEntries();
        int count = 0;
        while (entries.hasMoreElements()) {
            sb.append("<entry" + count + ".LogicalName=\"" + ((JposEntry)entries.nextElement()).getLogicalName() + "\"\n/>");
            ++count;
        }
        sb.append("</entries>\n");
        sb.append("</SimpleEntryRegistry>\n");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireJposEntryRegistryEventAdded(JposEntryRegistryEvent e) {
        Vector listenersClone;
        this.tracer.println("fireJposEntryRegistryEventAdded: e.getJposEntry().logicalName = " + e.getJposEntry().getLogicalName());
        Vector vector = listenersClone = (Vector)this.listeners.clone();
        synchronized (vector) {
            for (int i = 0; i < listenersClone.size(); ++i) {
                ((JposEntryRegistryListener)listenersClone.elementAt(i)).jposEntryAdded(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireJposEntryRegistryEventRemoved(JposEntryRegistryEvent e) {
        Vector listenersClone;
        this.tracer.println("fireJposEntryRegistryEventRemoved: e.getJposEntry().logicalName = " + e.getJposEntry().getLogicalName());
        Vector vector = listenersClone = (Vector)this.listeners.clone();
        synchronized (vector) {
            for (int i = 0; i < listenersClone.size(); ++i) {
                ((JposEntryRegistryListener)listenersClone.elementAt(i)).jposEntryRemoved(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireJposEntryRegistryEventModified(JposEntryRegistryEvent e) {
        Vector listenersClone;
        this.tracer.println("fireJposEntryRegistryEventModified: e.getJposEntry().logicalName = " + e.getJposEntry().getLogicalName());
        Vector vector = listenersClone = (Vector)this.listeners.clone();
        synchronized (vector) {
            for (int i = 0; i < listenersClone.size(); ++i) {
                ((JposEntryRegistryListener)listenersClone.elementAt(i)).jposEntryModified(e);
            }
        }
    }
}

