/*
 * Decompiled with CFR 0.152.
 */
package jpos.config;

import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import jpos.config.CompositeRegPopulator;
import jpos.config.JposEntry;
import jpos.config.JposRegPopulator;
import jpos.loader.JposServiceLoader;
import jpos.util.JposProperties;
import jpos.util.tracing.Tracer;
import jpos.util.tracing.TracerFactory;

public class DefaultCompositeRegPopulator
implements CompositeRegPopulator {
    private HashMap popMap = new HashMap();
    private HashMap popFileMap = new HashMap();
    private JposRegPopulator defaultPop = null;
    private Exception lastLoadException = null;
    private Tracer tracer = TracerFactory.getInstance().createTracer("DefaultCompositeRegPopulator");

    public DefaultCompositeRegPopulator() {
    }

    public DefaultCompositeRegPopulator(JposRegPopulator populator) {
        this.add(populator);
        this.setDefaultPopulator(populator);
    }

    private JposRegPopulator createPopulator(String popName, String className) {
        JposRegPopulator populator = null;
        try {
            Class<?> popClass = Class.forName(className);
            try {
                Class[] ctorParamTypes = new Class[]{String.class};
                Constructor<?> ctor = popClass.getConstructor(ctorParamTypes);
                Object[] args = new Object[]{popName};
                populator = (JposRegPopulator)ctor.newInstance(args);
            }
            catch (NoSuchMethodException nsme) {
                Constructor<?> ctor = popClass.getConstructor(new Class[0]);
                populator = (JposRegPopulator)ctor.newInstance(new Object[0]);
            }
        }
        catch (ClassNotFoundException cnfe) {
            this.tracer.println("Could not find populator class with name: " + className + " exception message = " + cnfe.getMessage());
        }
        catch (NoSuchMethodException nsme) {
            this.tracer.println("Populator by class name: " + className + " must define a no-arg ctor or a 1-arg ctor with String param as the unique ID");
        }
        catch (InstantiationException ie) {
            this.tracer.println("Could not instantiate populator class with name: " + className + " exception message = " + ie.getMessage());
        }
        catch (Exception e) {
            this.tracer.println("Could not instantiate populator class with name: " + className + " exception message = " + e.getMessage());
        }
        return populator;
    }

    protected void setDefaultPopulator(JposRegPopulator populator) throws IllegalArgumentException {
        if (populator == null) {
            throw new IllegalArgumentException("Null value cannot be used for default JposRegPopualtor");
        }
        if (populator.getUniqueId() == null || "".equals(populator.getUniqueId())) {
            throw new IllegalArgumentException("Default JposRegPopualtor cannot have a unique ID of null or empty string");
        }
        this.add(populator);
        this.defaultPop = populator;
    }

    public String getUniqueId() {
        return this.getClassName();
    }

    public String getClassName() {
        return DefaultCompositeRegPopulator.class.getName();
    }

    public void save(Enumeration entries) throws Exception {
        HashMap popEntriesMap = new HashMap();
        Iterator popIterator = this.popMap.values().iterator();
        while (popIterator.hasNext()) {
            popEntriesMap.put(((JposRegPopulator)popIterator.next()).getUniqueId(), new ArrayList());
        }
        while (entries.hasMoreElements()) {
            JposEntry entry = (JposEntry)entries.nextElement();
            JposRegPopulator populator = entry.getRegPopulator();
            if (populator == null) {
                Collection defaultEntryList = (Collection)popEntriesMap.get(this.getDefaultPopulator().getUniqueId());
                defaultEntryList.add(entry);
                continue;
            }
            Collection entryList = (Collection)popEntriesMap.get(populator.getUniqueId());
            if (entryList == null) {
                this.tracer.println("Trying to save entry with logicalName = " + entry.getLogicalName() + " and populator with");
                continue;
            }
            entryList.add(entry);
        }
        Exception exception = null;
        for (JposRegPopulator populator : this.popMap.values()) {
            String popUniqueId = populator.getUniqueId();
            Collection entryList = (Collection)popEntriesMap.get(popUniqueId);
            try {
                if (this.popFileMap.get(populator.getUniqueId()) != null) {
                    populator.save(new Vector(entryList).elements(), (String)this.popFileMap.get(populator.getUniqueId()));
                    continue;
                }
                populator.save(new Vector(entryList).elements());
            }
            catch (Exception e) {
                exception = e;
                this.tracer.println("Error while saving to populator with unique ID:" + populator.getUniqueId());
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    public void save(Enumeration entries, String fileName) throws Exception {
        this.getDefaultPopulator().save(entries, fileName);
    }

    public void load() {
        JposProperties jposProperties = JposServiceLoader.getManager().getProperties();
        JposProperties.MultiProperty populatorClassMultiProp = jposProperties.getMultiProperty("jpos.config.populator.class");
        JposProperties.MultiProperty populatorFileMultiProp = jposProperties.getMultiProperty("jpos.config.populator.file");
        if (populatorClassMultiProp.getNumberOfProperties() == 0) {
            this.tracer.println("CompositeRegPopulator.load() w/o any defined multi-property");
            throw new RuntimeException("CompositeRegPopulator.load() w/o any defined multi-property");
        }
        Iterator popClasses = populatorClassMultiProp.getSortedPropertyNames();
        String defaultPopName = (String)popClasses.next();
        String defaultPopClass = populatorClassMultiProp.getPropertyString(defaultPopName);
        int defaultPopClassNumber = populatorClassMultiProp.propertyNumber(defaultPopName);
        JposRegPopulator defaultPopulator = this.createPopulator(defaultPopName, defaultPopClass);
        if (populatorFileMultiProp != null && populatorFileMultiProp.getNumberOfProperties() > 0) {
            String defaultPopFile = populatorFileMultiProp.getPropertyString(defaultPopClassNumber);
            if (defaultPopFile != null) {
                defaultPopulator.load(defaultPopFile);
                this.lastLoadException = defaultPopulator.getLastLoadException();
                this.popFileMap.put(defaultPopulator.getUniqueId(), defaultPopFile);
            } else {
                this.tracer.println("Created default populator with name = " + defaultPopName + " OK but populator file is null");
                defaultPopulator.load();
                this.lastLoadException = defaultPopulator.getLastLoadException();
            }
        } else {
            defaultPopulator.load();
            this.lastLoadException = defaultPopulator.getLastLoadException();
        }
        if (defaultPopulator != null) {
            this.setDefaultPopulator(defaultPopulator);
        } else {
            this.tracer.println("Did not add default populator by <name, className>: <" + defaultPopName + ", " + defaultPopClass + ">");
        }
        while (popClasses.hasNext()) {
            String popName = (String)popClasses.next();
            String popClass = populatorClassMultiProp.getPropertyString(popName);
            int popClassNumber = populatorClassMultiProp.propertyNumber(popName);
            JposRegPopulator populator = this.createPopulator(popName, popClass);
            if (populator != null) {
                if (populatorFileMultiProp != null && populatorFileMultiProp.getNumberOfProperties() > 0) {
                    String popFile = populatorFileMultiProp.getPropertyString(popClassNumber);
                    populator.load(popFile);
                    this.popFileMap.put(populator.getUniqueId(), popFile);
                } else {
                    this.tracer.println("Created populator with name = " + popName + " OK but populator file is null");
                    populator.load();
                    this.lastLoadException = populator.getLastLoadException();
                }
                this.add(populator);
                continue;
            }
            this.tracer.println("Did not add populator by <name, className>: <" + popName + ", " + popClass + ">");
        }
    }

    public void load(String fileName) {
        this.getDefaultPopulator().load(fileName);
    }

    public URL getEntriesURL() {
        return this.getDefaultPopulator().getEntriesURL();
    }

    public Enumeration getEntries() {
        Vector entryVector = new Vector();
        Iterator populators = this.getPopulators();
        while (populators.hasNext()) {
            JposRegPopulator pop = (JposRegPopulator)populators.next();
            Enumeration entries = pop.getEntries();
            while (entries.hasMoreElements()) {
                entryVector.add(entries.nextElement());
            }
        }
        return entryVector.elements();
    }

    public boolean isComposite() {
        return true;
    }

    public String getName() {
        return "JCL Composite Entries Populator";
    }

    public Exception getLastLoadException() {
        return this.lastLoadException;
    }

    public String toString() {
        return this.getName();
    }

    public JposRegPopulator getDefaultPopulator() {
        return this.defaultPop;
    }

    public void add(JposRegPopulator populator) {
        this.popMap.put(populator.getUniqueId(), populator);
    }

    public void remove(JposRegPopulator populator) {
        this.popMap.remove(populator.getUniqueId());
    }

    public Iterator getPopulators() {
        return this.popMap.values().iterator();
    }

    public JposRegPopulator getPopulator(String uniqueId) {
        return (JposRegPopulator)this.popMap.get(uniqueId);
    }

    public int size() {
        return this.popMap.size();
    }
}

