/*
 * Decompiled with CFR 0.152.
 */
package pl.novitus.javapos.service;

import jpos.JposException;
import jpos.loader.JposServiceInstance;
import jpos.services.BaseService;
import jpos.services.EventCallbacks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pl.novitus.javapos.service.Connectable;
import pl.novitus.javapos.utils.Connection;
import pl.novitus.javapos.utils.ConnectionException;
import pl.novitus.javapos.utils.i18n.I18n;

public abstract class AbstractDeviceService
implements BaseService,
JposServiceInstance,
Connectable {
    private static final Logger log = LogManager.getLogger(AbstractDeviceService.class);
    static final String DS_DESCRIPTION = "POS Printer UnifiedPOS compatible control, (C) 2019 Novitus";
    public static final int DS_VERSION = 1014000;
    protected EventCallbacks callbacks;
    protected int state = 1;
    private boolean open;
    private boolean claimed;
    private boolean enabled;
    private Connection connection;
    protected boolean asyncMode = false;
    protected boolean dayOpened = false;

    public abstract void reset();

    protected void notSupportedError() throws JposException {
        throw new JposException(106, I18n.tr("strMethodOrArgNotSupported"));
    }

    protected void checkIfOpen() throws JposException {
        log.debug("open=" + this.open);
        if (!this.open) {
            throw new JposException(101, I18n.tr("strDeviceNotOpen"));
        }
    }

    protected void checkIfClaimed() throws JposException {
        log.debug("claimed=" + this.claimed);
        if (!this.claimed) {
            throw new JposException(103, I18n.tr("strDeviceNotClaimed"));
        }
    }

    protected void checkIfEnabled() throws JposException {
        log.debug("enabled=" + this.enabled);
        if (!this.enabled) {
            throw new JposException(105, I18n.tr("strDeviceNotEnabled"));
        }
    }

    public void deleteInstance() throws JposException {
        log.debug("releasing instance");
    }

    public void release() throws JposException {
        this.checkIfClaimed();
        this.claimed = false;
    }

    public void open(String s, EventCallbacks eventcallbacks) throws JposException {
        if (this.open) {
            throw new JposException(106, I18n.tr("strDeviceIsOpen"));
        }
        this.open = true;
        this.state = 2;
        this.callbacks = eventcallbacks;
    }

    public void close() throws JposException {
        log.debug("called");
        if (this.open) {
            this.open = false;
            this.state = 1;
            this.callbacks = null;
            this.enabled = false;
            this.claimed = false;
            try {
                this.connection.close();
            }
            catch (ConnectionException ex) {
                String msg = "Exception thrown from connection.close(): " + ex;
                log.warn(msg);
            }
        }
        this.reset();
        log.debug("completed");
    }

    public void claim(int arg0) throws JposException {
        log.debug("called");
        this.checkIfOpen();
        if (!this.claimed) {
            try {
                this.connection.open();
            }
            catch (ConnectionException ex) {
                String msg = String.format(I18n.tr("strUnableToOpenConnection"), ex.getMessage());
                log.error(msg);
                throw new JposException(111, msg);
            }
            this.claimed = true;
        }
        log.debug("completed");
    }

    public int getState() {
        return this.state;
    }

    public boolean isOpen() {
        return this.open;
    }

    public boolean getClaimed() {
        return this.claimed;
    }

    public boolean getDeviceEnabled() {
        return this.enabled;
    }

    public void setDeviceEnabled(boolean enabled) throws JposException {
        this.checkIfOpen();
        this.checkIfClaimed();
        this.enabled = enabled;
    }

    public String getDeviceServiceDescription() throws JposException {
        this.checkIfOpen();
        return DS_DESCRIPTION;
    }

    public int getDeviceServiceVersion() throws JposException {
        log.debug("returning 1014000");
        return 1014000;
    }

    @Override
    public void setConnection(Connection conn) {
        this.connection = conn;
    }

    @Override
    public Connection getConnection() {
        return this.connection;
    }
}

