/*
 * Decompiled with CFR 0.152.
 */
package pl.novitus.javapos.utils.connection;

import com.fazecast.jSerialComm.SerialPort;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pl.novitus.javapos.utils.ConnectionException;
import pl.novitus.javapos.utils.FiscalDeviceException;
import pl.novitus.javapos.utils.connection.AbstractConnection;
import pl.novitus.javapos.utils.i18n.I18n;

public class SerialPortConnection
extends AbstractConnection {
    private static final Logger log = LogManager.getLogger(SerialPortConnection.class);
    public static final int PARITY_EVEN = 2;
    public static final int PARITY_ODD = 1;
    public static final int PARITY_NONE = 0;
    public static final int FLOWCTL_NONE = 0;
    public static final int FLOWCTL_XONOFF = 0x110000;
    public static final int FLOWCTL_DTRSDR = 4352;
    public static final int FLOWCTL_CTSRTS = 17;
    public static final int STOPBITS_1 = 1;
    public static final int STOPBITS_15 = 2;
    public static final int STOPBITS_2 = 3;
    private int baudRate = 9600;
    private int bits = 8;
    private int stopBits = 1;
    private int parity = 0;
    private int flowControl = 0x110000;
    private String portName;
    SerialPort port;

    @Override
    protected void assertPortOpen() throws ConnectionException {
        if (this.port == null || !this.port.isOpen()) {
            throw new ConnectionException(String.format(I18n.tr("strSerialPortNotOpen"), this.getPortName()));
        }
    }

    private void readError(boolean timeout) throws ConnectionException {
        if (timeout) {
            throw new ConnectionException(String.format(I18n.tr("strPortReadTimeout"), this.getPortName()));
        }
        throw new ConnectionException(String.format(I18n.tr("strPortReadError"), this.getPortName()));
    }

    @Override
    public int read() throws ConnectionException {
        this.assertPortOpen();
        byte[] buf = new byte[]{0};
        if (this.port.readBytes(buf, 1L) != 1) {
            this.readError(true);
        }
        log.debug(String.format("read: %d %s", buf[0], new String(buf)));
        return buf[0];
    }

    @Override
    public byte[] read(int count) throws ConnectionException {
        this.assertPortOpen();
        byte[] buf = new byte[count];
        int l = this.port.readBytes(buf, (long)count);
        if (l < count) {
            this.readError(l > 0);
        }
        return buf;
    }

    @Override
    public void write(int data) throws ConnectionException {
        this.assertPortOpen();
        byte[] buf = new byte[]{new Integer(data).byteValue()};
        if (1 != this.port.writeBytes(buf, 1L)) {
            throw new ConnectionException(String.format(I18n.tr("strSerialPortWriteError"), this.getPortName()));
        }
    }

    @Override
    public void write(byte[] data) throws ConnectionException {
        this.assertPortOpen();
        if (data.length != this.port.writeBytes(data, (long)data.length)) {
            throw new ConnectionException(String.format(I18n.tr("strSerialPortWriteError"), this.getPortName()));
        }
    }

    @Override
    public void open() throws ConnectionException {
        if (this.portName.isEmpty()) {
            throw new ConnectionException(I18n.tr("strSerialNoPortName"));
        }
        this.port = SerialPort.getCommPort((String)this.getPortName());
        this.port.setComPortParameters(this.baudRate, this.bits, this.stopBits, this.parity);
        this.port.setComPortTimeouts(16, this.getTimeout(), 0);
        this.port.openPort();
        if (!this.port.isOpen()) {
            throw new ConnectionException(String.format(I18n.tr("strSerialPortOpenError"), this.getPortName()));
        }
    }

    @Override
    public void close() throws ConnectionException {
        if (this.port != null) {
            this.port.closePort();
            this.port = null;
        }
    }

    public int getBaudRate() {
        return this.baudRate;
    }

    public void setBaudRate(int baudRate) {
        this.baudRate = baudRate;
    }

    public int getBits() {
        return this.bits;
    }

    public void setBits(int bits) {
        this.bits = bits;
    }

    public int getStopBits() {
        return this.stopBits;
    }

    public void setStopBits(int stopBits) {
        this.stopBits = stopBits;
    }

    public int getParity() {
        return this.parity;
    }

    public void setParity(int parity) {
        this.parity = parity;
    }

    public int getFlowControl() {
        return this.flowControl;
    }

    public void setFlowControl(int flowControl) {
        this.flowControl = flowControl;
    }

    public String getPortName() {
        return this.portName;
    }

    public void setPortName(String portName) {
        this.portName = portName;
    }

    public SerialPort getPort() {
        return this.port;
    }

    public void setPort(SerialPort port) {
        this.port = port;
    }

    public static void main(String[] args) throws FiscalDeviceException {
        if (args.length > 0) {
            if (args[0].equalsIgnoreCase("list")) {
                System.out.println("SerialPortConnection: showPorts");
                int l = SerialPort.getCommPorts().length;
                if (l > 0) {
                    System.out.println("Serial ports available:\n");
                    System.out.println(String.format("%-15s  %-30s %-30s", "portName", "description", "information"));
                    System.out.println(StringUtils.repeat((String)"-", (int)78));
                    for (int i = 0; i < l; ++i) {
                        SerialPort port = SerialPort.getCommPorts()[i];
                        System.out.println(String.format("%-15.15s  %-30.30s %-30.30s", port.getSystemPortName(), port.getPortDescription(), port.getDescriptivePortName()));
                    }
                    System.out.println("\nFound " + l + " port(s).");
                } else {
                    System.out.println("No serial ports found.");
                }
            }
            if (args[0].equalsIgnoreCase("test")) {
                SerialPort p = SerialPort.getCommPorts()[0];
                p.setBaudRate(9600);
                p.setNumDataBits(8);
                p.setNumStopBits(1);
                p.openPort();
                p.writeBytes(new byte[]{7}, 1L);
            }
        }
    }
}

