/*
 * Decompiled with CFR 0.152.
 */
package jpos.util.tracing;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import jpos.util.DefaultProperties;
import jpos.util.JposProperties;
import jpos.util.tracing.Tracer;

public class TracerFactory {
    private HashMap tracerMap = new HashMap();
    private HashMap namedTracerState = new HashMap();
    private Tracer globalTracer = Tracer.getInstance();
    private PrintStream printStream = null;
    private boolean turnOnAllNamedTracers = false;
    private static TracerFactory instance = null;
    public static final String TRACING_PROP_NAME = "jpos.tracing";
    public static final String TRACER_PROP_NAME = "jpos.util.tracing.Tracer";
    public static final String TURN_ON_NAMED_TRACERS_PROP_NAME = "jpos.util.tracing.TurnOnNamedTracers";
    public static final String TURN_ON_ALL_NAMED_TRACERS_PROP_NAME = "jpos.util.tracing.TurnOnAllNamedTracers";
    public static final String TRACER_OUTPUT_TO_FILE_PROP_NAME = "jpos.util.tracing.TracerOutputToFile";
    public static final String TRACER_OUTPUT_FILE_NAME_PROP_NAME = "jpos.util.tracing.TracerOutputFileName";
    public static final String TRACER_OUTPUT_FILE_LOCATION = "jpos.util.tracing.TracerOutputFileLocation";
    public static final String USER_HOME_LOCATION_VALUE = "<user.home>";

    protected TracerFactory() {
    }

    public static TracerFactory getInstance() {
        if (instance == null) {
            instance = new TracerFactory();
            instance.init();
        }
        return instance;
    }

    public void setOutputFile(File file) throws IOException {
    }

    public Tracer createGlobalTracer() {
        return this.globalTracer;
    }

    public Tracer createGlobalTracer(boolean b) {
        this.globalTracer.setOn(b);
        return this.globalTracer;
    }

    public Tracer createTracer(String name) {
        if (this.tracerMap.containsKey(name)) {
            return (Tracer)this.tracerMap.get(name);
        }
        Tracer tracer = new Tracer(name);
        if (this.namedTracerState.containsKey(name)) {
            tracer.setOn((Boolean)this.namedTracerState.get(name));
        } else {
            tracer.setOn(false);
        }
        if (this.turnOnAllNamedTracers) {
            tracer.setOn(true);
        }
        this.tracerMap.put(name, tracer);
        return tracer;
    }

    public Tracer createTracer(String name, boolean b) {
        Tracer tracer = this.createTracer(name);
        tracer.setOn(b);
        return tracer;
    }

    protected void finalize() {
        if (this.printStream != null) {
            this.printStream.close();
        }
    }

    private boolean isPropertyTrue(String propValue) {
        if (propValue == null) {
            return false;
        }
        return propValue.equalsIgnoreCase("ON") || propValue.equalsIgnoreCase("TRUE");
    }

    private void init() {
        DefaultProperties props = new DefaultProperties();
        props.loadJposProperties();
        this.initGlobalTracer(props);
        this.initTurnedOnTracers(props);
        this.initNamedTracers(props);
        this.initTracerOutput();
    }

    private void initGlobalTracer(JposProperties props) {
        if (!props.isPropertyDefined(TRACING_PROP_NAME)) {
            this.globalTracer.setOn(false);
        } else {
            String tracingPropValue = props.getPropertyString(TRACING_PROP_NAME);
            if (this.isPropertyTrue(tracingPropValue)) {
                this.globalTracer.setOn(true);
            }
        }
    }

    private void initTurnedOnTracers(JposProperties props) {
        if (props.isPropertyDefined(TURN_ON_ALL_NAMED_TRACERS_PROP_NAME)) {
            String turnOnAllNamedTracersValue = props.getPropertyString(TURN_ON_ALL_NAMED_TRACERS_PROP_NAME);
            this.turnOnAllNamedTracers = this.isPropertyTrue(turnOnAllNamedTracersValue);
        } else if (props.isPropertyDefined(TURN_ON_NAMED_TRACERS_PROP_NAME)) {
            List turnOnNamedTracersList = props.getStringListProperty(TURN_ON_NAMED_TRACERS_PROP_NAME);
            for (int i = 0; i < turnOnNamedTracersList.size(); ++i) {
                String tracerName = turnOnNamedTracersList.get(i).toString();
                this.namedTracerState.put(tracerName, Boolean.TRUE);
            }
        }
    }

    private void initNamedTracers(JposProperties props) {
        Enumeration propNames = props.getPropertyNames();
        while (propNames.hasMoreElements()) {
            String propName = (String)propNames.nextElement();
            if (!propName.startsWith(TRACER_PROP_NAME)) continue;
            String name = propName.substring("jpos.util.tracing.Tracer.".length(), propName.length());
            if (!props.isPropertyDefined(propName)) continue;
            String propValue = props.getPropertyString(propName);
            if (propValue.equalsIgnoreCase("ON") || propValue.equalsIgnoreCase("TRUE")) {
                this.namedTracerState.put(name, Boolean.TRUE);
                continue;
            }
            this.namedTracerState.put(name, Boolean.FALSE);
        }
    }

    private void initTracerOutput() {
    }
}

