/*
 * Decompiled with CFR 0.152.
 */
package pl.novitus.javapos.utils.transport;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pl.novitus.javapos.utils.ConnectionException;
import pl.novitus.javapos.utils.FiscalDeviceException;
import pl.novitus.javapos.utils.FiscalDeviceHardwareFailureException;
import pl.novitus.javapos.utils.FiscalDeviceOfflineException;
import pl.novitus.javapos.utils.FiscalDeviceOutOfPaperException;
import pl.novitus.javapos.utils.converters.MazoviaCharsetConverter;
import pl.novitus.javapos.utils.printer.LegacyPacketChecksum;
import pl.novitus.javapos.utils.transport.AbstractProtocol;

public class LegacyFiscalPrinterProtocol
extends AbstractProtocol {
    private static final Logger log = LogManager.getLogger(LegacyFiscalPrinterProtocol.class);
    private static final byte[] START_SEQUENCE = new byte[]{27, 80};
    private static final byte[] STOP_SEQUENCE = new byte[]{27, 92};

    @Override
    public void sendPacket(String request) throws FiscalDeviceException {
        byte[] cRequest = new MazoviaCharsetConverter().fromUTF8(request);
        LegacyPacketChecksum chksum = new LegacyPacketChecksum(cRequest);
        try {
            log.debug("seding packet: " + new String(cRequest));
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            output.write("\u001bP".getBytes());
            output.write(cRequest);
            output.write(chksum.toString().getBytes());
            output.write("\u001b\\".getBytes());
            this.getConnection().write(output.toByteArray());
        }
        catch (IOException ex1) {
            log.error((Object)ex1);
            throw new FiscalDeviceException(-2, "Unable to send packet to device");
        }
        catch (ConnectionException ex) {
            log.error((Object)ex);
            throw new FiscalDeviceException(-2, "Unable to send packet to device");
        }
    }

    @Override
    public String receivePacket() throws FiscalDeviceException {
        return this.receivePacket(false);
    }

    @Override
    public String receivePacket(boolean ignoreChecksum) throws FiscalDeviceException {
        try {
            byte[] bPacket = this.getConnection().read(START_SEQUENCE, STOP_SEQUENCE);
            String packet = new String(bPacket);
            log.debug("received packet: " + packet);
            packet = packet.replace("\u001bP", "");
            packet = packet.replace("\u001b\\", "");
            if (!ignoreChecksum) {
                if (packet.length() > 2) {
                    String cksum = packet.substring(packet.length() - 2);
                    LegacyPacketChecksum checksum = new LegacyPacketChecksum((packet = packet.substring(0, packet.length() - 2)).getBytes());
                    if (!checksum.toString().equals(cksum)) {
                        log.error("invalid packet checksum");
                        throw new FiscalDeviceException("Invalid checksum");
                    }
                } else {
                    throw new FiscalDeviceException(-2, "Packet received from device is too short");
                }
            }
            return packet;
        }
        catch (ConnectionException ex) {
            log.error((Object)ex);
            throw new FiscalDeviceException(-2, "Unable to read packet from device");
        }
    }

    @Override
    public void checkError() throws FiscalDeviceException {
        Status s = this.getStatus();
        if (!s.isOnline()) {
            throw new FiscalDeviceOfflineException();
        }
        if (!s.isSuccess()) {
            String request = "#n";
            this.sendPacket(request);
            String response = this.receivePacket(true);
            response = response.replace("1#E", "");
            int err = Integer.parseInt(response);
            if (err != 0) {
                log.debug(String.format("Device reported error: %d", err));
                throw new FiscalDeviceException(err);
            }
        }
        if (s.isNoPaper()) {
            throw new FiscalDeviceOutOfPaperException();
        }
        if (s.isHwError()) {
            throw new FiscalDeviceHardwareFailureException();
        }
    }

    public Status getStatus() throws FiscalDeviceException {
        try {
            this.getConnection().write(5);
            int s1 = this.getConnection().read();
            this.getConnection().write(16);
            int s2 = this.getConnection().read();
            Status result = new Status();
            result.setLastTransaction((s1 & 1) > 0);
            result.setTransaction((s1 & 2) > 0);
            result.setSuccess((s1 & 4) > 0);
            result.setFiscal((s1 & 8) > 0);
            result.setHwError((s2 & 1) > 0);
            result.setNoPaper((s2 & 2) > 0);
            result.setOnline((s2 & 4) > 0);
            return result;
        }
        catch (ConnectionException ex) {
            log.error("Status read error: " + ex.getMessage());
            throw new FiscalDeviceException(-2);
        }
    }

    public void initialize() throws FiscalDeviceException {
        String request = "1#e";
        this.sendPacket(request);
        this.checkError();
    }

    public class Status {
        private boolean fiscal;
        private boolean success;
        private boolean transaction;
        private boolean lastTransaction;
        private boolean online;
        private boolean noPaper;
        private boolean hwError;

        public boolean isFiscal() {
            return this.fiscal;
        }

        public void setFiscal(boolean fiscal) {
            this.fiscal = fiscal;
        }

        public boolean isSuccess() {
            return this.success;
        }

        public void setSuccess(boolean success) {
            this.success = success;
        }

        public boolean isTransaction() {
            return this.transaction;
        }

        public void setTransaction(boolean transaction) {
            this.transaction = transaction;
        }

        public boolean isLastTransaction() {
            return this.lastTransaction;
        }

        public void setLastTransaction(boolean lastTransaction) {
            this.lastTransaction = lastTransaction;
        }

        public boolean isOnline() {
            return this.online;
        }

        public void setOnline(boolean online) {
            this.online = online;
        }

        public boolean isNoPaper() {
            return this.noPaper;
        }

        public void setNoPaper(boolean noPaper) {
            this.noPaper = noPaper;
        }

        public boolean isHwError() {
            return this.hwError;
        }

        public void setHwError(boolean hwError) {
            this.hwError = hwError;
        }
    }
}

