/*
 * Decompiled with CFR 0.152.
 */
package pl.novitus.javapos.factory;

import java.lang.reflect.Constructor;
import java.util.Iterator;
import jpos.JposException;
import jpos.config.JposEntry;
import jpos.loader.JposServiceInstance;
import jpos.loader.JposServiceInstanceFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pl.novitus.javapos.factory.DefaultConnectionFactory;
import pl.novitus.javapos.service.Connectable;

public class DefaultServiceFactory
implements JposServiceInstanceFactory {
    private static final Logger log = LogManager.getLogger(DefaultServiceFactory.class);

    public JposServiceInstance createInstance(String s, JposEntry jposentry) throws JposException {
        log.debug("createInstance: " + s);
        if (!jposentry.hasPropertyWithName("serviceClass")) {
            throw new JposException(104, "The JposEntry does not contain the 'serviceClass' property");
        }
        if (log.isDebugEnabled()) {
            Iterator props = jposentry.getProps();
            while (props.hasNext()) {
                JposEntry.Prop p = (JposEntry.Prop)props.next();
                log.debug("  property: " + p.getName() + "=" + p.getValueAsString());
            }
        }
        try {
            String s1 = (String)jposentry.getPropertyValue("serviceClass");
            log.debug("creating class: " + s1);
            Class<?> class1 = Class.forName(s1);
            Constructor<?> constructor = class1.getConstructor(new Class[0]);
            JposServiceInstance instance = (JposServiceInstance)constructor.newInstance(new Object[0]);
            if (instance instanceof Connectable) {
                log.debug("Service is connectable");
                ((Connectable)instance).setConnection(new DefaultConnectionFactory().createInstance(jposentry));
            }
            return instance;
        }
        catch (Exception exception) {
            throw new JposException(104, "Could not create service instance", exception);
        }
    }
}

