/*
 * Decompiled with CFR 0.152.
 */
package jpos.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.util.Vector;
import jpos.util.tracing.Tracer;
import jpos.util.tracing.TracerFactory;

public class XmlHelper {
    private String dtdFileName = "jcl.dtd";
    private String dtdFilePath = DEFAULT_DTD_FILE_PATH;
    private String dtdJarFullFileName = this.dtdFilePath + File.separator + this.dtdFileName;
    private boolean createdTempDTD = false;
    private boolean createdTempDir = false;
    private Tracer tracer = TracerFactory.getInstance().createTracer("XmlHelper");
    public static final String DEFAULT_DTD_FILE_NAME = "jcl.dtd";
    public static final String DEFAULT_DTD_FILE_PATH = "jpos" + File.separator + "res" + File.separator;

    public String getDtdFileName() {
        return this.dtdFileName;
    }

    public String getDtdFilePath() {
        return this.dtdFilePath;
    }

    public void setDtdFileName(String fileName) {
        this.dtdFileName = fileName;
    }

    public void setDtdFilePath(String filePath) {
        this.dtdFilePath = filePath.endsWith(File.separator) ? filePath : filePath + File.separator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkAndCreateTempDtd() {
        this.createdTempDTD = false;
        this.createdTempDir = false;
        InputStream is = null;
        this.dtdJarFullFileName = this.dtdFilePath + this.dtdFileName;
        try {
            File dtdPath = new File(this.dtdFilePath);
            File dtdFile = new File(this.dtdJarFullFileName);
            if (dtdFile.exists()) {
                return;
            }
            if (!dtdPath.exists()) {
                dtdPath.mkdirs();
                this.createdTempDir = true;
                this.tracer.println("DTD file PATH does not exist.  Created path " + this.dtdFilePath);
            }
            is = ClassLoader.getSystemClassLoader().getResourceAsStream(this.dtdJarFullFileName);
            this.tracer.println("Got DTD InputStream from current ClassLoader");
            if (is != null) {
                this.readAndCreateTempDtdFile(is);
            }
        }
        catch (IOException ioe) {
            this.tracer.println("Error creating DTD file: Exception.message = " + ioe.getMessage());
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException ioe) {
                this.tracer.println("Error while closing streams: Exception.message = " + ioe.getMessage());
            }
        }
    }

    public void removeTempDtd() {
        try {
            if (this.createdTempDTD) {
                File dtdFile = new File(this.dtdJarFullFileName);
                dtdFile.delete();
                if (this.createdTempDir) {
                    this.removeDirs(this.dtdFilePath);
                }
                this.tracer.println("Removed temp directory with DTD OK");
            }
        }
        catch (Exception e) {
            this.tracer.println("Error removing temporary DTD file: Exception.msg = " + e.getMessage());
        }
    }

    private void readAndCreateTempDtdFile(InputStream is) throws IOException {
        File dtdFile = new File(this.dtdJarFullFileName);
        FileOutputStream fos = new FileOutputStream(dtdFile);
        OutputStreamWriter osw = new OutputStreamWriter(fos);
        StringBuffer sb = new StringBuffer();
        while (is.available() > 0) {
            byte[] buffer = new byte[is.available()];
            is.read(buffer);
            sb.append(new String(buffer));
        }
        osw.write(sb.toString().trim());
        this.createdTempDTD = true;
        try {
            if (osw != null) {
                osw.close();
            }
            if (fos != null) {
                fos.close();
            }
        }
        catch (IOException ioe) {
            this.tracer.println("Error while closing streams: IOExeption.msg=" + ioe.getMessage());
        }
        this.tracer.println("Read and created temp " + this.dtdFilePath + this.dtdFileName);
    }

    private Vector getSubdirNames(String originalDirName) {
        String dirName = originalDirName.replace("\\".charAt(0), "/".charAt(0));
        if (!dirName.endsWith("/")) {
            dirName = dirName + "/";
        }
        Vector<String> dirs = new Vector<String>();
        String s = dirName;
        while (s.indexOf("/") != -1) {
            dirs.add(s.substring(0, s.indexOf("/")));
            s = s.substring(s.indexOf("/") + 1);
        }
        return dirs;
    }

    void removeDirs(String dirName) throws IOException {
        Vector subdirNames = this.getSubdirNames(dirName);
        while (subdirNames.size() > 0) {
            Vector v = (Vector)subdirNames.clone();
            String subdirName = "";
            for (int i = 0; i < subdirNames.size(); ++i) {
                subdirName = subdirName + (String)subdirNames.elementAt(i) + File.separator;
            }
            File subdirFile = new File(subdirName);
            if (subdirFile.list() != null && subdirFile.list().length == 0) {
                subdirFile.delete();
            }
            if (subdirNames.size() <= 0) continue;
            subdirNames.removeElementAt(subdirNames.size() - 1);
        }
    }
}

