/*
 * Decompiled with CFR 0.152.
 */
package jpos.config.simple;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import jpos.config.JposRegPopulator;
import jpos.loader.JposServiceLoader;
import jpos.util.JposProperties;
import jpos.util.tracing.Tracer;
import jpos.util.tracing.TracerFactory;

public abstract class AbstractRegPopulator
implements JposRegPopulator {
    private Hashtable jposEntries = new Hashtable();
    private InputStream populatorIS = null;
    private OutputStream populatorOS = null;
    private String populatorFileName = "";
    private String populatorFileURL = "";
    private String uniqueId = "";
    protected Exception lastLoadException = null;
    private Tracer tracer = TracerFactory.getInstance().createTracer("AbstractRegPopulator");

    public AbstractRegPopulator(String id) {
        this.setUniqueId(id);
    }

    public abstract void save(Enumeration var1) throws Exception;

    public abstract void save(Enumeration var1, String var2) throws Exception;

    public abstract void load();

    public abstract void load(String var1);

    public abstract URL getEntriesURL();

    public abstract String getName();

    public String getUniqueId() {
        return this.uniqueId.equals("") ? this.getClassName() : this.uniqueId;
    }

    public Enumeration getEntries() {
        Vector vector = new Vector();
        Enumeration entries = this.jposEntries.elements();
        while (entries.hasMoreElements()) {
            vector.addElement(entries.nextElement());
        }
        return vector.elements();
    }

    public boolean isComposite() {
        return false;
    }

    public String toString() {
        return this.getName();
    }

    public Exception getLastLoadException() {
        return this.lastLoadException;
    }

    protected URL createURLFromFile(File file) {
        URL url = null;
        try {
            url = new URL("file", "", file.getAbsolutePath());
        }
        catch (Exception e) {
            this.tracer.println("Error creating URL: Exception.message=" + e.getMessage());
        }
        return url;
    }

    protected URL createURLFromFile(ZipFile zipFile) {
        URL url = null;
        try {
            url = new URL("jar", "", new File(zipFile.getName()).getAbsolutePath());
        }
        catch (Exception e) {
            this.tracer.println("Error creating URL: Exception.message=" + e.getMessage());
        }
        return url;
    }

    protected Hashtable getJposEntries() {
        return this.jposEntries;
    }

    protected boolean isPopulatorFileDefined() {
        boolean defined = false;
        JposProperties jposProperties = JposServiceLoader.getManager().getProperties();
        if (jposProperties.isPropertyDefined("jpos.config.populatorFile")) {
            defined = true;
        } else if (jposProperties.isPropertyDefined("jpos.config.populatorFileURL")) {
            defined = true;
        }
        return defined;
    }

    protected InputStream getPopulatorFileIS() throws Exception {
        JposProperties jposProperties = JposServiceLoader.getManager().getProperties();
        if (jposProperties.isPropertyDefined("jpos.config.populatorFile")) {
            this.populatorFileName = jposProperties.getPropertyString("jpos.config.populatorFile");
            this.tracer.println("getPopulatorFileIS(): populatorFileName=" + this.populatorFileName);
            this.populatorIS = new FileInputStream(this.populatorFileName);
        } else if (jposProperties.isPropertyDefined("jpos.config.populatorFileURL")) {
            this.populatorFileURL = jposProperties.getPropertyString("jpos.config.populatorFileURL");
            URL url = new URL(this.populatorFileURL);
            this.populatorIS = url.openStream();
            this.tracer.println("getPopulatorFileIS(): populatorFileURL=" + this.populatorFileURL);
        } else {
            String msg = "jpos.config.populatorFile OR  jpos.config.populatorFileURL properties not defined";
            this.tracer.println(msg);
            throw new Exception(msg);
        }
        return this.populatorIS;
    }

    protected OutputStream getPopulatorFileOS() throws Exception {
        JposProperties jposProperties = JposServiceLoader.getManager().getProperties();
        if (jposProperties.isPropertyDefined("jpos.config.populatorFile")) {
            this.populatorFileName = jposProperties.getPropertyString("jpos.config.populatorFile");
            this.populatorOS = new FileOutputStream(this.populatorFileName);
        } else if (jposProperties.isPropertyDefined("jpos.config.populatorFileURL")) {
            this.populatorFileURL = jposProperties.getPropertyString("jpos.config.populatorFileURL");
            URL url = new URL(this.populatorFileURL);
            this.populatorOS = url.openConnection().getOutputStream();
        } else {
            String msg = "jpos.config.populatorFile OR jpos.config.populatorFileURL properties not defined";
            this.tracer.println(msg);
            throw new Exception(msg);
        }
        return this.populatorOS;
    }

    protected String getPopulatorFileName() {
        return this.populatorFileName;
    }

    protected String getPopulatorFileURL() {
        return this.populatorFileURL;
    }

    protected void setUniqueId(String s) {
        this.uniqueId = s;
    }

    protected InputStream findFileInClasspath(String fileName) {
        String classpath = System.getProperty("java.class.path");
        String pathSeparator = System.getProperty("path.separator");
        String fileSeparator = System.getProperty("file.separator");
        BufferedInputStream is = null;
        if (fileName.startsWith(".") || fileName.startsWith(fileSeparator)) {
            try {
                is = new BufferedInputStream(new FileInputStream(fileName));
            }
            catch (IOException ioe) {
                is = null;
                this.tracer.println("findFileInClasspath: IOException.msg=" + ioe.getMessage());
            }
            return is;
        }
        String path = "";
        Vector<String> jarZipFilesVector = new Vector<String>();
        StringTokenizer st = new StringTokenizer(classpath, pathSeparator, false);
        while (st.hasMoreTokens()) {
            try {
                path = st.nextToken().trim();
                if (path.equals("")) continue;
                if (path.length() > 4 && (path.endsWith(".zip") || path.endsWith(".jar"))) {
                    jarZipFilesVector.addElement(path);
                    continue;
                }
                String absoluteFileName = path + (fileName.startsWith(fileSeparator) || path.endsWith(fileSeparator) ? "" : fileSeparator) + fileName;
                is = new BufferedInputStream(new FileInputStream(absoluteFileName));
                break;
            }
            catch (Exception e) {
            }
        }
        if (is == null) {
            return this.findFileInJarZipFiles(fileName, jarZipFilesVector);
        }
        return is;
    }

    protected InputStream findFileInJarZipFiles(String fileName, Vector jarZipFilesVector) {
        BufferedInputStream is = null;
        for (int i = 0; i < jarZipFilesVector.size(); ++i) {
            String jarZipFileName = (String)jarZipFilesVector.elementAt(i);
            try {
                ZipFile zipFile = new ZipFile(jarZipFileName);
                Enumeration<? extends ZipEntry> zipEntries = zipFile.entries();
                while (zipEntries.hasMoreElements()) {
                    ZipEntry zipEntry = zipEntries.nextElement();
                    String entryName = zipEntry.getName();
                    if (!entryName.endsWith(fileName)) continue;
                    is = new BufferedInputStream(zipFile.getInputStream(zipEntry));
                    break;
                }
            }
            catch (Exception e) {
                this.tracer.println("findInJarZipFiles: Exception.message=" + e.getMessage());
            }
            if (is != null) break;
        }
        return is;
    }
}

