/*
 * Decompiled with CFR 0.152.
 */
package pl.novitus.javapos.service.impl.printer;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.LinkedHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pl.novitus.javapos.data.POSAndClerkId;
import pl.novitus.javapos.service.impl.printer.LegacyServiceBase;
import pl.novitus.javapos.utils.FiscalDeviceException;
import pl.novitus.javapos.utils.printer.LegacyPacketBuilder;
import pl.novitus.javapos.utils.printer.LegacyPacketParser;

public class LegacyDateTimeService
extends LegacyServiceBase {
    private static final Logger log = LogManager.getLogger(LegacyDateTimeService.class);

    public void setDateTime(Calendar date, POSAndClerkId posAndClerkId) throws FiscalDeviceException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        log.debug("setDateTime(): date: " + sdf.format(date.getTime()));
        LegacyPacketBuilder builder = new LegacyPacketBuilder();
        builder.begin().add("", date.get(1) % 100).fieldSeparator().add("", date.get(2) + 1).fieldSeparator().add("", date.get(5)).fieldSeparator().add("", date.get(11)).fieldSeparator().add("", date.get(12)).fieldSeparator().add("", date.get(13)).addType("$c");
        posAndClerkId.addToPacket(builder);
        builder.end();
        String request = builder.toString();
        this.getProtocol().sendPacket(request);
        this.getProtocol().checkError();
    }

    public Calendar getDateTime() throws FiscalDeviceException {
        LegacyPacketBuilder builder = new LegacyPacketBuilder();
        builder.begin().addType("#c").end();
        String request = builder.toString();
        this.getProtocol().sendPacket(request);
        String response = this.getProtocol().receivePacket(true);
        LegacyPacketParser parser = new LegacyPacketParser("1#C");
        parser.parse(response);
        Calendar result = Calendar.getInstance();
        LinkedHashMap<String, String> values = parser.getValues();
        result.set(Integer.parseInt(values.get("1")) + 2000, Integer.parseInt(values.get("2")) - 1, Integer.parseInt(values.get("3")), Integer.parseInt(values.get("4")), Integer.parseInt(values.get("5")));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        log.debug("getDateTime(): result: " + sdf.format(result.getTime()));
        return result;
    }
}

