/*
 * Decompiled with CFR 0.152.
 */
package pl.novitus.javapos.service.impl.printer;

import java.math.BigDecimal;
import java.math.RoundingMode;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pl.novitus.javapos.data.POSAndClerkId;
import pl.novitus.javapos.service.impl.printer.LegacyServiceBase;
import pl.novitus.javapos.utils.FiscalDeviceException;
import pl.novitus.javapos.utils.printer.LegacyPacketBuilder;

public class LegacyCashService
extends LegacyServiceBase {
    private static final Logger log = LogManager.getLogger(LegacyCashService.class);

    private String buildCashInOutPacket(String type, BigDecimal amount, POSAndClerkId posAndClerkId) throws FiscalDeviceException {
        amount = amount.setScale(2, RoundingMode.HALF_UP).stripTrailingZeros();
        LegacyPacketBuilder builder = new LegacyPacketBuilder();
        builder.begin().addType(type).add("", amount.toPlainString()).valueSeparator();
        posAndClerkId.addToPacket(builder);
        builder.end();
        return builder.toString();
    }

    public void cashIn(BigDecimal amount, POSAndClerkId posAndClerkId) throws FiscalDeviceException {
        String request = this.buildCashInOutPacket("#i", amount, posAndClerkId);
        this.getProtocol().sendPacket(request);
        this.getProtocol().checkError();
    }

    public void cashOut(BigDecimal amount, POSAndClerkId posAndClerkId) throws FiscalDeviceException {
        String request = this.buildCashInOutPacket("#d", amount, posAndClerkId);
        this.getProtocol().sendPacket(request);
        this.getProtocol().checkError();
    }
}

