/*
 * Decompiled with CFR 0.152.
 */
package pl.novitus.javapos.utils.converters;

import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import pl.novitus.javapos.utils.CharsetConverter;
import pl.novitus.javapos.utils.converters.MazoviaCharsetConverter;

public class DefaultCharsetConverter
implements CharsetConverter {
    protected static final String[] _utf8 = new String[]{"\u0105", "\u0107", "\u0119", "\u0142", "\u0144", "\u00f3", "\u015b", "\u017c", "\u017a", "\u0104", "\u0106", "\u0118", "\u0141", "\u0143", "\u00d3", "\u015a", "\u017b", "\u0179"};

    protected byte[] UTF82byte(String src, Integer[] cTable) {
        try {
            byte[] rb = src.getBytes("ASCII");
            String s = String.join((CharSequence)"", _utf8);
            for (int i = 0; i < src.length(); ++i) {
                int ix = s.indexOf(src.charAt(i));
                if (ix == -1) continue;
                rb[i] = cTable[ix].byteValue();
            }
            return rb;
        }
        catch (UnsupportedEncodingException ex) {
            Logger.getLogger(MazoviaCharsetConverter.class.getName()).log(Level.SEVERE, null, ex);
            return src.getBytes();
        }
    }

    protected String byte2UTF8(byte[] src, Integer[] cTable) {
        StringBuffer sb = new StringBuffer();
        Byte[] ba = new Byte[cTable.length];
        for (int i = 0; i < cTable.length; ++i) {
            ba[i] = cTable[i].byteValue();
        }
        List<Byte> li = Arrays.asList(ba);
        for (int i = 0; i < src.length; ++i) {
            byte ci = src[i];
            int ai = li.indexOf(ci);
            if (ai != -1) {
                sb.append(_utf8[ai]);
                continue;
            }
            sb.append((char)ci);
        }
        return sb.toString();
    }

    @Override
    public byte[] fromUTF8(String src) {
        return src.getBytes();
    }

    @Override
    public String toUTF8(byte[] src) {
        return new String(src);
    }
}

