/*
 * Decompiled with CFR 0.152.
 */
package pl.novitus.javapos.service.impl.printer;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import pl.novitus.javapos.data.POSAndClerkId;
import pl.novitus.javapos.data.POSReport;
import pl.novitus.javapos.data.ReceiptItem;
import pl.novitus.javapos.data.TaxRate;
import pl.novitus.javapos.service.impl.printer.LegacyPOSReportService;
import pl.novitus.javapos.service.impl.printer.LegacyServiceBase;
import pl.novitus.javapos.utils.FiscalDeviceException;
import pl.novitus.javapos.utils.i18n.I18n;
import pl.novitus.javapos.utils.printer.LegacyPacketBuilder;
import pl.novitus.javapos.utils.printer.LegacyPacketParser;

public class LegacyReceiptService
extends LegacyServiceBase {
    HashMap<Integer, BigDecimal> payments = new HashMap();
    HashMap<Integer, String> paymentDescr = new HashMap();
    ArrayList<String> footerMessages = new ArrayList();
    HashMap<Integer, DepositInfo> packageSales = new HashMap();
    HashMap<Integer, DepositInfo> packageReturns = new HashMap();
    List<String> messages = new ArrayList<String>();
    Stack<ReceiptItem> itemBuffer = new Stack();
    int itemCounter;
    int maxMessages = 5;
    BigDecimal total;
    BigDecimal subtotal;
    boolean isInvoice = false;
    public static final String PACKAGE_NAME_MARKER = "#";

    public void beginReceipt() throws FiscalDeviceException {
        this.payments.clear();
        this.messages.clear();
        this.footerMessages.clear();
        this.packageSales.clear();
        this.packageReturns.clear();
        this.itemCounter = 0;
        this.total = this.subtotal = BigDecimal.ZERO;
        this.isInvoice = false;
        LegacyPacketBuilder builder = new LegacyPacketBuilder();
        builder.begin().add("", 0).addType("$h").end();
        String request = builder.toString();
        this.getProtocol().sendPacket(request);
        this.getProtocol().checkError();
    }

    public void beginInvoice(String header) throws FiscalDeviceException {
        this.payments.clear();
        this.messages.clear();
        this.footerMessages.clear();
        this.packageSales.clear();
        this.packageReturns.clear();
        this.itemCounter = 0;
        this.total = this.subtotal = BigDecimal.ZERO;
        this.isInvoice = false;
        String[] fvh = header.split(Pattern.quote("|"));
        if (fvh.length < 3) {
            throw new FiscalDeviceException(4, I18n.tr("strIncompleteInvoiceHeader"));
        }
        LegacyPacketBuilder builder = new LegacyPacketBuilder();
        builder.begin().add("", 0).fieldSeparator().add("", fvh.length - 3).fieldSeparator().add("", 1).fieldSeparator().add("", 2).fieldSeparator().add("", 0).fieldSeparator().add("", "").fieldSeparator().add("", 0).fieldSeparator().add("", "").fieldSeparator().add("", "").fieldSeparator().add("", 1).fieldSeparator().add("", 0).addType("$h").add("", fvh[0]).stringSeparator();
        for (int i = 3; i < fvh.length; ++i) {
            builder.add("", fvh[i]).stringSeparator();
        }
        builder.add("", fvh[1]).stringSeparator().add("", "").stringSeparator().add("", "").stringSeparator().add("", "").stringSeparator().add("", "").stringSeparator().add("", "").stringSeparator().add("", fvh[2]).stringSeparator().end();
        String request = builder.toString();
        this.getProtocol().sendPacket(request);
        this.getProtocol().checkError();
        this.isInvoice = true;
    }

    private String getMessage(int idx) {
        if (this.messages.size() > idx) {
            return this.messages.get(idx);
        }
        return "";
    }

    private String getPaymentDescr(int idx) {
        if (this.paymentDescr.containsKey(idx)) {
            return this.paymentDescr.get(idx);
        }
        return "";
    }

    private BigDecimal getPaymentVal(int idx) {
        if (this.payments.containsKey(idx)) {
            return this.payments.get(idx).setScale(2, RoundingMode.HALF_UP).stripTrailingZeros();
        }
        return BigDecimal.ZERO;
    }

    public void endInvoice() throws FiscalDeviceException {
        LegacyPacketBuilder builder = new LegacyPacketBuilder();
        if (!this.isInvoice) {
            throw new FiscalDeviceException(4, I18n.tr("strNotInvoice"));
        }
        builder.begin().add("", 1).fieldSeparator().add("", 0).fieldSeparator().add("", 0).fieldSeparator().add("", 0).fieldSeparator().add("", 0).fieldSeparator().add("", 1).fieldSeparator().add("", 0).fieldSeparator().add("", 1).fieldSeparator().add("", 1).fieldSeparator().addType("$e").add("", "").stringSeparator().add("", "").stringSeparator().add("", "").stringSeparator().add("", "").stringSeparator().add("", this.total.setScale(2, RoundingMode.HALF_UP).stripTrailingZeros().toPlainString()).valueSeparator().add("", this.total.setScale(2, RoundingMode.HALF_UP).stripTrailingZeros().toPlainString()).valueSeparator().add("", 0).valueSeparator();
        builder.end();
        String request = builder.toString();
        this.getProtocol().sendPacket(request);
        this.getProtocol().checkError();
    }

    public void total(BigDecimal total, BigDecimal payment, int type, String descr) throws FiscalDeviceException {
        if (this.payments.containsKey(type)) {
            payment = payment.add(this.payments.get(type));
        }
        this.payments.put(type, payment);
        if (descr != null) {
            this.paymentDescr.put(type, descr);
        }
        this.total = total;
    }

    public void totalEur(BigDecimal total, BigDecimal payment, int type, String[] data) throws FiscalDeviceException {
        if (data.length < 3) {
            throw new FiscalDeviceException(4);
        }
        String currName = null;
        BigDecimal xchgRate = BigDecimal.ZERO;
        boolean change = payment.compareTo(BigDecimal.ZERO) < 0;
        payment = payment.abs();
        try {
            currName = data[1];
            xchgRate = this.jposValueToValue(Integer.parseInt(data[2]));
        }
        catch (Exception e) {
            throw new FiscalDeviceException(4);
        }
        this.total = total;
        BigDecimal currAmt = payment.multiply(xchgRate);
        LegacyPacketBuilder builder = new LegacyPacketBuilder();
        builder.begin().add("", 0).fieldSeparator().add("", 7).fieldSeparator().add("", 0).fieldSeparator().add("", 0).fieldSeparator().add("", change ? 1 : 0).fieldSeparator().add("", 0).addType("$b").add("", currAmt.setScale(2, RoundingMode.HALF_UP).stripTrailingZeros().toPlainString()).valueSeparator().add("", currName).stringSeparator().add("", xchgRate.scaleByPowerOfTen(4).stripTrailingZeros().toPlainString()).stringSeparator().add("", payment.setScale(2, RoundingMode.HALF_UP).stripTrailingZeros().toPlainString()).valueSeparator().end();
        String request = builder.toString();
        this.getProtocol().sendPacket(request);
        this.getProtocol().checkError();
    }

    public void cancelReceipt(POSAndClerkId posAndClerkId) throws FiscalDeviceException {
        this.itemBuffer.clear();
        LegacyPacketBuilder builder = new LegacyPacketBuilder();
        builder.begin().add("", 0).addType("$e");
        posAndClerkId.addToPacket(builder);
        builder.end();
        String request = builder.toString();
        this.getProtocol().sendPacket(request);
        this.itemCounter = 0;
    }

    private String itemToPacket(ReceiptItem item, int counter) {
        LegacyPacketBuilder builder = new LegacyPacketBuilder();
        String qtyunit = item.getQuantity().toPlainString() + "" + item.getUnit();
        if (!this.isInvoice) {
            builder.begin().add("", counter).fieldSeparator().add("", item.getDiscountType()).fieldSeparator().add("", 0).addType("$l").add("", item.getItemName() == null ? "" : item.getItemName(), 40).stringSeparator().add("", qtyunit, 16).stringSeparator().add("", String.valueOf(item.getTaxId())).valueSeparator().add("", item.getPrice().toPlainString()).valueSeparator().add("", item.getValue().toPlainString()).valueSeparator().add("", item.getDiscount()).valueSeparator();
            if (item.getDiscountName() != null) {
                builder.add("", item.getDiscountName(), 16).stringSeparator();
            }
        } else {
            builder.begin().add("", counter).addType("$l").add("", item.getItemName() == null ? "" : item.getItemName(), 40).stringSeparator().add("", qtyunit, 16).stringSeparator().add("", String.valueOf(item.getTaxId())).valueSeparator().add("", item.getPrice().toPlainString()).valueSeparator().add("", item.getValue().toPlainString()).valueSeparator();
        }
        return builder.end().toString();
    }

    public void flushItemBuffer() throws FiscalDeviceException {
        if (this.itemBuffer.size() > 0) {
            ReceiptItem item = this.itemBuffer.pop();
            String request = this.itemToPacket(item, this.itemCounter);
            this.itemBuffer.clear();
            this.getProtocol().sendPacket(request);
            this.getProtocol().checkError();
        }
    }

    public void additem(ReceiptItem item) throws FiscalDeviceException {
        this.flushItemBuffer();
        try {
            this.itemBuffer.push(item.clone());
        }
        catch (CloneNotSupportedException ex) {
            Logger.getLogger(LegacyReceiptService.class.getName()).log(Level.SEVERE, null, ex);
        }
        ++this.itemCounter;
    }

    public void voidItem(ReceiptItem item) throws FiscalDeviceException {
        this.flushItemBuffer();
        String request = this.itemToPacket(item, 0);
        this.getProtocol().sendPacket(request);
        this.getProtocol().checkError();
        this.itemCounter = this.itemCounter > 0 ? this.itemCounter - 1 : 0;
    }

    public void adjustItem(ReceiptItem item) throws FiscalDeviceException {
        ReceiptItem oldItem;
        if (this.itemBuffer.size() == 0) {
            throw new FiscalDeviceException(4, "No receipt item to apply adjustment");
        }
        try {
            oldItem = this.itemBuffer.peek().clone();
        }
        catch (CloneNotSupportedException ex) {
            Logger.getLogger(LegacyReceiptService.class.getName()).log(Level.SEVERE, null, ex);
            throw new FiscalDeviceException(-1);
        }
        oldItem.setDiscountType(item.getDiscountType());
        oldItem.setDiscount(item.getDiscount().abs());
        if (item.getItemName() != null) {
            oldItem.setItemName(item.getItemName());
        }
        this.itemBuffer.push(oldItem);
    }

    public void voidAdjustItem(ReceiptItem item) throws FiscalDeviceException {
        if (this.itemBuffer.size() < 2) {
            throw new FiscalDeviceException(4, "No receipt item to void adjustment");
        }
        this.itemBuffer.pop();
    }

    public void addFooterMessage(int id, String message) throws FiscalDeviceException {
        this.footerMessages.add(Converters.MessageType.formatMessage(id, message, 40));
    }

    public void addMessage(String message) throws FiscalDeviceException {
        if (this.messages.size() == this.getMaxMessages()) {
            throw new FiscalDeviceException(84);
        }
        this.messages.add(message);
    }

    public BigDecimal getSubtotal() {
        return this.subtotal;
    }

    public void subtotal(BigDecimal subtotal) throws FiscalDeviceException {
        this.flushItemBuffer();
        this.subtotal = subtotal;
    }

    public int getMaxMessages() {
        return this.maxMessages;
    }

    public void setMaxMessages(int maxMessages) {
        this.maxMessages = maxMessages;
    }

    public void verifyItem(ReceiptItem item, POSAndClerkId posAndClerkId) throws FiscalDeviceException {
        LegacyPacketBuilder builder = new LegacyPacketBuilder();
        builder.begin().addType("$g").add("", item.getItemName() == null ? "" : item.getItemName()).stringSeparator().add("", String.valueOf(item.getTaxId())).valueSeparator().end();
        this.getProtocol().sendPacket(builder.toString());
        String response = this.getProtocol().receivePacket(true);
        LegacyPacketParser parser = new LegacyPacketParser("1$G");
        parser.parse(response);
        int r = Integer.parseInt(parser.getValues().get("1"));
        if (r != 0) {
            throw new FiscalDeviceException(36);
        }
    }

    public void endReceipt() throws FiscalDeviceException {
        LegacyPacketBuilder builder = new LegacyPacketBuilder();
        builder.begin();
        if (this.isInvoice) {
            throw new FiscalDeviceException(4, I18n.tr("strNotReceipt"));
        }
        builder.add("", 0).fieldSeparator().add("", 3).fieldSeparator().add("", 0).fieldSeparator().add("", 0).fieldSeparator().add("", 0).fieldSeparator().add("", this.packageSales.size()).fieldSeparator().add("", this.packageReturns.size()).fieldSeparator().add("", 0).fieldSeparator().add("", this.payments.size() - (this.payments.containsKey(0) ? 1 : 0)).fieldSeparator().add("", 0).fieldSeparator().add("", this.payments.containsKey(0) ? 1 : 0).fieldSeparator();
        Iterator<Object> iterator = this.payments.keySet().iterator();
        while (iterator.hasNext()) {
            int n = iterator.next();
            if (n == 0) continue;
            builder.add("", n).fieldSeparator();
        }
        builder.addType("$y").add("", "").stringSeparator().add("", "").stringSeparator().add("", "").stringSeparator();
        iterator = this.payments.keySet().iterator();
        while (iterator.hasNext()) {
            int n = iterator.next();
            if (n == 0) continue;
            builder.add("", this.getPaymentDescr(n)).stringSeparator();
        }
        for (Map.Entry entry : this.packageSales.entrySet()) {
            builder.add("", (Integer)entry.getKey());
            builder.stringSeparator();
        }
        for (Map.Entry entry : this.packageSales.entrySet()) {
            builder.add("", ((DepositInfo)entry.getValue()).count.toPlainString());
            builder.stringSeparator();
        }
        for (Map.Entry entry : this.packageReturns.entrySet()) {
            builder.add("", (Integer)entry.getKey());
            builder.stringSeparator();
        }
        for (Map.Entry entry : this.packageReturns.entrySet()) {
            builder.add("", ((DepositInfo)entry.getValue()).count.toPlainString());
            builder.stringSeparator();
        }
        builder.add("", this.total.setScale(2, RoundingMode.HALF_UP).stripTrailingZeros().toPlainString()).valueSeparator().add("", 0).valueSeparator().add("", 0).valueSeparator().add("", this.getPaymentVal(0).toPlainString()).valueSeparator();
        iterator = this.payments.keySet().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            if (n == 0) continue;
            builder.add("", this.getPaymentVal(n).toPlainString()).valueSeparator();
        }
        builder.add("", 0).valueSeparator();
        for (Map.Entry entry : this.packageSales.entrySet()) {
            builder.add("", ((DepositInfo)entry.getValue()).value.toPlainString());
            builder.valueSeparator();
        }
        for (Map.Entry entry : this.packageReturns.entrySet()) {
            builder.add("", ((DepositInfo)entry.getValue()).value.toPlainString());
            builder.valueSeparator();
        }
        builder.end();
        String request = builder.toString();
        this.getProtocol().sendPacket(request);
        this.getProtocol().checkError();
        this.printFooterMessages();
    }

    private void printFooterMessages() throws FiscalDeviceException {
        for (String i : this.footerMessages) {
            LegacyPacketBuilder builder = new LegacyPacketBuilder();
            builder.begin();
            builder.add("", 200).fieldSeparator().add("", 0).addType("$w").add("", i).stringSeparator().stringSeparator().stringSeparator().stringSeparator().stringSeparator().stringSeparator().stringSeparator();
            builder.end();
            String request = builder.toString();
            this.getProtocol().sendPacket(request);
            this.getProtocol().checkError();
        }
        LegacyPacketBuilder builder = new LegacyPacketBuilder();
        builder.begin().addType("28$z").end();
        String request = builder.toString();
        this.getProtocol().sendPacket(request);
        this.getProtocol().checkError();
    }

    private BigDecimal getTaxTotal(int taxIdx) throws FiscalDeviceException {
        LegacyPOSReportService s = new LegacyPOSReportService();
        s.setProtocol(this.getProtocol());
        POSReport r = s.getReport(22);
        String tr = String.valueOf(TaxRate.taxIndexToTaxId(taxIdx));
        if (!r.getTotalizers().keySet().contains(tr)) {
            throw new FiscalDeviceException(4);
        }
        BigDecimal res = r.getTotalizers().get(tr);
        res = res.scaleByPowerOfTen(2);
        return res;
    }

    public void adjustTaxGroup(int jposAdjType, String data, String descr) throws FiscalDeviceException {
        String[] sd = data.split(",");
        if (sd.length != 2) {
            throw new FiscalDeviceException(4);
        }
        int taxIdx = Integer.parseInt(sd[0]);
        int aType = new Converters.TaxGroupAdjustmentType().fromJavaPos(jposAdjType);
        BigDecimal rateTotal = this.getTaxTotal(taxIdx);
        rateTotal = rateTotal.movePointLeft(2);
        BigDecimal aValue = new BigDecimal(sd[1]);
        LegacyPacketBuilder builder = new LegacyPacketBuilder();
        builder.begin().add("", taxIdx - 1).fieldSeparator().add("", aType).fieldSeparator().addType("16$L").add("", rateTotal.setScale(2, RoundingMode.HALF_UP).stripTrailingZeros().toPlainString()).valueSeparator().add("", aValue.setScale(2, RoundingMode.HALF_UP).stripTrailingZeros().toPlainString()).valueSeparator().add("", descr).stringSeparator().end();
        String request = builder.toString();
        this.getProtocol().sendPacket(request);
        this.getProtocol().checkError();
    }

    public void packageSale(ReceiptItem item) throws FiscalDeviceException {
        String[] pn = item.getItemName().split(PACKAGE_NAME_MARKER);
        int n = 0;
        if (pn.length != 2) {
            throw new FiscalDeviceException(4);
        }
        try {
            n = Integer.parseInt(pn[1]);
        }
        catch (Exception e) {
            throw new FiscalDeviceException(4);
        }
        LegacyPacketBuilder builder = new LegacyPacketBuilder();
        builder.begin().addType("6$l").add("", n).stringSeparator().add("", item.getQuantity().toPlainString()).stringSeparator().add("", "P").valueSeparator().add("", item.getPrice().toPlainString()).valueSeparator().add("", item.getValue().toPlainString()).valueSeparator().end();
        String request = builder.toString();
        this.getProtocol().sendPacket(request);
        this.getProtocol().checkError();
        DepositInfo di = this.packageSales.containsKey(n) ? this.packageSales.get(n) : new DepositInfo();
        di.value = di.value.add(item.getValue());
        di.count = di.count.add(item.getQuantity());
        this.packageSales.put(n, di);
    }

    public void packageReturn(ReceiptItem item) throws FiscalDeviceException {
        String[] pn = item.getItemName().split(PACKAGE_NAME_MARKER);
        int n = 0;
        if (pn.length != 2) {
            throw new FiscalDeviceException(4);
        }
        try {
            n = Integer.parseInt(pn[1]);
        }
        catch (Exception e) {
            throw new FiscalDeviceException(4);
        }
        LegacyPacketBuilder builder = new LegacyPacketBuilder();
        builder.begin().addType("10$l").add("", n).stringSeparator().add("", item.getQuantity().toPlainString()).stringSeparator().add("", "P").valueSeparator().add("", item.getPrice().toPlainString()).valueSeparator().add("", item.getValue().toPlainString()).valueSeparator().end();
        String request = builder.toString();
        this.getProtocol().sendPacket(request);
        this.getProtocol().checkError();
        DepositInfo di = this.packageReturns.containsKey(n) ? this.packageReturns.get(n) : new DepositInfo();
        di.value = di.value.add(item.getValue());
        di.count = di.count.add(item.getQuantity());
        this.packageReturns.put(n, di);
    }

    public static interface Converters {

        public static class TaxGroupAdjustmentType {
            private static final Map<Integer, Integer> M_JPOS_ADJUSTMENT_TYPES = new HashMap<Integer, Integer>(){
                {
                    this.put(0, 0);
                    this.put(1, 3);
                    this.put(2, 4);
                    this.put(3, 1);
                    this.put(4, 2);
                }
            };

            public int fromJavaPos(int jpcode) throws FiscalDeviceException {
                int result = -1;
                if (M_JPOS_ADJUSTMENT_TYPES.containsKey(jpcode)) {
                    result = M_JPOS_ADJUSTMENT_TYPES.get(jpcode);
                }
                if (result < -1) {
                    throw new FiscalDeviceException(4);
                }
                return result;
            }
        }

        public static class AdjustmentType {
            private static final Map<Integer, Integer> M_JPOS_ADJUSTMENT_TYPES = new HashMap<Integer, Integer>(){
                {
                    this.put(0, 0);
                    this.put(1, 1);
                    this.put(2, 2);
                    this.put(3, 3);
                    this.put(4, 4);
                    this.put(5, 1);
                    this.put(6, 2);
                }
            };

            public int fromJavaPos(int jpcode) throws FiscalDeviceException {
                int result = -1;
                if (M_JPOS_ADJUSTMENT_TYPES.containsKey(jpcode)) {
                    result = M_JPOS_ADJUSTMENT_TYPES.get(jpcode);
                }
                if (result < -1) {
                    throw new FiscalDeviceException(4);
                }
                return result;
            }
        }

        public static class MessageType {
            private static final int[] JPOS_CODES = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50};
            private static HashMap<Integer, String> msgs = new HashMap();

            private static synchronized void initializeMessages() {
                msgs.put(1, I18n.tr("FPTR_MT_ADVANCE"));
                msgs.put(2, I18n.tr("FPTR_MT_ADVANCE_PAID"));
                msgs.put(3, I18n.tr("FPTR_MT_AMOUNT_TO_BE_PAID"));
                msgs.put(4, I18n.tr("FPTR_MT_AMOUNT_TO_BE_PAID_BACK"));
                msgs.put(5, I18n.tr("FPTR_MT_CARD"));
                msgs.put(6, I18n.tr("FPTR_MT_CARD_NUMBER"));
                msgs.put(7, I18n.tr("FPTR_MT_CARD_TYPE"));
                msgs.put(8, I18n.tr("FPTR_MT_CASH"));
                msgs.put(9, I18n.tr("FPTR_MT_CASHIER"));
                msgs.put(10, I18n.tr("FPTR_MT_CASH_REGISTER_NUMBER"));
                msgs.put(11, I18n.tr("FPTR_MT_CHANGE"));
                msgs.put(12, I18n.tr("FPTR_MT_CHEQUE"));
                msgs.put(13, I18n.tr("FPTR_MT_CLIENT_NUMBER"));
                msgs.put(14, I18n.tr("FPTR_MT_CLIENT_SIGNATURE"));
                msgs.put(15, I18n.tr("FPTR_MT_COUNTER_STATE"));
                msgs.put(16, I18n.tr("FPTR_MT_CREDIT_CARD"));
                msgs.put(17, I18n.tr("FPTR_MT_CURRENCY"));
                msgs.put(18, I18n.tr("FPTR_MT_CURRENCY_VALUE"));
                msgs.put(19, I18n.tr("FPTR_MT_DEPOSIT"));
                msgs.put(20, I18n.tr("FPTR_MT_DEPOSIT_RETURNED"));
                msgs.put(21, I18n.tr("FPTR_MT_DOT_LINE"));
                msgs.put(22, I18n.tr("FPTR_MT_DRIVER_NUMB"));
                msgs.put(23, I18n.tr("FPTR_MT_EMPTY_LINE"));
                msgs.put(24, I18n.tr("FPTR_MT_FREE_TEXT"));
                msgs.put(25, I18n.tr("FPTR_MT_FREE_TEXT_WITH_DAY_LIMIT"));
                msgs.put(26, I18n.tr("FPTR_MT_GIVEN_DISCOUNT"));
                msgs.put(27, I18n.tr("FPTR_MT_LOCAL_CREDIT"));
                msgs.put(28, I18n.tr("FPTR_MT_MILEAGE_KM"));
                msgs.put(29, I18n.tr("FPTR_MT_NOTE"));
                msgs.put(30, I18n.tr("FPTR_MT_PAID"));
                msgs.put(31, I18n.tr("FPTR_MT_PAY_IN"));
                msgs.put(32, I18n.tr("FPTR_MT_POINT_GRANTED"));
                msgs.put(33, I18n.tr("FPTR_MT_POINTS_BONUS"));
                msgs.put(34, I18n.tr("FPTR_MT_POINTS_RECEIPT"));
                msgs.put(35, I18n.tr("FPTR_MT_POINTS_TOTAL"));
                msgs.put(36, I18n.tr("FPTR_MT_PROFITED"));
                msgs.put(37, I18n.tr("FPTR_MT_RATE"));
                msgs.put(38, I18n.tr("FPTR_MT_REGISTER_NUMB"));
                msgs.put(39, I18n.tr("FPTR_MT_SHIFT_NUMBER"));
                msgs.put(40, I18n.tr("FPTR_MT_STATE_OF_AN_ACCOUNT"));
                msgs.put(41, I18n.tr("FPTR_MT_SUBSCRIPTION"));
                msgs.put(42, I18n.tr("FPTR_MT_TABLE"));
                msgs.put(43, I18n.tr("FPTR_MT_THANK_YOU_FOR_LOYALTY"));
                msgs.put(44, I18n.tr("FPTR_MT_TRANSACTION_NUMB"));
                msgs.put(45, I18n.tr("FPTR_MT_VALID_TO"));
                msgs.put(46, I18n.tr("FPTR_MT_VOUCHER"));
                msgs.put(47, I18n.tr("FPTR_MT_VOUCHER_PAID"));
                msgs.put(48, I18n.tr("FPTR_MT_VOUCHER_VALUE"));
                msgs.put(49, I18n.tr("FPTR_MT_WITH_DISCOUNT"));
                msgs.put(50, I18n.tr("FPTR_MT_WITHOUT_UPLIFT"));
            }

            private static String getMessage(int message) {
                if (msgs.isEmpty()) {
                    MessageType.initializeMessages();
                }
                return msgs.get(message);
            }

            public static String formatMessage(int id, String msg, int msgLen) throws FiscalDeviceException {
                String m = MessageType.getMessage(id);
                if (m == null) {
                    throw new FiscalDeviceException(4);
                }
                String out = m + msg;
                return out;
            }
        }
    }

    private class DepositInfo {
        public BigDecimal count = BigDecimal.ZERO;
        public BigDecimal value = BigDecimal.ZERO;

        private DepositInfo() {
        }
    }
}

