/*
 * Decompiled with CFR 0.152.
 */
package pl.novitus.javapos.service;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import jpos.FiscalPrinterControl114;
import jpos.JposException;
import jpos.events.DirectIOListener;
import jpos.events.ErrorListener;
import jpos.events.OutputCompleteListener;
import jpos.events.StatusUpdateListener;
import jpos.services.EventCallbacks;
import jpos.services.FiscalPrinterService114;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pl.novitus.javapos.data.POSAndClerkId;
import pl.novitus.javapos.data.POSReport;
import pl.novitus.javapos.data.ReceiptItem;
import pl.novitus.javapos.data.TaxRate;
import pl.novitus.javapos.service.AbstractDeviceService;
import pl.novitus.javapos.service.impl.printer.LegacyCashService;
import pl.novitus.javapos.service.impl.printer.LegacyDateTimeService;
import pl.novitus.javapos.service.impl.printer.LegacyNonFiscalPrintoutService;
import pl.novitus.javapos.service.impl.printer.LegacyPOSReportService;
import pl.novitus.javapos.service.impl.printer.LegacyReceiptService;
import pl.novitus.javapos.service.impl.printer.LegacyReportService;
import pl.novitus.javapos.service.impl.printer.LegacyTaxRatesService;
import pl.novitus.javapos.utils.Connection;
import pl.novitus.javapos.utils.ConnectionException;
import pl.novitus.javapos.utils.FiscalDeviceException;
import pl.novitus.javapos.utils.Protocol;
import pl.novitus.javapos.utils.Utils;
import pl.novitus.javapos.utils.i18n.I18n;
import pl.novitus.javapos.utils.transport.LegacyFiscalPrinterProtocol;

public class HDeFiscalPrinter
extends AbstractDeviceService
implements FiscalPrinterControl114,
FiscalPrinterService114 {
    private static final Logger log = LogManager.getLogger(HDeFiscalPrinter.class);
    static final int DC_VERSION = 1014000;
    static final String DC_DESCRIPTION = "Novitus HDe fiscal printer driver v1.0h, (C) 2019 Novitus";
    public static final int MESSAGE_LENGTH = 25;
    protected int printerState;
    protected int fiscalReceiptStation;
    protected int fiscalReceiptType;
    protected int messageType;
    protected int totalizerType;
    protected int dateType;
    protected int powerNotify;
    protected int countryCode;
    protected int outputId = 0;
    protected boolean freezeEvents;
    protected String healthCheckText;
    protected String postLine;
    protected int nonFiscalLineCounter;
    protected POSAndClerkId posAndClerkId = new POSAndClerkId();
    protected LegacyReceiptService receiptService = new LegacyReceiptService();
    protected LegacyDateTimeService dateTimeService = new LegacyDateTimeService();
    protected LegacyNonFiscalPrintoutService nfprintoutService = new LegacyNonFiscalPrintoutService();
    protected LegacyPOSReportService posReportService = new LegacyPOSReportService();
    protected LegacyTaxRatesService taxRatesService = new LegacyTaxRatesService();
    protected LegacyReportService reportService = new LegacyReportService();
    protected LegacyCashService cashService = new LegacyCashService();
    protected String additionalHeader = "";
    private Protocol protocol;

    protected void assertPrinterState(int state) throws JposException {
    }

    public HDeFiscalPrinter() {
        this.setPrinterState(1);
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    LegacyFiscalPrinterProtocol getFPProtocol() {
        return (LegacyFiscalPrinterProtocol)this.getProtocol();
    }

    @Override
    public void setConnection(Connection conn) {
        if (this.protocol != null) {
            try {
                this.protocol.getConnection().close();
            }
            catch (ConnectionException ex) {
                log.warn("Exception thrown from connection.close(): " + ex.toString());
            }
        } else {
            this.protocol = new LegacyFiscalPrinterProtocol();
        }
        super.setConnection(conn);
        this.protocol.setConnection(this.getConnection());
        this.receiptService.setProtocol(this.protocol);
        this.dateTimeService.setProtocol(this.protocol);
        this.nfprintoutService.setProtocol(this.protocol);
        this.posReportService.setProtocol(this.protocol);
        this.taxRatesService.setProtocol(this.protocol);
        this.reportService.setProtocol(this.protocol);
        this.cashService.setProtocol(this.protocol);
    }

    public int getDeviceControlVersion() {
        log.debug("returning 1014000");
        return 1014000;
    }

    public String getDeviceControlDescription() {
        return DC_DESCRIPTION;
    }

    @Override
    public void open(String s, EventCallbacks eventcallbacks) throws JposException {
        super.open(s, eventcallbacks);
        this.freezeEvents = false;
        this.fiscalReceiptStation = 1;
        this.fiscalReceiptType = 2;
        this.messageType = 24;
        this.totalizerType = 3;
        this.dateType = 4;
        this.powerNotify = 0;
        this.countryCode = 16;
        this.healthCheckText = "";
    }

    @Override
    public void reset() {
        log.debug("reset()");
    }

    @Override
    public void claim(int arg0) throws JposException {
        super.claim(arg0);
        try {
            this.setFiscalReceiptType(4);
            this.getFPProtocol().initialize();
            this.setPrinterState(1);
        }
        catch (FiscalDeviceException ex) {
            log.warn("Unable to set error processing mode");
            throw new JposException(111, "Can't initialize device connection");
        }
    }

    public void printRecItemRefund(String name, long val, int q, int vat, long price, String unit) throws JposException {
        this.checkIfClaimed();
        this.assertPrinterState(2);
        try {
            ReceiptItem item = new ReceiptItem();
            item.setItemName(name);
            item.setUnit(unit);
            item.setValue(this.receiptService.jposValueToValue(val));
            q = q != 0 ? q : 1;
            item.setQuantity(this.receiptService.jposQuantityToQuantity(q));
            item.setPrice(this.receiptService.jposValueToValue(price));
            item.setTaxId(TaxRate.taxIndexToTaxId(vat));
            item.setItemDescription(this.postLine);
            if (item.getItemName().startsWith("#")) {
                this.receiptService.packageReturn(item);
            } else {
                this.notSupportedError();
            }
        }
        catch (FiscalDeviceException ex) {
            this.receiptService.translateError(ex);
        }
    }

    public void printRecItemRefundVoid(String string, long l, int i, int i1, long l1, String string1) throws JposException {
        this.notSupportedError();
    }

    public boolean getCapPositiveSubtotalAdjustment() throws JposException {
        this.checkIfOpen();
        return true;
    }

    public void printRecItemVoid(String name, long val, int q, int vat, long p, String unit) throws JposException {
        this.checkIfClaimed();
        this.assertPrinterState(2);
        try {
            ReceiptItem item = new ReceiptItem();
            item.setItemName(name);
            item.setUnit(unit);
            item.setValue(this.receiptService.jposValueToValue(val));
            q = q != 0 ? q : 1;
            item.setQuantity(this.receiptService.jposQuantityToQuantity(q));
            item.setPrice(this.receiptService.jposValueToValue(p));
            item.setTaxId(TaxRate.taxIndexToTaxId(vat));
            item.setItemDescription(this.postLine);
            this.receiptService.voidItem(item);
        }
        catch (FiscalDeviceException ex) {
            this.receiptService.translateError(ex);
        }
    }

    public void printRecItemAdjustmentVoid(int adj, String name, long val, int vat) throws JposException {
        this.checkIfClaimed();
        this.assertPrinterState(2);
        try {
            ReceiptItem item = new ReceiptItem();
            item.setDiscountType(new LegacyReceiptService.Converters.AdjustmentType().fromJavaPos(adj));
            item.setValue(this.receiptService.jposValueToValue(val));
            item.setTaxId(TaxRate.taxIndexToTaxId(vat));
            item.setItemDescription(this.postLine);
            this.receiptService.voidAdjustItem(item);
        }
        catch (FiscalDeviceException ex) {
            this.receiptService.translateError(ex);
        }
    }

    public boolean getCapCompareFirmwareVersion() throws JposException {
        this.checkIfOpen();
        return false;
    }

    public boolean getCapUpdateFirmware() throws JposException {
        this.checkIfOpen();
        return false;
    }

    public void compareFirmwareVersion(String string, int[] ints) throws JposException {
        this.notSupportedError();
    }

    public void updateFirmware(String string) throws JposException {
        this.notSupportedError();
    }

    public boolean getCapStatisticsReporting() throws JposException {
        return false;
    }

    public boolean getCapUpdateStatistics() throws JposException {
        return false;
    }

    public void resetStatistics(String string) throws JposException {
        this.notSupportedError();
    }

    public void retrieveStatistics(String[] strings) throws JposException {
        this.notSupportedError();
    }

    public void updateStatistics(String string) throws JposException {
        this.notSupportedError();
    }

    public int getAmountDecimalPlaces() throws JposException {
        this.checkIfEnabled();
        return 2;
    }

    public boolean getCapAdditionalHeader() throws JposException {
        this.checkIfOpen();
        return true;
    }

    public boolean getCapAdditionalTrailer() throws JposException {
        this.checkIfOpen();
        return false;
    }

    public boolean getCapChangeDue() throws JposException {
        this.checkIfOpen();
        return false;
    }

    public boolean getCapEmptyReceiptIsVoidable() throws JposException {
        this.checkIfOpen();
        return true;
    }

    public boolean getCapFiscalReceiptStation() throws JposException {
        this.checkIfOpen();
        return false;
    }

    public boolean getCapFiscalReceiptType() throws JposException {
        this.checkIfOpen();
        return true;
    }

    public boolean getCapMultiContractor() throws JposException {
        this.checkIfOpen();
        return false;
    }

    public boolean getCapOnlyVoidLastItem() throws JposException {
        this.checkIfOpen();
        return true;
    }

    public boolean getCapPackageAdjustment() throws JposException {
        this.checkIfOpen();
        return false;
    }

    public boolean getCapPostPreLine() throws JposException {
        this.checkIfOpen();
        return true;
    }

    public boolean getCapSetCurrency() throws JposException {
        this.checkIfOpen();
        return false;
    }

    public boolean getCapTotalizerType() throws JposException {
        this.checkIfOpen();
        return true;
    }

    public int getActualCurrency() throws JposException {
        this.checkIfOpen();
        return 7;
    }

    public String getAdditionalHeader() throws JposException {
        return "";
    }

    public void setAdditionalHeader(String string) throws JposException {
        this.additionalHeader = string;
    }

    public String getAdditionalTrailer() throws JposException {
        return this.additionalHeader;
    }

    public void setAdditionalTrailer(String string) throws JposException {
        this.notSupportedError();
    }

    public String getChangeDue() throws JposException {
        this.checkIfOpen();
        return "";
    }

    public void setChangeDue(String string) throws JposException {
        this.notSupportedError();
    }

    public int getContractorId() throws JposException {
        this.checkIfOpen();
        return 0;
    }

    public void setContractorId(int i) throws JposException {
        this.notSupportedError();
    }

    public int getDateType() throws JposException {
        this.checkIfOpen();
        return this.dateType;
    }

    public void setDateType(int i) throws JposException {
        this.checkIfOpen();
        int[] allowed = new int[]{4};
        if (!ArrayUtils.contains((int[])allowed, (int)i)) {
            throw new JposException(106, I18n.tr("strDateTypeNotSupported"));
        }
        this.dateType = i;
    }

    public int getFiscalReceiptStation() throws JposException {
        this.checkIfEnabled();
        return this.fiscalReceiptStation;
    }

    public void setFiscalReceiptStation(int i) throws JposException {
        if (this.getCapFiscalReceiptStation()) {
            throw new JposException(106, I18n.tr("strSwitchingStationsNotSupported"));
        }
        this.fiscalReceiptStation = i;
    }

    public int getFiscalReceiptType() throws JposException {
        return this.fiscalReceiptType;
    }

    public void setFiscalReceiptType(int i) throws JposException {
        Integer[] allowed;
        HashSet<Integer> a;
        if (!this.getCapFiscalReceiptType()) {
            this.notSupportedError();
        }
        this.checkIfClaimed();
        this.assertPrinterState(1);
        if (i == 3) {
            i = 4;
        }
        if (!(a = new HashSet<Integer>(Arrays.asList(allowed = new Integer[]{1, 2, 4, 6}))).contains(i)) {
            this.notSupportedError();
        }
        this.fiscalReceiptType = i;
    }

    public int getMessageType() throws JposException {
        this.checkIfOpen();
        return this.messageType;
    }

    public void setMessageType(int i) throws JposException {
        this.messageType = i;
    }

    public String getPostLine() throws JposException {
        this.checkIfOpen();
        return this.postLine;
    }

    public void setPostLine(String string) throws JposException {
        this.checkIfOpen();
        this.postLine = string;
    }

    public String getPreLine() throws JposException {
        this.checkIfOpen();
        return "";
    }

    public void setPreLine(String string) throws JposException {
        this.notSupportedError();
    }

    public int getTotalizerType() throws JposException {
        this.checkIfOpen();
        return this.totalizerType;
    }

    public void setTotalizerType(int i) throws JposException {
        this.checkIfOpen();
        int[] allowed = new int[]{2, 3};
        if (!ArrayUtils.contains((int[])allowed, (int)i)) {
            throw new JposException(106, I18n.tr("strTotalizerNotSupported"));
        }
        this.totalizerType = i;
    }

    public void setCurrency(int i) throws JposException {
        this.notSupportedError();
    }

    public void printRecCash(long l) throws JposException {
        this.checkIfClaimed();
        if (this.getPrinterState() != 2) {
            throw new JposException(106, I18n.tr("strRecCashWrongMode"));
        }
        BigDecimal amount = this.receiptService.jposValueToValue(l);
        try {
            switch (this.getFiscalReceiptType()) {
                case 1: {
                    this.cashService.cashIn(amount, this.posAndClerkId);
                    break;
                }
                case 2: {
                    this.cashService.cashOut(amount, this.posAndClerkId);
                    break;
                }
                default: {
                    this.notSupportedError();
                    break;
                }
            }
        }
        catch (FiscalDeviceException e) {
            this.cashService.translateError(e);
        }
    }

    public void printRecItemFuel(String string, long l, int i, int i1, long l1, String string1, long l2, String string2) throws JposException {
        this.notSupportedError();
    }

    public void printRecItemFuelVoid(String string, long l, int i, long l1) throws JposException {
        this.notSupportedError();
    }

    public void printRecPackageAdjustment(int i, String msg, String data) throws JposException {
        this.checkIfClaimed();
        if (this.getPrinterState() != 2) {
            throw new JposException(106, I18n.tr("strRecCashWrongMode"));
        }
        try {
            this.receiptService.adjustTaxGroup(i, data, msg);
        }
        catch (FiscalDeviceException ex) {
            this.receiptService.translateError(ex);
        }
    }

    public void printRecPackageAdjustVoid(int i, String string) throws JposException {
        this.notSupportedError();
    }

    public void printRecRefundVoid(String string, long l, int i) throws JposException {
        this.notSupportedError();
    }

    public void printRecSubtotalAdjustVoid(int i, long l) throws JposException {
        this.notSupportedError();
    }

    public void printRecTaxID(String string) throws JposException {
        this.notSupportedError();
    }

    public boolean getCapAdditionalLines() throws JposException {
        this.checkIfOpen();
        return false;
    }

    public boolean getCapAmountAdjustment() throws JposException {
        this.checkIfOpen();
        return true;
    }

    public boolean getCapAmountNotPaid() throws JposException {
        this.checkIfOpen();
        return false;
    }

    public boolean getCapCheckTotal() throws JposException {
        this.checkIfOpen();
        return false;
    }

    public boolean getCapCoverSensor() throws JposException {
        this.checkIfOpen();
        return true;
    }

    public boolean getCapDoubleWidth() throws JposException {
        this.checkIfOpen();
        return false;
    }

    public boolean getCapDuplicateReceipt() throws JposException {
        this.checkIfOpen();
        return false;
    }

    public boolean getCapFixedOutput() throws JposException {
        this.checkIfOpen();
        return true;
    }

    public boolean getCapHasVatTable() throws JposException {
        this.checkIfOpen();
        return true;
    }

    public boolean getCapIndependentHeader() throws JposException {
        this.checkIfOpen();
        return false;
    }

    public boolean getCapItemList() throws JposException {
        this.checkIfOpen();
        return false;
    }

    public boolean getCapJrnEmptySensor() throws JposException {
        this.checkIfOpen();
        return false;
    }

    public boolean getCapJrnNearEndSensor() throws JposException {
        this.checkIfOpen();
        return false;
    }

    public boolean getCapJrnPresent() throws JposException {
        this.checkIfOpen();
        return false;
    }

    public boolean getCapNonFiscalMode() throws JposException {
        this.checkIfOpen();
        return true;
    }

    public boolean getCapOrderAdjustmentFirst() throws JposException {
        this.checkIfOpen();
        return false;
    }

    public boolean getCapPercentAdjustment() throws JposException {
        this.checkIfOpen();
        return true;
    }

    public boolean getCapPositiveAdjustment() throws JposException {
        this.checkIfOpen();
        return true;
    }

    public boolean getCapPowerLossReport() throws JposException {
        this.checkIfOpen();
        return false;
    }

    public int getCapPowerReporting() throws JposException {
        this.checkIfOpen();
        return 1;
    }

    public boolean getCapPredefinedPaymentLines() throws JposException {
        this.checkIfOpen();
        return false;
    }

    public boolean getCapReceiptNotPaid() throws JposException {
        this.checkIfOpen();
        return false;
    }

    public boolean getCapRecEmptySensor() throws JposException {
        this.checkIfOpen();
        return true;
    }

    public boolean getCapRecNearEndSensor() throws JposException {
        this.checkIfOpen();
        return false;
    }

    public boolean getCapRecPresent() throws JposException {
        this.checkIfOpen();
        return true;
    }

    public boolean getCapRemainingFiscalMemory() throws JposException {
        this.checkIfOpen();
        return false;
    }

    public boolean getCapReservedWord() throws JposException {
        this.checkIfOpen();
        return false;
    }

    public boolean getCapSetHeader() throws JposException {
        this.checkIfOpen();
        return true;
    }

    public boolean getCapSetPOSID() throws JposException {
        this.checkIfOpen();
        return true;
    }

    public boolean getCapSetStoreFiscalID() throws JposException {
        this.checkIfOpen();
        return false;
    }

    public boolean getCapSetTrailer() throws JposException {
        this.checkIfOpen();
        return true;
    }

    public boolean getCapSetVatTable() throws JposException {
        this.checkIfOpen();
        return true;
    }

    public boolean getCapSlpEmptySensor() throws JposException {
        this.checkIfOpen();
        return false;
    }

    public boolean getCapSlpFiscalDocument() throws JposException {
        this.checkIfOpen();
        return false;
    }

    public boolean getCapSlpFullSlip() throws JposException {
        this.checkIfOpen();
        return false;
    }

    public boolean getCapSlpNearEndSensor() throws JposException {
        this.checkIfOpen();
        return false;
    }

    public boolean getCapSlpPresent() throws JposException {
        this.checkIfOpen();
        return false;
    }

    public boolean getCapSlpValidation() throws JposException {
        this.checkIfOpen();
        return false;
    }

    public boolean getCapSubAmountAdjustment() throws JposException {
        this.checkIfOpen();
        return true;
    }

    public boolean getCapSubPercentAdjustment() throws JposException {
        this.checkIfOpen();
        return true;
    }

    public boolean getCapSubtotal() throws JposException {
        this.checkIfOpen();
        return true;
    }

    public boolean getCapTrainingMode() throws JposException {
        this.checkIfOpen();
        return false;
    }

    public boolean getCapValidateJournal() throws JposException {
        this.checkIfOpen();
        return false;
    }

    public boolean getCapXReport() throws JposException {
        this.checkIfOpen();
        return true;
    }

    public int getAmountDecimalPlace() throws JposException {
        return this.getAmountDecimalPlaces();
    }

    public boolean getAsyncMode() throws JposException {
        this.checkIfOpen();
        return this.asyncMode;
    }

    public void setAsyncMode(boolean bln) throws JposException {
        this.notSupportedError();
    }

    public boolean getCheckTotal() throws JposException {
        this.checkIfOpen();
        return false;
    }

    public void setCheckTotal(boolean bln) throws JposException {
        this.notSupportedError();
    }

    public int getCountryCode() throws JposException {
        this.checkIfOpen();
        return this.countryCode;
    }

    public boolean getCoverOpen() throws JposException {
        boolean r = false;
        if (!this.getCapCoverSensor()) {
            this.notSupportedError();
        }
        this.checkIfClaimed();
        try {
            LegacyFiscalPrinterProtocol.Status s = this.getFPProtocol().getStatus();
            r = s.isHwError();
        }
        catch (FiscalDeviceException ex) {
            this.receiptService.translateError(ex);
        }
        return r;
    }

    public boolean getDayOpened() throws JposException {
        log.debug("enter");
        this.checkIfClaimed();
        BigDecimal rv = new BigDecimal("0.00");
        try {
            POSReport report = this.posReportService.getReport(23);
            Iterator<BigDecimal> i = report.getTotalizers().values().iterator();
            while (i.hasNext()) {
                rv = rv.add(i.next());
            }
        }
        catch (FiscalDeviceException ex) {
            this.posReportService.translateError(ex);
        }
        return rv.compareTo(BigDecimal.ZERO) != 0;
    }

    public int getDescriptionLength() throws JposException {
        this.checkIfOpen();
        return 40;
    }

    public boolean getDuplicateReceipt() throws JposException {
        this.checkIfOpen();
        return false;
    }

    public void setDuplicateReceipt(boolean bln) throws JposException {
        this.notSupportedError();
    }

    public int getErrorLevel() throws JposException {
        this.checkIfOpen();
        return 0;
    }

    public int getErrorOutID() throws JposException {
        this.checkIfOpen();
        return 0;
    }

    public int getErrorState() throws JposException {
        this.checkIfOpen();
        return 0;
    }

    public int getErrorStation() throws JposException {
        this.checkIfOpen();
        return 2;
    }

    public String getErrorString() throws JposException {
        return FiscalDeviceException.getLastErrorString();
    }

    public boolean getFlagWhenIdle() throws JposException {
        this.checkIfOpen();
        return false;
    }

    public void setFlagWhenIdle(boolean bln) throws JposException {
        this.notSupportedError();
    }

    public boolean getJrnEmpty() throws JposException {
        this.checkIfOpen();
        return false;
    }

    public boolean getJrnNearEnd() throws JposException {
        this.checkIfOpen();
        return false;
    }

    public int getMessageLength() throws JposException {
        return 25;
    }

    public int getNumHeaderLines() throws JposException {
        this.checkIfOpen();
        return 5;
    }

    public int getNumTrailerLines() throws JposException {
        this.checkIfOpen();
        return 3;
    }

    public int getNumVatRates() throws JposException {
        this.checkIfOpen();
        return 7;
    }

    public int getOutputID() throws JposException {
        this.checkIfOpen();
        return this.outputId;
    }

    public int getPowerNotify() throws JposException {
        this.checkIfOpen();
        return this.powerNotify;
    }

    public void setPowerNotify(int i) throws JposException {
        this.checkIfOpen();
        int[] allowed = new int[]{1, 0};
        if (!ArrayUtils.contains((int[])allowed, (int)i)) {
            throw new JposException(106, I18n.tr("strPowerNotifyTypeNotSupported"));
        }
        this.powerNotify = i;
    }

    public int getPowerState() throws JposException {
        this.checkIfOpen();
        try {
            if (this.powerNotify != 0) {
                if (this.getClaimed()) {
                    LegacyFiscalPrinterProtocol.Status status = this.getFPProtocol().getStatus();
                    return status.isOnline() ? 2001 : 2003;
                }
                return 2000;
            }
        }
        catch (FiscalDeviceException e) {
            log.error("Error reading device power state: " + e.getMessage());
        }
        return 2000;
    }

    public String getPredefinedPaymentLines() throws JposException {
        this.checkIfOpen();
        return "";
    }

    public int getPrinterState() throws JposException {
        this.checkIfOpen();
        return this.printerState;
    }

    public int getQuantityDecimalPlaces() throws JposException {
        this.checkIfOpen();
        return 3;
    }

    public int getQuantityLength() throws JposException {
        this.checkIfOpen();
        return 10;
    }

    public boolean getRecEmpty() throws JposException {
        this.checkIfClaimed();
        try {
            LegacyFiscalPrinterProtocol.Status s = this.getFPProtocol().getStatus();
            return s.isNoPaper();
        }
        catch (FiscalDeviceException ex) {
            this.receiptService.translateError(ex);
            return false;
        }
    }

    public boolean getRecNearEnd() throws JposException {
        this.checkIfOpen();
        return false;
    }

    public int getRemainingFiscalMemory() throws JposException {
        this.checkIfOpen();
        return 0;
    }

    public String getReservedWord() throws JposException {
        this.checkIfOpen();
        return "";
    }

    public boolean getSlpEmpty() throws JposException {
        this.checkIfOpen();
        return false;
    }

    public boolean getSlpNearEnd() throws JposException {
        this.checkIfOpen();
        return false;
    }

    public int getSlipSelection() throws JposException {
        this.checkIfOpen();
        return 0;
    }

    public void setSlipSelection(int i) throws JposException {
        this.notSupportedError();
    }

    public boolean getTrainingModeActive() throws JposException {
        this.checkIfOpen();
        return false;
    }

    public void beginFiscalDocument(int i) throws JposException {
        this.notSupportedError();
    }

    public void beginFiscalReceipt(boolean bln) throws JposException {
        this.checkIfClaimed();
        this.assertPrinterState(1);
        try {
            switch (this.getFiscalReceiptType()) {
                case 4: {
                    this.receiptService.beginReceipt();
                    break;
                }
                case 6: {
                    this.receiptService.beginInvoice(this.additionalHeader);
                    break;
                }
            }
            this.setPrinterState(2);
        }
        catch (FiscalDeviceException ex) {
            this.receiptService.translateError(ex);
        }
    }

    public void beginFixedOutput(int i, int i1) throws JposException {
        this.checkIfClaimed();
        if (i != 2) {
            throw new JposException(106, I18n.tr("strNoSlipPrinter"));
        }
        this.assertPrinterState(1);
        try {
            this.nfprintoutService.begin(i1);
            this.setPrinterState(6);
        }
        catch (FiscalDeviceException ex) {
            this.nfprintoutService.translateError(ex);
        }
    }

    public void beginInsertion(int i) throws JposException {
        this.notSupportedError();
    }

    public void beginItemList(int i) throws JposException {
        this.notSupportedError();
    }

    public void beginNonFiscal() throws JposException {
        this.checkIfClaimed();
        this.nonFiscalLineCounter = 0;
        this.assertPrinterState(1);
        try {
            this.nfprintoutService.begin(200);
            this.setPrinterState(6);
        }
        catch (FiscalDeviceException ex) {
            this.nfprintoutService.translateError(ex);
        }
    }

    public void beginRemoval(int i) throws JposException {
        this.notSupportedError();
    }

    public void beginTraining() throws JposException {
        this.notSupportedError();
    }

    public void clearError() throws JposException {
        this.notSupportedError();
    }

    public void clearOutput() throws JposException {
        this.notSupportedError();
    }

    public void endFiscalDocument() throws JposException {
        this.notSupportedError();
    }

    public void endFiscalReceipt(boolean bln) throws JposException {
        this.checkIfClaimed();
        this.assertPrinterState(2);
        try {
            switch (this.getFiscalReceiptType()) {
                case 4: {
                    this.receiptService.endReceipt();
                    break;
                }
                case 6: {
                    this.receiptService.endInvoice();
                    break;
                }
            }
            this.setPrinterState(1);
        }
        catch (FiscalDeviceException ex) {
            this.receiptService.translateError(ex);
        }
    }

    public void endFixedOutput() throws JposException {
        this.checkIfClaimed();
        this.assertPrinterState(6);
        try {
            this.nfprintoutService.end();
            this.setPrinterState(1);
        }
        catch (FiscalDeviceException ex) {
            this.nfprintoutService.translateError(ex);
        }
    }

    public void endInsertion() throws JposException {
        this.notSupportedError();
    }

    public void endItemList() throws JposException {
        this.notSupportedError();
    }

    public void endNonFiscal() throws JposException {
        this.checkIfClaimed();
        this.assertPrinterState(6);
        try {
            this.nfprintoutService.end();
            this.setPrinterState(1);
        }
        catch (FiscalDeviceException ex) {
            this.nfprintoutService.translateError(ex);
        }
    }

    public void endRemoval() throws JposException {
        this.notSupportedError();
    }

    public void endTraining() throws JposException {
        this.notSupportedError();
    }

    public void getData(int item, int[] opts, String[] data) throws JposException {
        this.checkIfClaimed();
        try {
            block1 : switch (item) {
                case 10: {
                    data[0] = this.posReportService.getFirmwareVersion();
                    break;
                }
                case 9: {
                    POSReport r = this.posReportService.getReport(23);
                    data[0] = r.getUniqueNumber();
                    break;
                }
                case 3: {
                    POSReport r = this.posReportService.getReport(23);
                    data[0] = String.format("%d", r.getReceiptCount());
                    break;
                }
                case 18: {
                    data[0] = this.posReportService.getLastInvoiceNumber();
                    break;
                }
                case 1: 
                case 2: {
                    POSReport r = this.posReportService.getReport(item == 2 ? 23 : 22);
                    BigDecimal sum = BigDecimal.ZERO;
                    for (String key : r.getTotalizers().keySet()) {
                        sum = sum.add(r.getTotalizers().get(key));
                    }
                    data[0] = sum.setScale(2, RoundingMode.HALF_UP).toPlainString();
                    break;
                }
                case 26: {
                    switch (opts[0]) {
                        case 1: {
                            data[0] = I18n.tr("strFPTR_PDL_CASH");
                            break block1;
                        }
                        case 2: {
                            data[0] = I18n.tr("strFPTR_PDL_CHEQUE");
                            break block1;
                        }
                        case 22: {
                            data[0] = I18n.tr("strFPTR_PDL_VOUCHER");
                            break block1;
                        }
                        case 16: 
                        case 17: {
                            data[0] = I18n.tr("strFPTR_PDL_PAY_CARD");
                            break block1;
                        }
                    }
                    this.notSupportedError();
                    break;
                }
                case 28: {
                    switch (opts[0]) {
                        case 1: 
                        case 2: 
                        case 10: {
                            data[0] = "40";
                            break block1;
                        }
                    }
                    this.notSupportedError();
                    break;
                }
                case 7: {
                    data[0] = this.posReportService.getLastDailyReportNumber();
                    break;
                }
                default: {
                    this.notSupportedError();
                    break;
                }
            }
        }
        catch (FiscalDeviceException ex) {
            this.posReportService.translateError(ex);
        }
    }

    public void getTotalizer(int vatId, int arg, String[] data) throws JposException {
        this.checkIfClaimed();
        int[] JPOS_TT_TYPES = new int[]{2, 1, 3};
        int[] REPTYPE = new int[]{23, 22, 22};
        try {
            POSReport r = this.posReportService.getReport(Utils.lookupTranslate(arg, JPOS_TT_TYPES, REPTYPE));
            char taxId = TaxRate.taxIndexToTaxId(vatId);
            switch (arg) {
                case 1: {
                    BigDecimal tt = r.getTotalizers().containsKey(String.valueOf(taxId)) ? r.getTotalizers().get(String.valueOf(taxId)) : BigDecimal.ZERO;
                    data[0] = tt.setScale(2, RoundingMode.HALF_UP).toPlainString();
                    break;
                }
                default: {
                    this.notSupportedError();
                    break;
                }
            }
        }
        catch (FiscalDeviceException e) {
            this.posReportService.translateError(e);
        }
    }

    public void getVatEntry(int idx, int i1, int[] ints) throws JposException {
        this.checkIfClaimed();
        try {
            POSReport report = this.posReportService.getReport(23);
            String tr = null;
            tr = idx < 65 ? String.valueOf(TaxRate.taxIndexToTaxId(idx)) : String.valueOf((char)idx);
            if (!report.getTaxRates().containsKey(tr)) {
                throw new JposException(106, I18n.tr("strTaxRateIndexInvalid"));
            }
            TaxRate r = report.getTaxRates().get(tr);
            BigDecimal rv = r.getRate();
            rv = rv.scaleByPowerOfTen(2);
            ints[0] = rv.intValue();
        }
        catch (FiscalDeviceException ex) {
            this.posReportService.translateError(ex);
        }
    }

    public void printDuplicateReceipt() throws JposException {
        this.notSupportedError();
    }

    public void printFiscalDocumentLine(String string) throws JposException {
        this.notSupportedError();
    }

    public void printFixedOutput(int i, int i1, String string) throws JposException {
        this.checkIfClaimed();
        this.assertPrinterState(6);
        try {
            this.nfprintoutService.printLine(i, i1, string);
        }
        catch (FiscalDeviceException ex) {
            this.nfprintoutService.translateError(ex);
        }
    }

    public void printNormal(int i, String string) throws JposException {
        this.checkIfClaimed();
        this.assertPrinterState(6);
        try {
            this.nfprintoutService.printLine(200, this.nonFiscalLineCounter, string);
            if (this.nonFiscalLineCounter == 200) {
                throw new JposException(106, I18n.tr("strTooManyLines"));
            }
            ++this.nonFiscalLineCounter;
        }
        catch (FiscalDeviceException ex) {
            this.nfprintoutService.translateError(ex);
        }
    }

    public void printPeriodicTotalsReport(String string, String string1) throws JposException {
        this.notSupportedError();
    }

    public void printPowerLossReport() throws JposException {
        this.notSupportedError();
    }

    public void printRecItem(String name, long val, int q, int vat, long price, String unit) throws JposException {
        this.checkIfClaimed();
        this.assertPrinterState(2);
        try {
            ReceiptItem item = new ReceiptItem();
            item.setItemName(name);
            item.setUnit(unit);
            item.setValue(this.receiptService.jposValueToValue(val));
            q = q != 0 ? q : 1;
            item.setQuantity(this.receiptService.jposQuantityToQuantity(q));
            item.setPrice(this.receiptService.jposValueToValue(price));
            item.setTaxId(TaxRate.taxIndexToTaxId(vat));
            item.setItemDescription(this.postLine);
            if (item.getItemName().startsWith("#")) {
                this.receiptService.packageSale(item);
            } else {
                this.receiptService.additem(item);
            }
        }
        catch (FiscalDeviceException ex) {
            this.receiptService.translateError(ex);
        }
    }

    public void printRecItemAdjustment(int i, String d, long l, int i1) throws JposException {
        this.checkIfClaimed();
        this.assertPrinterState(2);
        try {
            ReceiptItem item = new ReceiptItem();
            item.setDiscountType(new LegacyReceiptService.Converters.AdjustmentType().fromJavaPos(i));
            item.setDiscount(this.receiptService.jposValueToValue(l));
            item.setTaxId(TaxRate.taxIndexToTaxId(i1));
            item.setItemDescription(this.postLine);
            this.receiptService.adjustItem(item);
        }
        catch (FiscalDeviceException ex) {
            this.receiptService.translateError(ex);
        }
    }

    public void printRecMessage(String string) throws JposException {
        this.checkIfClaimed();
        this.assertPrinterState(2);
        try {
            this.receiptService.addFooterMessage(this.messageType, string);
        }
        catch (FiscalDeviceException ex) {
            this.receiptService.translateError(ex);
        }
    }

    public void printRecNotPaid(String string, long l) throws JposException {
        this.notSupportedError();
    }

    public void printRecRefund(String string, long l, int i) throws JposException {
        this.notSupportedError();
    }

    public void printRecSubtotal(long st) throws JposException {
        this.checkIfClaimed();
        this.assertPrinterState(2);
        try {
            this.receiptService.subtotal(this.receiptService.jposValueToValue(st));
        }
        catch (FiscalDeviceException ex) {
            this.receiptService.translateError(ex);
        }
    }

    public void printRecSubtotalAdjustment(int i, String string, long l) throws JposException {
        this.notSupportedError();
    }

    public void printRecTotal(long total, long paid, String descr) throws JposException {
        this.checkIfClaimed();
        this.assertPrinterState(2);
        int[] JPOS_PAYMENT_TYPE_ID = new int[]{0, 1, 2, 3, -1};
        int[] PAYMENT_TYPES = new int[]{0, 1, 2, 3, 7};
        try {
            String[] ptype;
            int iPtype;
            if (descr == null || descr.isEmpty()) {
                descr = "0";
            }
            if ((iPtype = Integer.parseInt((ptype = descr.split(";"))[0])) == 7) {
                this.receiptService.totalEur(this.receiptService.jposValueToValue(total), this.receiptService.jposValueToValue(paid), iPtype, ptype);
            } else {
                int paymentType = Utils.lookupTranslate(iPtype, JPOS_PAYMENT_TYPE_ID, PAYMENT_TYPES);
                String paymentDescr = ptype.length > 1 ? ptype[1] : null;
                this.receiptService.subtotal(this.receiptService.jposValueToValue(total));
                this.receiptService.total(this.receiptService.jposValueToValue(total), this.receiptService.jposValueToValue(paid), paymentType, paymentDescr);
            }
        }
        catch (FiscalDeviceException ex) {
            this.receiptService.translateError(ex);
        }
        catch (NumberFormatException ex) {
            throw new JposException(114, 215, I18n.tr("strRecTotalBadDescrIdx"));
        }
    }

    public void printRecVoid(String string) throws JposException {
        this.checkIfClaimed();
        this.assertPrinterState(2);
        try {
            this.receiptService.cancelReceipt(this.posAndClerkId);
        }
        catch (FiscalDeviceException ex) {
            this.receiptService.translateError(ex);
        }
    }

    public void printRecVoidItem(String string, long l, int i, int i1, long l1, int i2) throws JposException {
        throw new JposException(115, I18n.tr("strPrintRecVoidItemDeprecated"));
    }

    public void printReport(int i, String start, String end) throws JposException {
        try {
            this.checkIfClaimed();
            this.assertPrinterState(1);
            switch (i) {
                case 1: 
                case 3: {
                    int b = Integer.parseInt(start);
                    int e = Integer.parseInt(end);
                    this.reportService.periodicReport(16, this.posAndClerkId, b, e);
                    break;
                }
                case 2: {
                    SimpleDateFormat sdf = new SimpleDateFormat("ddMMyyyyHHmm", Locale.ROOT);
                    Calendar bd = Calendar.getInstance();
                    Calendar ed = Calendar.getInstance();
                    bd.setTime(sdf.parse(start));
                    ed.setTime(sdf.parse(end));
                    this.reportService.periodicReport(0, this.posAndClerkId, bd, ed);
                    break;
                }
                default: {
                    throw new JposException(106, I18n.tr("strReportNotSupported"));
                }
            }
        }
        catch (ParseException ex) {
            log.error("Invalid date");
            throw new JposException(106, I18n.tr("strDateFormatInvalid"));
        }
        catch (FiscalDeviceException ex) {
            this.receiptService.translateError(ex);
        }
    }

    public void printXReport() throws JposException {
        this.checkIfClaimed();
        this.assertPrinterState(1);
        try {
            this.reportService.reportX(this.posAndClerkId);
        }
        catch (FiscalDeviceException ex) {
            this.reportService.translateError(ex);
        }
    }

    public void printZReport() throws JposException {
        this.checkIfClaimed();
        this.assertPrinterState(1);
        try {
            Calendar ddate = this.dateTimeService.getDateTime();
            this.reportService.reportZ(this.posAndClerkId, ddate);
        }
        catch (FiscalDeviceException ex) {
            this.reportService.translateError(ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void resetPrinter() throws JposException {
        try {
            if (!this.getClaimed()) return;
            switch (this.printerState) {
                case 2: 
                case 3: 
                case 4: {
                    this.printRecVoid("");
                    return;
                }
                case 6: {
                    this.endFixedOutput();
                    return;
                }
            }
            return;
        }
        catch (Exception e) {
            log.error("Exception while resetting printer: " + e.getMessage());
            return;
        }
        finally {
            if (this.isOpen()) {
                this.setPrinterState(1);
            }
        }
    }

    public void setDate(String string) throws JposException {
        this.checkIfClaimed();
        this.assertPrinterState(1);
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat("ddMMyyyyHHmm", Locale.ROOT);
        try {
            cal.setTime(sdf.parse(string));
            this.dateTimeService.setDateTime(cal, this.posAndClerkId);
        }
        catch (ParseException ex) {
            log.error("Invalid date: " + string);
            throw new JposException(106, I18n.tr("strDateFormatInvalid"));
        }
        catch (FiscalDeviceException ex) {
            log.error("Error while setting date: " + ex.toString());
            this.dateTimeService.translateError(ex);
        }
    }

    public void getDate(String[] strings) throws JposException {
        this.checkIfClaimed();
        this.assertPrinterState(1);
        try {
            String s;
            Calendar d = this.dateTimeService.getDateTime();
            SimpleDateFormat sdf = new SimpleDateFormat("ddMMyyyyHHmm", Locale.ROOT);
            strings[0] = s = sdf.format(d.getTime());
        }
        catch (FiscalDeviceException ex) {
            log.error("Wrror reading date time: " + ex.toString());
            this.dateTimeService.translateError(ex);
        }
    }

    public void setHeaderLine(int i, String string, boolean bln) throws JposException {
        this.notSupportedError();
    }

    public void setPOSID(String pos, String clk) throws JposException {
        this.checkIfClaimed();
        this.setPrinterState(1);
        this.posAndClerkId.setEcrId(pos);
        this.posAndClerkId.setClerkId(clk);
    }

    public void setStoreFiscalID(String string) throws JposException {
        this.notSupportedError();
    }

    public void setTrailerLine(int i, String string, boolean bln) throws JposException {
        this.notSupportedError();
    }

    public void setVatTable() throws JposException {
        this.checkIfClaimed();
        this.setPrinterState(1);
        try {
            this.taxRatesService.setVatTable(this.posAndClerkId);
        }
        catch (FiscalDeviceException ex) {
            this.taxRatesService.translateError(ex);
        }
    }

    public void setVatValue(int i, String string) throws JposException {
        this.checkIfClaimed();
        this.setPrinterState(1);
        try {
            this.taxRatesService.setVatValue(i, new TaxRate(new BigDecimal(string)));
        }
        catch (FiscalDeviceException ex) {
            this.taxRatesService.translateError(ex);
        }
    }

    public void verifyItem(String name, int vat) throws JposException {
        this.checkIfClaimed();
        this.assertPrinterState(1);
        try {
            ReceiptItem item = new ReceiptItem();
            item.setItemName(name);
            item.setTaxId(TaxRate.taxIndexToTaxId(vat));
            this.receiptService.verifyItem(item, this.posAndClerkId);
        }
        catch (FiscalDeviceException ex) {
            this.receiptService.translateError(ex);
        }
    }

    public void addDirectIOListener(DirectIOListener dl) {
    }

    public void removeDirectIOListener(DirectIOListener dl) {
    }

    public void addErrorListener(ErrorListener el) {
    }

    public void removeErrorListener(ErrorListener el) {
    }

    public void addOutputCompleteListener(OutputCompleteListener ol) {
    }

    public void removeOutputCompleteListener(OutputCompleteListener ol) {
    }

    public void addStatusUpdateListener(StatusUpdateListener sl) {
    }

    public void removeStatusUpdateListener(StatusUpdateListener sl) {
    }

    public String getCheckHealthText() throws JposException {
        this.checkIfOpen();
        return this.healthCheckText;
    }

    public boolean getFreezeEvents() throws JposException {
        this.checkIfOpen();
        return this.freezeEvents;
    }

    public void setFreezeEvents(boolean bln) throws JposException {
        this.notSupportedError();
    }

    public String getPhysicalDeviceDescription() throws JposException {
        this.checkIfOpen();
        return "Novitus HDe Fiscal Printer";
    }

    public String getPhysicalDeviceName() throws JposException {
        this.checkIfOpen();
        return "Novitus HDe";
    }

    public void checkHealth(int i) throws JposException {
        this.notSupportedError();
    }

    public void directIO(int code, int[] ints, Object o) throws JposException {
        this.checkIfClaimed();
        if (!(o instanceof ArrayList)) {
            throw new JposException(106, I18n.tr("strArrayListExpectedError"));
        }
        ArrayList aout = (ArrayList)o;
        aout.clear();
        try {
            switch (code) {
                case 20: {
                    String pkt = this.protocol.receivePacket();
                    byte[] bPkt = pkt.getBytes();
                    aout.ensureCapacity(bPkt.length);
                    for (int i = 0; i < bPkt.length; ++i) {
                        aout.add(bPkt[i]);
                    }
                    break;
                }
                case 21: {
                    String pkt = this.protocol.receivePacket(true);
                    byte[] bPkt = pkt.getBytes();
                    aout.ensureCapacity(bPkt.length);
                    for (int i = 0; i < bPkt.length; ++i) {
                        aout.add(bPkt[i]);
                    }
                    break;
                }
                case 30: {
                    byte[] data = new byte[aout.size()];
                    for (int i = 0; i < data.length; ++i) {
                        data[i] = (Byte)aout.get(i);
                    }
                    String pkt = new String(data);
                    this.protocol.sendPacket(pkt);
                    break;
                }
                case 1: {
                    this.protocol.getConnection().write(5);
                    int s1 = this.getConnection().read();
                    aout.add(new Integer(s1).byteValue());
                    break;
                }
                case 2: {
                    this.protocol.getConnection().write(16);
                    int s1 = this.getConnection().read();
                    aout.add(new Integer(s1).byteValue());
                    break;
                }
                case 3: {
                    this.protocol.getConnection().write(7);
                    break;
                }
                case 4: {
                    this.protocol.getConnection().write(24);
                    break;
                }
                case 10: {
                    this.protocol.getConnection().setTimeout(ints[0] * 1000);
                    break;
                }
                default: {
                    this.notSupportedError();
                }
            }
        }
        catch (ConnectionException ex) {
            throw new JposException(111, String.format(I18n.tr("strIOError"), ex.getMessage()));
        }
        catch (FiscalDeviceException ex) {
            this.receiptService.translateError(ex);
        }
    }

    public void open(String string) throws JposException {
        this.open(string, null);
    }

    @Override
    public void release() throws JposException {
        super.release();
        this.setPrinterState(1);
    }

    public void setPrinterState(int s) {
        this.printerState = s;
    }
}

