/*
 * Decompiled with CFR 0.152.
 */
package pl.novitus.javapos.factory;

import jpos.JposException;
import jpos.config.JposEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pl.novitus.javapos.utils.connection.SocketConnection;
import pl.novitus.javapos.utils.connection.TCPConnection;
import pl.novitus.javapos.utils.connection.UDPConnection;
import pl.novitus.javapos.utils.i18n.I18n;

public final class SocketConnectionFactory {
    private static final Logger log = LogManager.getLogger(SocketConnectionFactory.class);
    protected static final String P_SERVER = "server";
    protected static final String P_PORT = "port";
    protected static final String P_TIMEOUT = "timeout";
    String server;
    int port;

    private String propValueDefault(JposEntry jposentry, String propName, Object defValue) throws JposException {
        String result = defValue.toString();
        if (jposentry.getProp(propName) != null) {
            result = jposentry.getPropertyValue(propName).toString();
            log.debug(String.format("  serial port property '%s' set to '%s'", propName, result));
        } else {
            log.debug(String.format("  missing serial port property '%s' set to default value '%s'", propName, result));
        }
        return result;
    }

    void checkPropertyExists(JposEntry jposentry, String name) throws JposException {
        if (jposentry.getProp(name) == null) {
            String msg = String.format(I18n.tr("strConnPropertyMissing"), name);
            log.error(msg);
            throw new JposException(111, msg);
        }
    }

    void configure(SocketConnection connection, JposEntry jposentry) throws JposException {
        this.checkPropertyExists(jposentry, P_SERVER);
        this.checkPropertyExists(jposentry, P_PORT);
        connection.setTimeout(Integer.parseInt(this.propValueDefault(jposentry, P_TIMEOUT, connection.getTimeout())));
        connection.setServer(jposentry.getProp(P_SERVER).getValueAsString());
        try {
            connection.setPort(Integer.parseInt(jposentry.getProp(P_PORT).getValueAsString()));
        }
        catch (Exception e) {
            throw new JposException(111, I18n.tr("strSocketConnInvalidPort"));
        }
    }

    public SocketConnection createUDPConnection(JposEntry jposentry) throws JposException {
        log.debug("Creating UDP connection");
        UDPConnection connection = new UDPConnection();
        this.configure(connection, jposentry);
        return connection;
    }

    public SocketConnection createTCPConnection(JposEntry jposentry) throws JposException {
        log.debug("Creating TCP connection");
        TCPConnection connection = new TCPConnection();
        this.configure(connection, jposentry);
        return connection;
    }
}

