/*
 * Decompiled with CFR 0.152.
 */
package jpos.util;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import jpos.config.JposConfigException;
import jpos.config.JposEntry;
import jpos.config.JposEntryConst;
import jpos.config.simple.SimpleEntry;

public class JposEntryUtility {
    private static JposEntry prototypeJposEntry;
    private static final List STANDARD_PROP_NAMES_LIST;

    private JposEntryUtility() {
    }

    public static boolean isValidJposEntry(JposEntry jposEntry) {
        boolean valid = false;
        if (jposEntry.hasPropertyWithName("logicalName") && jposEntry.hasPropertyWithName("serviceInstanceFactoryClass") && jposEntry.hasPropertyWithName("serviceClass") && jposEntry.hasPropertyWithName("deviceCategory") && jposEntry.hasPropertyWithName("jposVersion") && jposEntry.hasPropertyWithName("vendorName") && jposEntry.hasPropertyWithName("vendorURL") && jposEntry.hasPropertyWithName("productName") && jposEntry.hasPropertyWithName("productURL") && jposEntry.hasPropertyWithName("productDescription")) {
            valid = true;
        }
        return valid;
    }

    public static boolean isRequiredPropName(String name) {
        boolean valid = false;
        if (name.equals("logicalName") || name.equals("serviceInstanceFactoryClass") || name.equals("serviceClass") || name.equals("deviceCategory") || name.equals("jposVersion") || name.equals("vendorName") || name.equals("vendorURL") || name.equals("productName") || name.equals("productURL") || name.equals("productDescription")) {
            valid = true;
        }
        return valid;
    }

    public static boolean isRS232PropName(String name) {
        boolean valid = false;
        if (name.equals("portName") || name.equals("baudRate") || name.equals("dataBits") || name.equals("parity") || name.equals("stopBits") || name.equals("flowControl")) {
            valid = true;
        }
        return valid;
    }

    public static void removeAllRS232Props(JposEntry jposEntry) {
        jposEntry.removeProperty("portName");
        jposEntry.removeProperty("baudRate");
        jposEntry.removeProperty("dataBits");
        jposEntry.removeProperty("parity");
        jposEntry.removeProperty("stopBits");
        jposEntry.removeProperty("flowControl");
    }

    public static Iterator getStandardPropNames() {
        return STANDARD_PROP_NAMES_LIST.iterator();
    }

    public static Enumeration getNonRequiredPropNames(JposEntry jposEntry) {
        Vector<String> vector = new Vector<String>();
        Enumeration names = jposEntry.getPropertyNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            if (JposEntryUtility.isRequiredPropName(name)) continue;
            vector.add(name);
        }
        return vector.elements();
    }

    public static Enumeration getMissingRequiredPropNames(JposEntry jposEntry) {
        Vector<String> vector = new Vector<String>();
        if (!jposEntry.hasPropertyWithName("logicalName")) {
            vector.add("logicalName");
        }
        if (!jposEntry.hasPropertyWithName("serviceInstanceFactoryClass")) {
            vector.add("serviceInstanceFactoryClass");
        }
        if (!jposEntry.hasPropertyWithName("serviceClass")) {
            vector.add("serviceClass");
        }
        if (!jposEntry.hasPropertyWithName("deviceCategory")) {
            vector.add("deviceCategory");
        }
        if (!jposEntry.hasPropertyWithName("jposVersion")) {
            vector.add("jposVersion");
        }
        if (!jposEntry.hasPropertyWithName("vendorName")) {
            vector.add("vendorName");
        }
        if (!jposEntry.hasPropertyWithName("vendorURL")) {
            vector.add("vendorURL");
        }
        if (!jposEntry.hasPropertyWithName("productName")) {
            vector.add("productName");
        }
        if (!jposEntry.hasPropertyWithName("productURL")) {
            vector.add("productURL");
        }
        if (!jposEntry.hasPropertyWithName("productDescription")) {
            vector.add("productDescription");
        }
        return vector.elements();
    }

    public static Enumeration getMissingRS232PropNames(JposEntry jposEntry) {
        Vector<String> vector = new Vector<String>();
        if (!jposEntry.hasPropertyWithName("portName")) {
            vector.add("portName");
        }
        if (!jposEntry.hasPropertyWithName("baudRate")) {
            vector.add("baudRate");
        }
        if (!jposEntry.hasPropertyWithName("dataBits")) {
            vector.add("dataBits");
        }
        if (!jposEntry.hasPropertyWithName("parity")) {
            vector.add("parity");
        }
        if (!jposEntry.hasPropertyWithName("stopBits")) {
            vector.add("stopBits");
        }
        if (!jposEntry.hasPropertyWithName("flowControl")) {
            vector.add("flowControl");
        }
        return vector.elements();
    }

    public static Enumeration getVendorPropNames(JposEntry jposEntry) {
        Vector vector = new Vector();
        Enumeration propNames = jposEntry.getPropertyNames();
        while (propNames.hasMoreElements()) {
            vector.add(propNames.nextElement());
        }
        Iterator standardPropNames = JposEntryUtility.getStandardPropNames();
        while (standardPropNames.hasNext()) {
            String name = (String)standardPropNames.next();
            vector.remove(name);
        }
        return vector.elements();
    }

    public static void addMissingRequiredProps(JposEntry jposEntry) {
        Enumeration missingPropNames = JposEntryUtility.getMissingRequiredPropNames(jposEntry);
        JposEntry prototype = JposEntryUtility.getEntryPrototype();
        while (missingPropNames.hasMoreElements()) {
            String propName = (String)missingPropNames.nextElement();
            jposEntry.addProperty(propName, prototype.getPropertyValue(propName));
        }
    }

    public static JposEntry getEntryPrototype() {
        if (prototypeJposEntry == null) {
            prototypeJposEntry = new SimpleEntry();
            prototypeJposEntry.addProperty("logicalName", "UnknownDevice");
            prototypeJposEntry.addProperty("serviceInstanceFactoryClass", "UnknownServiceInstanceFactoryClass");
            prototypeJposEntry.addProperty("serviceClass", "UnknownServiceClass");
            prototypeJposEntry.addProperty("deviceCategory", "CashDrawer");
            prototypeJposEntry.addProperty("jposVersion", "1.5");
            prototypeJposEntry.addProperty("vendorName", "Unknown Vendor Name");
            prototypeJposEntry.addProperty("vendorURL", "http://www.UnknownVerdorURL.com");
            prototypeJposEntry.addProperty("productName", "Unknown Product Name");
            prototypeJposEntry.addProperty("productURL", "http://www.UnknownProductURL.com");
            prototypeJposEntry.addProperty("productDescription", "Unknown Product Description");
        }
        return ((SimpleEntry)prototypeJposEntry).copy();
    }

    public static String shortClassName(Class classObject) {
        return classObject.toString().substring(classObject.toString().lastIndexOf(".") + 1);
    }

    public static boolean validatePropValue(Object propValue, Class propType) {
        if (propValue == null || propType == null) {
            return false;
        }
        if (!JposEntryUtility.isValidPropType(propType)) {
            return false;
        }
        return propType.isInstance(propValue);
    }

    public static boolean isValidPropType(Class propType) {
        if (propType == null) {
            return false;
        }
        for (int i = 0; i < JposEntryConst.PROP_TYPES.length; ++i) {
            if (!propType.equals(JposEntryConst.PROP_TYPES[i])) continue;
            return true;
        }
        return false;
    }

    public static Object getDefaultValueForType(Class propType) throws JposConfigException {
        if (!JposEntryUtility.isValidPropType(propType)) {
            throw new JposConfigException("Invalid property type: " + propType);
        }
        Object propValue = "";
        try {
            if (propType.equals(String.class)) {
                propValue = "";
            } else if (propType.equals(Boolean.class)) {
                propValue = new Boolean(false);
            } else if (propType.equals(Character.class)) {
                propValue = new Character('a');
            } else if (propType.equals(Double.class)) {
                propValue = new Double(0.0);
            } else if (propType.equals(Float.class)) {
                propValue = new Float(0.0f);
            } else if (propType.equals(Byte.class)) {
                propValue = new Byte(0);
            } else if (propType.equals(Integer.class)) {
                propValue = new Integer(0);
            } else if (propType.equals(Long.class)) {
                propValue = new Long(0L);
            } else if (propType.equals(Short.class)) {
                propValue = new Short(0);
            }
        }
        catch (Exception e) {
            throw new JposConfigException("Invalid property type");
        }
        return propValue;
    }

    public static Object parsePropValue(String stringValue, Class propType) throws JposConfigException {
        if (!JposEntryUtility.isValidPropType(propType)) {
            throw new JposConfigException("Invalid property type: " + propType);
        }
        Object propValue = "";
        try {
            if (propType.equals(String.class)) {
                propValue = stringValue;
            } else if (propType.equals(Boolean.class)) {
                propValue = Boolean.valueOf(stringValue);
            } else if (propType.equals(Character.class)) {
                propValue = new Character(stringValue.charAt(0));
            } else if (propType.equals(Double.class)) {
                propValue = Double.valueOf(stringValue);
            } else if (propType.equals(Float.class)) {
                propValue = Float.valueOf(stringValue);
            } else if (propType.equals(Byte.class)) {
                propValue = Byte.decode(stringValue);
            } else if (propType.equals(Integer.class)) {
                propValue = Integer.decode(stringValue);
            } else if (propType.equals(Long.class)) {
                propValue = Long.decode(stringValue);
            } else if (propType.equals(Short.class)) {
                propValue = Short.decode(stringValue);
            }
        }
        catch (Exception e) {
            throw new JposConfigException("Could not create property value of type: " + propType + " from string: " + stringValue);
        }
        return propValue;
    }

    public static Class propTypeFromString(String typeString) throws JposConfigException {
        if (typeString == null) {
            throw new JposConfigException("typeString cannot be null");
        }
        String className = typeString.startsWith("java.lang.") ? typeString : "java.lang." + typeString;
        try {
            Class<?> typeClass = Class.forName(className);
            if (!JposEntryUtility.isValidPropType(typeClass)) {
                throw new JposConfigException("Invalid property type: " + typeString);
            }
            return typeClass;
        }
        catch (ClassNotFoundException cnfe) {
            throw new JposConfigException("Invalid typeString", cnfe);
        }
    }

    static {
        int i;
        prototypeJposEntry = null;
        STANDARD_PROP_NAMES_LIST = new ArrayList();
        for (i = 0; i < JposEntryConst.REQUIRED_PROPS.length; ++i) {
            STANDARD_PROP_NAMES_LIST.add(JposEntryConst.REQUIRED_PROPS[i]);
        }
        STANDARD_PROP_NAMES_LIST.add("deviceBus");
        for (i = 0; i < JposEntryConst.RS232_PROPS.length; ++i) {
            STANDARD_PROP_NAMES_LIST.add(JposEntryConst.RS232_PROPS[i]);
        }
    }
}

