/*
 * Decompiled with CFR 0.152.
 */
package jpos.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import jpos.util.tracing.Tracer;
import jpos.util.tracing.TracerFactory;

public class FileUtil {
    private static Tracer tracer = TracerFactory.getInstance().createTracer("FileUtil");

    protected FileUtil() {
    }

    protected static synchronized List getCpDirList() {
        String classpath = System.getProperty("java.class.path");
        LinkedList<String> cpDirList = new LinkedList<String>();
        StringTokenizer st = new StringTokenizer(classpath, File.pathSeparator);
        while (st.hasMoreTokens()) {
            String cpEntry = st.nextToken();
            if (cpEntry.toLowerCase().endsWith("jar") || cpEntry.toLowerCase().endsWith("zip")) {
                cpDirList.add(cpEntry.substring(0, cpEntry.lastIndexOf(File.separator)));
                continue;
            }
            cpDirList.add(cpEntry);
        }
        return cpDirList;
    }

    protected static synchronized List getJarList() {
        String classpath = System.getProperty("java.class.path");
        LinkedList<String> cpJarFilesList = new LinkedList<String>();
        StringTokenizer st = new StringTokenizer(classpath, File.pathSeparator);
        while (st.hasMoreTokens()) {
            String cpEntry = st.nextToken();
            if (!cpEntry.toLowerCase().endsWith("jar") && !cpEntry.toLowerCase().endsWith("zip")) continue;
            cpJarFilesList.add(cpEntry);
        }
        return cpJarFilesList;
    }

    protected static synchronized JarEntry getJarEntry(JarFile jarFile, String fileName) {
        tracer.println("<getJarEntry jarFile=" + jarFile + " fileName=" + fileName + ">");
        if (jarFile == null) {
            return null;
        }
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry jarEntry = entries.nextElement();
            if (!jarEntry.getName().equals(fileName)) continue;
            tracer.println("jarEntry.getName()=" + jarEntry.getName());
            return jarEntry;
        }
        tracer.println("<message>Could not find JarEntry with fileName=" + fileName + "</message>");
        tracer.println("</getJarEntry>");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static synchronized JarFile lookForFileInJars(String fileName) {
        try {
            tracer.println("<lookForFileInJars fileName=" + fileName + ">");
            String classpath = System.getProperty("java.class.path");
            tracer.println("classpath=" + classpath);
            List cpJarFilesList = FileUtil.getJarList();
            List cpDirList = FileUtil.getCpDirList();
            for (int i = 0; i < cpJarFilesList.size(); ++i) {
                String jarFileName = (String)cpJarFilesList.get(i);
                tracer.println("jarFileName=" + jarFileName);
                JarFile jarFile = new JarFile(new File(jarFileName));
                JarEntry jarEntry = FileUtil.getJarEntry(jarFile, fileName);
                if (jarEntry == null) continue;
                JarFile jarFile2 = jarFile;
                return jarFile2;
            }
            JarFile jarFile = null;
            return jarFile;
        }
        catch (Exception ioe) {
            JarFile jarFile = null;
            return jarFile;
        }
        finally {
            tracer.println("</lookForFileInJars>");
        }
    }

    public static synchronized boolean locateFile(String fileName, boolean searchInClassPath, boolean searchInJarFile) {
        JarFile jarFile;
        File file = FileUtil.findFile(fileName, searchInClassPath);
        if (file != null) {
            return true;
        }
        return searchInJarFile && (jarFile = FileUtil.lookForFileInJars(fileName)) != null;
    }

    public static synchronized File findFile(String fileName, boolean searchInClassPath) {
        try {
            File file = new File(fileName);
            if (file.exists()) {
                return file;
            }
            List cpJarFilesList = FileUtil.getJarList();
            List cpDirList = FileUtil.getCpDirList();
            if (searchInClassPath) {
                for (int i = 0; i < cpDirList.size(); ++i) {
                    String path = (String)cpDirList.get(i);
                    File file2 = new File(path + File.separator + fileName);
                    if (!file2.exists()) continue;
                    return file2;
                }
            }
            return null;
        }
        catch (Exception ioe) {
            return null;
        }
    }

    public static synchronized InputStream loadFile(String fileName, boolean searchInClassPath, boolean searchInJarFile) throws FileNotFoundException, IOException {
        tracer.println("<loadFile fileName=" + fileName + " searchInClassPath=" + searchInClassPath + " searchInJarFile=" + searchInJarFile + ">");
        File locatedFile = FileUtil.findFile(fileName, searchInClassPath);
        if (locatedFile != null) {
            return new FileInputStream(locatedFile);
        }
        if (locatedFile == null && !searchInJarFile) {
            throw new FileNotFoundException("Could not find file: " + fileName);
        }
        JarFile locatedJarFile = FileUtil.lookForFileInJars(fileName);
        if (locatedJarFile == null) {
            throw new FileNotFoundException("Could not find file: " + fileName);
        }
        JarEntry locatedJarEntry = FileUtil.getJarEntry(locatedJarFile, fileName);
        if (locatedJarEntry != null) {
            return locatedJarFile.getInputStream(locatedJarEntry);
        }
        throw new FileNotFoundException("Could not find file: " + fileName);
    }
}

