/*
 * Decompiled with CFR 0.152.
 */
package jpos.profile;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import jpos.profile.DefaultProfile;
import jpos.profile.Profile;
import jpos.profile.ProfileException;
import jpos.profile.ProfileFactory;
import jpos.util.XmlHelper;
import jpos.util.tracing.Tracer;
import jpos.util.tracing.TracerFactory;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XercesProfileFactory
implements ProfileFactory {
    private Profile profile = null;
    private DOMParser domParser = new DOMParser();
    private DefaultErrorHandler errorHandler = new DefaultErrorHandler();
    private Tracer tracer = TracerFactory.getInstance().createTracer("XercesProfileFactory");
    public static final String PROFILE_DTD_FILE_NAME = "jcl_profile.dtd";
    public static final String PROFILE_DTD_FILE_PATH = "jpos" + File.separator + "res" + File.separator;

    private Profile extractProfile(Document document) throws ProfileException {
        Element profileElement = document.getDocumentElement();
        String name = profileElement.getAttribute("name");
        DefaultProfile profile = new DefaultProfile(name);
        NodeList nodeList = profileElement.getElementsByTagName("ProfileInfo");
        if (nodeList.getLength() != 1) {
            throw new ProfileException("Profile does not contain 1 ProfileInfo element");
        }
        Element profileInfoElement = (Element)nodeList.item(0);
        profile.setVersion(profileInfoElement.getAttribute("version"));
        profile.setVendorName(profileInfoElement.getAttribute("vendorName"));
        try {
            String vendorUrlString = profileInfoElement.getAttribute("vendorUrl");
            profile.setVendorUrl(new URL(vendorUrlString));
        }
        catch (MalformedURLException e) {
            throw new ProfileException("ProfileInfo contains an invalid vendorUrl string");
        }
        profile.setDescription(profileInfoElement.getAttribute("description"));
        return profile;
    }

    Document parse(String xmlFileName) throws ProfileException {
        XmlHelper xmlHelper = new XmlHelper();
        try {
            xmlHelper.setDtdFileName(PROFILE_DTD_FILE_NAME);
            xmlHelper.setDtdFilePath(PROFILE_DTD_FILE_PATH);
            xmlHelper.checkAndCreateTempDtd();
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            docFactory.setNamespaceAware(true);
            docFactory.setValidating(true);
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            DefaultErrorHandler errorHandler = new DefaultErrorHandler();
            docBuilder.setErrorHandler(errorHandler);
            Document document = docBuilder.parse(new File(xmlFileName));
            if (errorHandler.getErrorList().size() > 0 || errorHandler.getFatalErrorList().size() > 0) {
                String msg = "Error while parsing XML file, set properties jpos.tracing = ON in jpos.properties file for details";
                throw new ProfileException(msg);
            }
            Document document2 = document;
            return document2;
        }
        catch (IOException ioe) {
            String msg = "Error loading XML profile file";
            this.tracer.println(msg + ": Exception.message = " + ioe.getMessage());
            throw new ProfileException(msg, ioe);
        }
        catch (SAXException se) {
            String msg = "Error parsing XML profile file";
            this.tracer.println(msg + ": Exception.message = " + se.getMessage());
            throw new ProfileException(msg, se);
        }
        catch (ParserConfigurationException pce) {
            String msg = "Error creating XML parser";
            this.tracer.println(msg + ": Exception.message = " + pce.getMessage());
            throw new ProfileException(msg, pce);
        }
        finally {
            xmlHelper.removeTempDtd();
        }
    }

    Document parseSchema(String xmlFileName) throws ProfileException {
        try {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            docFactory.setNamespaceAware(true);
            docFactory.setValidating(true);
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            DefaultErrorHandler errorHandler = new DefaultErrorHandler();
            docBuilder.setErrorHandler(errorHandler);
            Document document = docBuilder.parse(new File(xmlFileName));
            return document;
        }
        catch (IOException ioe) {
            String msg = "Error loading XML profile file";
            this.tracer.println(msg + ": Excpetion.message = " + ioe.getMessage());
            throw new ProfileException(msg, ioe);
        }
        catch (SAXException se) {
            String msg = "Error parsing XML profile file";
            this.tracer.println(msg + ": Exception.message = " + se.getMessage());
            throw new ProfileException(msg, se);
        }
        catch (ParserConfigurationException pce) {
            String msg = "Error creating XML parser";
            this.tracer.println(msg + ": Exception.message = " + pce.getMessage());
            throw new ProfileException(msg, pce);
        }
    }

    Profile load(String xmlFileName) throws ProfileException {
        Document document = this.parse(xmlFileName);
        return this.extractProfile(document);
    }

    public Profile createProfile(String xmlProfileFileName) throws ProfileException {
        return this.load(xmlProfileFileName);
    }

    class DefaultErrorHandler
    implements ErrorHandler {
        private List warningList = new ArrayList();
        private List errorList = new ArrayList();
        private List fatalErrorList = new ArrayList();

        DefaultErrorHandler() {
        }

        List getErrorList() {
            return this.errorList;
        }

        List getWarningList() {
            return this.warningList;
        }

        List getFatalErrorList() {
            return this.fatalErrorList;
        }

        public void warning(SAXParseException e) throws SAXException {
            XercesProfileFactory.this.tracer.println("Line " + e.getLineNumber() + ": WARNING SAXParseException.message = " + e.getMessage());
            this.warningList.add(e);
        }

        public void error(SAXParseException e) throws SAXException {
            XercesProfileFactory.this.tracer.println("Line " + e.getLineNumber() + ": ERROR SAXParseException.message = " + e.getMessage());
            this.errorList.add(e);
        }

        public void fatalError(SAXParseException e) throws SAXException {
            XercesProfileFactory.this.tracer.println("Line " + e.getLineNumber() + ": FATALERROR SAXParseException.message = " + e.getMessage());
            this.fatalErrorList.add(e);
        }
    }
}

