/*
 * Decompiled with CFR 0.152.
 */
package pl.novitus.javapos.utils.connection;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pl.novitus.javapos.utils.ConnectionException;
import pl.novitus.javapos.utils.ConnectionTimeoutException;
import pl.novitus.javapos.utils.connection.SocketConnection;
import pl.novitus.javapos.utils.i18n.I18n;

public class TCPConnection
extends SocketConnection {
    private static final Logger log = LogManager.getLogger(TCPConnection.class);
    private Socket tcpSocket;
    private InetAddress serverAddress;

    @Override
    protected void assertPortOpen() throws ConnectionException {
        if (this.tcpSocket == null || !this.tcpSocket.isConnected()) {
            throw new ConnectionException("strSocketNotConnected");
        }
    }

    @Override
    public int read() throws ConnectionException {
        byte[] res = this.read(1);
        try {
            return res[0];
        }
        catch (Exception ex) {
            String msg = String.format(I18n.tr("strSocketReadErrorNoData"), this.getServer(), this.getPort());
            log.error(msg);
            throw new ConnectionException(msg);
        }
    }

    @Override
    public byte[] read(int count) throws ConnectionException {
        this.assertPortOpen();
        byte[] buf = new byte[count];
        try {
            int c;
            int pos = 0;
            for (int i = count; i > 0; i -= c) {
                c = this.tcpSocket.getInputStream().read(buf, pos, i);
                pos += c;
            }
            return buf;
        }
        catch (InterruptedIOException ex) {
            String msg = String.format(I18n.tr("strPortReadTimeout"), this.getServer());
            log.error(msg);
            throw new ConnectionTimeoutException(msg);
        }
        catch (IOException ex) {
            String msg = String.format(I18n.tr("strSocketReadError"), this.getServer(), this.getPort(), ex.getMessage());
            log.error(msg);
            throw new ConnectionException(msg);
        }
    }

    @Override
    public void write(int data) throws ConnectionException {
        byte[] buf = new byte[]{new Integer(data).byteValue()};
        this.write(buf);
    }

    @Override
    public void write(byte[] data) throws ConnectionException {
        this.assertPortOpen();
        try {
            this.tcpSocket.getOutputStream().write(data);
        }
        catch (IOException ex) {
            String msg = String.format(I18n.tr("strSocketWriteError"), this.getServer(), this.getPort(), ex.getMessage());
            log.error(msg);
            throw new ConnectionException(msg);
        }
    }

    @Override
    public void open() throws ConnectionException {
        try {
            log.debug(String.format("Opening TCP connection to %s, port %d", this.getServer(), this.getPort()));
            this.serverAddress = InetAddress.getByName(this.getServer());
            InetSocketAddress socketAddress = new InetSocketAddress(this.serverAddress, this.getPort());
            this.tcpSocket = new Socket();
            this.tcpSocket.setSoTimeout(this.getTimeout());
            this.tcpSocket.connect(socketAddress, this.getTimeout());
            log.debug(String.format("Connection to %s:%d succeeded.", this.getServer(), this.getPort()));
        }
        catch (UnknownHostException ex) {
            log.error(String.format("Error: unknown host %s", this.getServer()));
            throw new ConnectionException(String.format(I18n.tr("strSocketUnknownHost"), this.getServer()));
        }
        catch (SocketException ex) {
            log.error(String.format("Error opening TCP socket: %s", ex.getMessage()));
            throw new ConnectionException(String.format(I18n.tr("strSocketSocketError"), ex.getMessage()));
        }
        catch (IOException ex) {
            log.error(String.format("Error opening TCP socket: %s", ex.getMessage()));
            throw new ConnectionException(String.format(I18n.tr("strSocketSocketError"), ex.getMessage()));
        }
    }

    @Override
    public void close() throws ConnectionException {
        log.debug("Closing TCP connection");
        try {
            if (this.tcpSocket != null) {
                this.tcpSocket.close();
            }
            log.debug("TCP connection closed");
        }
        catch (Exception ex) {
            log.warn("Error encountered while closing TCP socket: " + ex.getMessage());
        }
        this.tcpSocket = null;
    }
}

