/*
 * Decompiled with CFR 0.152.
 */
package pl.novitus.javapos.service.impl.printer;

import java.util.Calendar;
import pl.novitus.javapos.data.POSAndClerkId;
import pl.novitus.javapos.service.impl.printer.LegacyServiceBase;
import pl.novitus.javapos.utils.FiscalDeviceException;
import pl.novitus.javapos.utils.printer.LegacyPacketBuilder;

public class LegacyReportService
extends LegacyServiceBase {
    public static final int FULL_BY_DATE = 0;
    public static final int FULL_BY_NUMBER = 16;
    public static final int MIN_Z_REPORT_TIMEOUT = 20000;
    public static final int MIN_Y_REPORT_TIMEOUT = 20000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportZ(POSAndClerkId posAndClerkId, Calendar date) throws FiscalDeviceException {
        LegacyPacketBuilder builder = new LegacyPacketBuilder();
        int to = this.getProtocol().getConnection().getTimeout();
        this.getProtocol().getConnection().setTimeout(to < 20000 ? 20000 : to);
        try {
            builder.begin().add("", 1).fieldSeparator().add("", date.get(1) % 100).fieldSeparator().add("", date.get(2) + 1).fieldSeparator().add("", date.get(5)).addType("#r");
            posAndClerkId.addToPacket(builder);
            builder.end();
            String request = builder.toString();
            this.getProtocol().sendPacket(request);
            this.getProtocol().checkError();
        }
        finally {
            this.getProtocol().getConnection().setTimeout(to);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeReport(POSAndClerkId posAndClerkId, boolean reset, String shift) throws FiscalDeviceException {
        if (shift == null) {
            shift = "";
        }
        int to = this.getProtocol().getConnection().getTimeout();
        this.getProtocol().getConnection().setTimeout(to < 20000 ? 20000 : to);
        try {
            POSAndClerkId ecrclerk = new POSAndClerkId();
            ecrclerk.setClerkId(posAndClerkId == null ? "" : posAndClerkId.getClerkId());
            ecrclerk.setEcrId(posAndClerkId.getEcrId());
            LegacyPacketBuilder builder = new LegacyPacketBuilder();
            builder.begin().add("", reset ? 0 : 23).addType("#k").add("", shift).optionalFieldSeparator();
            ecrclerk.addToPacket(builder);
            builder.end();
            String request = builder.toString();
            this.getProtocol().sendPacket(request);
            this.getProtocol().checkError();
        }
        finally {
            this.getProtocol().getConnection().setTimeout(to);
        }
    }

    public void periodicReport(int type, POSAndClerkId posAndClerkId, Calendar bd, Calendar ed) throws FiscalDeviceException {
        LegacyPacketBuilder builder = new LegacyPacketBuilder();
        builder.begin().add("", bd.get(1) % 100).fieldSeparator().add("", bd.get(2) + 1).fieldSeparator().add("", bd.get(5)).fieldSeparator().add("", ed.get(1) % 100).fieldSeparator().add("", ed.get(2) + 1).fieldSeparator().add("", ed.get(5)).fieldSeparator().add("", type).addType("#o");
        posAndClerkId.addToPacket(builder);
        String request = builder.end().toString();
        this.getProtocol().sendPacket(request);
        this.getProtocol().checkError();
    }

    public void periodicReport(int type, POSAndClerkId posAndClerkId, int begin, int end) throws FiscalDeviceException {
        LegacyPacketBuilder builder = new LegacyPacketBuilder();
        builder.begin().add("", type).addType("#o").add("", begin).valueSeparator().add("", end).valueSeparator();
        posAndClerkId.addToPacket(builder);
        String request = builder.end().toString();
        this.getProtocol().sendPacket(request);
        this.getProtocol().checkError();
    }

    public void reportX(POSAndClerkId posAndClerkId) throws FiscalDeviceException {
        Calendar dt = Calendar.getInstance();
        this.periodicReport(0, posAndClerkId, dt, dt);
    }
}

