/*
 * Decompiled with CFR 0.152.
 */
package jpos.config.simple;

import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import jpos.config.JposEntry;
import jpos.config.simple.AbstractRegPopulator;
import jpos.util.tracing.Tracer;
import jpos.util.tracing.TracerFactory;

public class SimpleRegPopulator
extends AbstractRegPopulator {
    private File serFile = null;
    private ZipFile zipSerFile = null;
    private boolean serInZipFile = false;
    private String absoluteFileName = "";
    private String serFileName = "jpos.cfg";
    private Tracer tracer = TracerFactory.getInstance().createTracer("SimpleRegPopulator");
    public static final String DEFAULT_JPOS_SER_FILE_NAME = "jpos.cfg";
    public static final String TEMP_SER_FILE_NAME = "__jpos_temp.cfg";
    public static final String SIMPLE_REG_POPULATOR_NAME_STRING = "JCL Serialized Entries Populator";

    public SimpleRegPopulator() {
        super(SimpleRegPopulator.class.getName());
    }

    public SimpleRegPopulator(String s) {
        super(s);
    }

    public String getClassName() {
        return SimpleRegPopulator.class.getName();
    }

    public void save(Enumeration entries) throws Exception {
        this.saveJposEntries(entries);
    }

    public void save(Enumeration entries, String fileName) throws Exception {
        File file = new File(fileName);
        FileOutputStream fos = new FileOutputStream(file);
        this.saveJposEntries(entries, fos);
        fos.close();
    }

    public void load() {
        this.getJposEntries().clear();
        Enumeration entries = this.readJposEntries();
        while (entries.hasMoreElements()) {
            try {
                JposEntry entry = (JposEntry)entries.nextElement();
                String logicalName = (String)entry.getPropertyValue("logicalName");
                if (logicalName != null) {
                    this.getJposEntries().put(logicalName, entry);
                }
                this.lastLoadException = null;
            }
            catch (Exception e) {
                this.lastLoadException = e;
                this.tracer.println("Error loading serialized JposEntry file: Exception.message= " + e.getMessage());
            }
        }
    }

    public void load(String fileName) {
        try {
            this.getJposEntries().clear();
            Enumeration entries = this.readJposEntries(new FileInputStream(fileName));
            while (entries.hasMoreElements()) {
                JposEntry entry = (JposEntry)entries.nextElement();
                String logicalName = (String)entry.getPropertyValue("logicalName");
                if (logicalName == null) continue;
                this.getJposEntries().put(logicalName, entry);
            }
            this.lastLoadException = null;
        }
        catch (Exception e) {
            this.lastLoadException = e;
            this.tracer.println("Error loading serialized JposEntry file: Exception.message=" + e.getMessage());
        }
    }

    public URL getEntriesURL() {
        URL url = null;
        url = this.serInZipFile ? this.createURLFromFile(this.zipSerFile) : (this.serFile != null ? this.createURLFromFile(this.serFile) : this.createURLFromFile(new File(this.getPopulatorFileName())));
        return url;
    }

    public String getName() {
        return SIMPLE_REG_POPULATOR_NAME_STRING;
    }

    protected void saveSerInZipFile(Enumeration entries) throws Exception {
        ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(this.zipSerFile.getName() + ".temp.jar"));
        Enumeration<? extends ZipEntry> zipEntries = this.zipSerFile.entries();
        while (zipEntries.hasMoreElements()) {
            ZipEntry zipEntry = zipEntries.nextElement();
            zos.putNextEntry(zipEntry);
            if (zipEntry.getName() != this.serFileName) {
                InputStream is = this.zipSerFile.getInputStream(zipEntry);
                while (is.available() > 0) {
                    byte[] byteArray = new byte[is.available()];
                    is.read(byteArray);
                    zos.write(byteArray);
                }
                zos.closeEntry();
                continue;
            }
            ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(TEMP_SER_FILE_NAME));
            while (entries.hasMoreElements()) {
                JposEntry entry = (JposEntry)entries.nextElement();
                oos.writeObject(entry);
            }
            oos.flush();
            oos.close();
            FileInputStream fis = new FileInputStream(TEMP_SER_FILE_NAME);
            while (fis.available() > 0) {
                byte[] byteArray = new byte[fis.available()];
                fis.read(byteArray);
                zos.write(byteArray);
            }
            zos.closeEntry();
        }
        zos.flush();
        zos.close();
    }

    protected void saveSerFile(Enumeration entries) throws Exception {
        this.saveJposEntries(entries, new FileOutputStream(this.serFileName));
    }

    protected void saveJposEntries(Enumeration entries, OutputStream os) throws Exception {
        ObjectOutputStream oos = new ObjectOutputStream(os);
        while (entries.hasMoreElements()) {
            JposEntry entry = (JposEntry)entries.nextElement();
            oos.writeObject(entry);
        }
        oos.close();
    }

    protected ObjectInputStream findSerOIS() {
        Vector classpathJarFiles = new Vector();
        ObjectInputStream ois = this.findSerOISInClasspath(classpathJarFiles);
        if (ois == null) {
            ois = this.findSerOISInJar(classpathJarFiles);
        }
        return ois;
    }

    protected ObjectInputStream findSerOISInClasspath(Vector jarZipFilesVector) {
        ObjectInputStream ois = null;
        String classpath = System.getProperty("java.class.path");
        String pathSeparator = System.getProperty("path.separator");
        String fileSeparator = System.getProperty("file.separator");
        String path = "";
        StringTokenizer st = new StringTokenizer(classpath, pathSeparator, false);
        while (st.hasMoreTokens()) {
            try {
                path = st.nextToken().trim();
                if (path.equals("")) continue;
                if (path.length() > 4 && (path.endsWith(".zip") || path.endsWith(".jar"))) {
                    jarZipFilesVector.addElement(path);
                    continue;
                }
                this.absoluteFileName = path + fileSeparator + this.serFileName;
                ois = new ObjectInputStream(new BufferedInputStream(new FileInputStream(this.absoluteFileName)));
                this.serFile = new File(this.absoluteFileName);
                this.serInZipFile = false;
                break;
            }
            catch (Exception e) {
            }
        }
        return ois;
    }

    protected ObjectInputStream findSerOISInJar(Vector jarFilesVector) {
        ObjectInputStream ois = null;
        for (int i = 0; i < jarFilesVector.size(); ++i) {
            String jarFileName = (String)jarFilesVector.elementAt(i);
            try {
                ZipFile zipFile = new ZipFile(jarFileName);
                Enumeration<? extends ZipEntry> zipEntries = zipFile.entries();
                while (zipEntries.hasMoreElements()) {
                    ZipEntry zipEntry = zipEntries.nextElement();
                    String entryName = zipEntry.getName();
                    if (!entryName.endsWith(this.serFileName)) continue;
                    ois = new ObjectInputStream(zipFile.getInputStream(zipEntry));
                    this.zipSerFile = zipFile;
                    this.serInZipFile = true;
                    break;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            if (ois != null) break;
        }
        return ois;
    }

    protected Enumeration readJposEntries(InputStream is) {
        Vector<Object> entries = new Vector<Object>();
        try {
            ObjectInputStream in = null;
            if (is instanceof ObjectInputStream) {
                in = (ObjectInputStream)is;
            } else if (is != null) {
                in = new ObjectInputStream(is);
            }
            if (in != null) {
                while (true) {
                    entries.addElement(in.readObject());
                }
            }
            this.tracer.println("Can't find serialized JposEntry file: " + this.serFileName);
            this.serFileName = this.absoluteFileName;
        }
        catch (EOFException eofe) {
        }
        catch (Exception e) {
            this.tracer.println("ERROR while reading serialized JposEntry file: " + this.serFileName + " Exception.message=" + e.getMessage());
        }
        return entries.elements();
    }

    protected Enumeration readJposEntries() {
        Enumeration entries = null;
        if (this.isPopulatorFileDefined()) {
            try {
                entries = this.readJposEntries(this.getPopulatorFileIS());
            }
            catch (Exception e) {
                entries = new Vector().elements();
            }
        } else {
            entries = this.readJposEntries(this.findSerOIS());
        }
        return entries;
    }

    protected void saveJposEntries(Enumeration entries) throws Exception {
        if (this.isPopulatorFileDefined()) {
            this.saveJposEntries(entries, this.getPopulatorFileOS());
        } else if (this.serInZipFile) {
            this.saveSerInZipFile(entries);
        } else {
            this.saveSerFile(entries);
        }
    }
}

