/*
 * Decompiled with CFR 0.152.
 */
package jpos;

import java.util.Vector;
import jpos.BaseControl;
import jpos.BaseJposControl;
import jpos.CoinDispenserControl114;
import jpos.JposConst;
import jpos.JposException;
import jpos.events.DataEvent;
import jpos.events.DirectIOEvent;
import jpos.events.DirectIOListener;
import jpos.events.ErrorEvent;
import jpos.events.OutputCompleteEvent;
import jpos.events.StatusUpdateEvent;
import jpos.events.StatusUpdateListener;
import jpos.services.BaseService;
import jpos.services.CoinDispenserService110;
import jpos.services.CoinDispenserService111;
import jpos.services.CoinDispenserService112;
import jpos.services.CoinDispenserService113;
import jpos.services.CoinDispenserService114;
import jpos.services.CoinDispenserService12;
import jpos.services.CoinDispenserService13;
import jpos.services.CoinDispenserService14;
import jpos.services.CoinDispenserService15;
import jpos.services.CoinDispenserService16;
import jpos.services.CoinDispenserService17;
import jpos.services.CoinDispenserService18;
import jpos.services.CoinDispenserService19;
import jpos.services.EventCallbacks;

public class CoinDispenser
extends BaseJposControl
implements CoinDispenserControl114,
JposConst {
    protected CoinDispenserService12 service12;
    protected CoinDispenserService13 service13;
    protected CoinDispenserService14 service14;
    protected CoinDispenserService15 service15;
    protected CoinDispenserService16 service16;
    protected CoinDispenserService17 service17;
    protected CoinDispenserService18 service18;
    protected CoinDispenserService19 service19;
    protected CoinDispenserService110 service110;
    protected CoinDispenserService111 service111;
    protected CoinDispenserService112 service112;
    protected CoinDispenserService113 service113;
    protected CoinDispenserService114 service114;
    protected Vector directIOListeners;
    protected Vector statusUpdateListeners;

    public CoinDispenser() {
        this.deviceControlDescription = "JavaPOS CoinDispenser Device Control";
        this.deviceControlVersion = 1014000;
        this.directIOListeners = new Vector();
        this.statusUpdateListeners = new Vector();
    }

    public boolean getCapEmptySensor() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service12.getCapEmptySensor();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public boolean getCapJamSensor() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service12.getCapJamSensor();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public boolean getCapNearEmptySensor() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service12.getCapNearEmptySensor();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public int getCapPowerReporting() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1003000) {
            throw new JposException(104, "Device Service is not 1.3.0 compliant.");
        }
        try {
            return this.service13.getCapPowerReporting();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public boolean getCapStatisticsReporting() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1008000) {
            throw new JposException(104, "Device Service is not 1.8.0 compliant.");
        }
        try {
            return this.service18.getCapStatisticsReporting();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public boolean getCapUpdateStatistics() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1008000) {
            throw new JposException(104, "Device Service is not 1.8.0 compliant.");
        }
        try {
            return this.service18.getCapUpdateStatistics();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public boolean getCapCompareFirmwareVersion() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1009000) {
            throw new JposException(104, "Device Service is not 1.9.0 compliant.");
        }
        try {
            return this.service19.getCapCompareFirmwareVersion();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public boolean getCapUpdateFirmware() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1009000) {
            throw new JposException(104, "Device Service is not 1.9.0 compliant.");
        }
        try {
            return this.service19.getCapUpdateFirmware();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public int getDispenserStatus() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service12.getDispenserStatus();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public int getPowerNotify() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1003000) {
            throw new JposException(104, "Device Service is not 1.3.0 compliant.");
        }
        try {
            return this.service13.getPowerNotify();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public void setPowerNotify(int powerNotify) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1003000) {
            throw new JposException(104, "Device Service is not 1.3.0 compliant.");
        }
        try {
            this.service13.setPowerNotify(powerNotify);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public int getPowerState() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1003000) {
            throw new JposException(104, "Device Service is not 1.3.0 compliant.");
        }
        try {
            return this.service13.getPowerState();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public void dispenseChange(int amount) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service12.dispenseChange(amount);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public void resetStatistics(String statisticsBuffer) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1008000) {
            throw new JposException(104, "Device Service is not 1.8.0 compliant.");
        }
        try {
            this.service18.resetStatistics(statisticsBuffer);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public void retrieveStatistics(String[] statisticsBuffer) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1008000) {
            throw new JposException(104, "Device Service is not 1.8.0 compliant.");
        }
        try {
            this.service18.retrieveStatistics(statisticsBuffer);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public void updateStatistics(String statisticsBuffer) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1008000) {
            throw new JposException(104, "Device Service is not 1.8.0 compliant.");
        }
        try {
            this.service18.updateStatistics(statisticsBuffer);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public void compareFirmwareVersion(String firmwareFileName, int[] result) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1009000) {
            throw new JposException(104, "Device Service is not 1.9.0 compliant.");
        }
        try {
            this.service19.compareFirmwareVersion(firmwareFileName, result);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public void updateFirmware(String firmwareFileName) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1009000) {
            throw new JposException(104, "Device Service is not 1.9.0 compliant.");
        }
        try {
            this.service19.updateFirmware(firmwareFileName);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public void adjustCashCounts(String cashCounts) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1011000) {
            throw new JposException(104, "Device Service is not 1.11.0 compliant.");
        }
        try {
            this.service111.adjustCashCounts(cashCounts);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    public void readCashCounts(String[] cashCounts, boolean[] discrepancy) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1011000) {
            throw new JposException(104, "Device Service is not 1.11.0 compliant.");
        }
        try {
            this.service111.readCashCounts(cashCounts, discrepancy);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    protected EventCallbacks createEventCallbacks() {
        return new CoinDispenserCallbacks();
    }

    protected void setDeviceService(BaseService service, int nServiceVersion) throws JposException {
        if (service == null) {
            this.service12 = null;
            this.service13 = null;
            this.service14 = null;
            this.service15 = null;
            this.service16 = null;
            this.service17 = null;
            this.service18 = null;
            this.service19 = null;
            this.service110 = null;
            this.service111 = null;
            this.service112 = null;
            this.service113 = null;
            this.service114 = null;
        } else {
            if (this.serviceVersion >= 1002000) {
                try {
                    this.service12 = (CoinDispenserService12)service;
                }
                catch (Exception e) {
                    throw new JposException(104, "Service does not fully implement CoinDispenserService12 interface", e);
                }
            }
            if (this.serviceVersion >= 1003000) {
                try {
                    this.service13 = (CoinDispenserService13)service;
                }
                catch (Exception e) {
                    throw new JposException(104, "Service does not fully implement CoinDispenserService13 interface", e);
                }
            }
            if (this.serviceVersion >= 1004000) {
                try {
                    this.service14 = (CoinDispenserService14)service;
                }
                catch (Exception e) {
                    throw new JposException(104, "Service does not fully implement CoinDispenserService14 interface", e);
                }
            }
            if (this.serviceVersion >= 1005000) {
                try {
                    this.service15 = (CoinDispenserService15)service;
                }
                catch (Exception e) {
                    throw new JposException(104, "Service does not fully implement CoinDispenserService15 interface", e);
                }
            }
            if (this.serviceVersion >= 1006000) {
                try {
                    this.service16 = (CoinDispenserService16)service;
                }
                catch (Exception e) {
                    throw new JposException(104, "Service does not fully implement CoinDispenserService16 interface", e);
                }
            }
            if (this.serviceVersion >= 1007000) {
                try {
                    this.service17 = (CoinDispenserService17)service;
                }
                catch (Exception e) {
                    throw new JposException(104, "Service does not fully implement CoinDispenserService17 interface", e);
                }
            }
            if (this.serviceVersion >= 1008000) {
                try {
                    this.service18 = (CoinDispenserService18)service;
                }
                catch (Exception e) {
                    throw new JposException(104, "Service does not fully implement CoinDispenserService18 interface", e);
                }
            }
            if (this.serviceVersion >= 1009000) {
                try {
                    this.service19 = (CoinDispenserService19)service;
                }
                catch (Exception e) {
                    throw new JposException(104, "Service does not fully implement CoinDispenserService19 interface", e);
                }
            }
            if (this.serviceVersion >= 1010000) {
                try {
                    this.service110 = (CoinDispenserService110)service;
                }
                catch (Exception e) {
                    throw new JposException(104, "Service does not fully implement CoinDispenserService110 interface", e);
                }
            }
            if (this.serviceVersion >= 1011000) {
                try {
                    this.service111 = (CoinDispenserService111)service;
                }
                catch (Exception e) {
                    throw new JposException(104, "Service does not fully implement CoinDispenserService111 interface", e);
                }
            }
            if (this.serviceVersion >= 1012000) {
                try {
                    this.service112 = (CoinDispenserService112)service;
                }
                catch (Exception e) {
                    throw new JposException(104, "Service does not fully implement CoinDispenserService112 interface", e);
                }
            }
            if (this.serviceVersion >= 1013000) {
                try {
                    this.service113 = (CoinDispenserService113)service;
                }
                catch (Exception e) {
                    throw new JposException(104, "Service does not fully implement CoinDispenserService113 interface", e);
                }
            }
            if (this.serviceVersion >= 1014000) {
                try {
                    this.service114 = (CoinDispenserService114)service;
                }
                catch (Exception e) {
                    throw new JposException(104, "Service does not fully implement CoinDispenserService114 interface", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDirectIOListener(DirectIOListener l) {
        Vector vector = this.directIOListeners;
        synchronized (vector) {
            this.directIOListeners.addElement(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDirectIOListener(DirectIOListener l) {
        Vector vector = this.directIOListeners;
        synchronized (vector) {
            this.directIOListeners.removeElement(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStatusUpdateListener(StatusUpdateListener l) {
        Vector vector = this.statusUpdateListeners;
        synchronized (vector) {
            this.statusUpdateListeners.addElement(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeStatusUpdateListener(StatusUpdateListener l) {
        Vector vector = this.statusUpdateListeners;
        synchronized (vector) {
            this.statusUpdateListeners.removeElement(l);
        }
    }

    protected class CoinDispenserCallbacks
    implements EventCallbacks {
        protected CoinDispenserCallbacks() {
        }

        public BaseControl getEventSource() {
            return CoinDispenser.this;
        }

        public void fireDataEvent(DataEvent e) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fireDirectIOEvent(DirectIOEvent e) {
            Vector vector = CoinDispenser.this.directIOListeners;
            synchronized (vector) {
                for (int x = 0; x < CoinDispenser.this.directIOListeners.size(); ++x) {
                    ((DirectIOListener)CoinDispenser.this.directIOListeners.elementAt(x)).directIOOccurred(e);
                }
            }
        }

        public void fireErrorEvent(ErrorEvent e) {
        }

        public void fireOutputCompleteEvent(OutputCompleteEvent e) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fireStatusUpdateEvent(StatusUpdateEvent e) {
            Vector vector = CoinDispenser.this.statusUpdateListeners;
            synchronized (vector) {
                for (int x = 0; x < CoinDispenser.this.statusUpdateListeners.size(); ++x) {
                    ((StatusUpdateListener)CoinDispenser.this.statusUpdateListeners.elementAt(x)).statusUpdateOccurred(e);
                }
            }
        }
    }
}

