/*
 * Decompiled with CFR 0.152.
 */
package pl.novitus.javapos.utils.connection;

import java.util.ArrayDeque;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pl.novitus.javapos.utils.Connection;
import pl.novitus.javapos.utils.ConnectionException;

public abstract class AbstractConnection
implements Connection {
    private static final Logger log = LogManager.getLogger(AbstractConnection.class);
    private int timeout = 5000;

    @Override
    public int getTimeout() {
        return this.timeout;
    }

    @Override
    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    protected abstract void assertPortOpen() throws ConnectionException;

    @Override
    public byte[] read(byte[] startSequence, byte[] stopSequence) throws ConnectionException {
        int i;
        this.assertPortOpen();
        this.readUntil(startSequence);
        byte[] cbuf = this.readUntil(stopSequence);
        byte[] result = new byte[cbuf.length + startSequence.length];
        int l = 0;
        for (i = 0; i < startSequence.length; ++i) {
            result[l] = startSequence[i];
            ++l;
        }
        for (i = 0; i < cbuf.length; ++i) {
            result[l] = cbuf[i];
            ++l;
        }
        log.debug("data read: " + new String(result));
        return result;
    }

    @Override
    public byte[] readUntil(byte[] sequence) throws ConnectionException {
        if (sequence.length < 1) {
            throw new ConnectionException("Invalid end sequence");
        }
        this.assertPortOpen();
        ArrayDeque<Integer> buf = new ArrayDeque<Integer>(1024);
        while (true) {
            int l;
            int b = this.read();
            buf.add(b);
            if (b != sequence[0]) continue;
            for (l = 1; l < sequence.length; ++l) {
                int b1 = this.read();
                buf.add(b1);
                if (b1 != sequence[l]) break;
            }
            if (l == sequence.length) break;
        }
        byte[] result = new byte[buf.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = ((Integer)buf.remove()).byteValue();
        }
        log.debug("data read: " + new String(result));
        return result;
    }
}

