/*
 * Decompiled with CFR 0.152.
 */
package pl.novitus.javapos.service.impl.printer;

import java.math.BigDecimal;
import java.util.Iterator;
import java.util.LinkedHashMap;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pl.novitus.javapos.data.POSAndClerkId;
import pl.novitus.javapos.data.TaxRate;
import pl.novitus.javapos.service.impl.printer.LegacyPOSReportService;
import pl.novitus.javapos.service.impl.printer.LegacyServiceBase;
import pl.novitus.javapos.utils.FiscalDeviceException;
import pl.novitus.javapos.utils.printer.LegacyPacketBuilder;

public class LegacyTaxRatesService
extends LegacyServiceBase {
    private static final Logger log = LogManager.getLogger(LegacyTaxRatesService.class);
    private LinkedHashMap<String, TaxRate> taxRatesTable = new LinkedHashMap();

    public void setTaxRates(LinkedHashMap<String, TaxRate> rates, POSAndClerkId ecrAndClerk) throws FiscalDeviceException {
        char[] rate_names = "ABCDEFG".toCharArray();
        for (int i = 0; i < rate_names.length; ++i) {
            String key = String.valueOf(rate_names[i]);
            if (!rates.containsKey(key)) {
                rates.put(key, new TaxRate());
            }
            ArrayUtils.remove((char[])rate_names, (int)0);
        }
        LegacyPacketBuilder builder = new LegacyPacketBuilder();
        builder.begin().add("", rates.size()).addType("$p");
        ecrAndClerk.addToPacket(builder);
        for (int i = 0; i < rate_names.length; ++i) {
            String key = String.valueOf(rate_names[i]);
            TaxRate r = rates.get(key);
            BigDecimal rateCode = r.getRate();
            builder.add("", rateCode).valueSeparator();
        }
        builder.end();
        String request = builder.toString();
        this.getProtocol().sendPacket(request);
        this.getProtocol().checkError();
    }

    public LinkedHashMap<String, TaxRate> getTaxRates() throws FiscalDeviceException {
        log.debug("enter");
        LegacyPOSReportService rep = new LegacyPOSReportService();
        rep.setProtocol(this.getProtocol());
        return rep.getReport(23).getTaxRates();
    }

    public LinkedHashMap<String, TaxRate> getTaxRatesTable() {
        return this.taxRatesTable;
    }

    public void setTaxRatesTable(LinkedHashMap<String, TaxRate> taxRatesTable) {
        this.taxRatesTable = taxRatesTable;
    }

    public void setVatValue(int rateId, TaxRate rate) throws FiscalDeviceException {
        String tr = null;
        tr = rateId < 65 ? String.valueOf(TaxRate.taxIndexToTaxId(rateId)) : String.valueOf((char)rateId);
        this.taxRatesTable.put(tr, rate);
    }

    public void setVatTable(POSAndClerkId ecrAndClerk) throws FiscalDeviceException {
        log.debug("enter");
        if (this.taxRatesTable.size() > 0) {
            LinkedHashMap<String, TaxRate> ctr = this.getTaxRates();
            Iterator<String> ki = this.taxRatesTable.keySet().iterator();
            while (ki.hasNext()) {
                log.debug("key=" + ki);
                String k = ki.next();
                ctr.put(k, this.taxRatesTable.get(k));
            }
            this.setTaxRates(ctr, ecrAndClerk);
            this.taxRatesTable.clear();
        }
    }
}

