/*
 * Decompiled with CFR 0.152.
 */
package pl.novitus.javapos.factory;

import jpos.JposException;
import jpos.config.JposEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pl.novitus.javapos.utils.Connection;
import pl.novitus.javapos.utils.connection.SerialPortConnection;

public final class SerialPortConnectionFactory {
    private static final Logger log = LogManager.getLogger(SerialPortConnectionFactory.class);
    protected static final String P_BAUDRATE = "baudRate";
    protected static final String P_BITS = "bits";
    protected static final String P_STOPBITS = "stopBits";
    protected static final String P_PARITY = "parity";
    protected static final String P_FLOWCTRL = "flowControl";
    protected static final String P_PORT = "port";
    protected static final String P_TIMEOUT = "timeout";
    protected static final String[] V_STOPBITS = new String[]{"1", "1.5", "2"};
    protected static final int[] VI_STOPBITS = new int[]{1, 2, 3};
    protected static final String[] V_FLOW = new String[]{"none", "dtr", "dtrdsr", "dtr/dsr", "cts", "ctsrts", "cts/rts", "xon", "xonxoff", "xon/xoff"};
    protected static final int[] VI_FLOW = new int[]{0, 4352, 4352, 4352, 17, 17, 17, 0x110000, 0x110000, 0x110000};
    protected static final String[] V_PARITY = new String[]{"none", "n", "even", "e", "odd", "o"};
    protected static final int[] VI_PARITY = new int[]{0, 0, 2, 2, 1, 1};

    private String propValueDefault(JposEntry jposentry, String propName, Object defValue) throws JposException {
        String result = defValue.toString();
        if (jposentry.getProp(propName) != null) {
            result = jposentry.getPropertyValue(propName).toString();
            log.debug(String.format("  serial port property '%s' set to '%s'", propName, result));
        } else {
            log.debug(String.format("  missing serial port property '%s' set to default value '%s'", propName, result));
        }
        return result;
    }

    private int lookupValue(String val, String[] vals, int[] ivals) throws JposException {
        for (int i = 0; i < ivals.length; ++i) {
            if (!vals[i].equalsIgnoreCase(val)) continue;
            return ivals[i];
        }
        throw new JposException(111, String.format("Invalid property value '%s'. Valid values are: %s", val, String.join((CharSequence)",", vals)));
    }

    private String revLookupValue(int iv, String[] vals, int[] ivals) throws JposException {
        for (int i = 0; i < ivals.length; ++i) {
            if (ivals[i] != iv) continue;
            return vals[i];
        }
        throw new JposException(111, String.format("Invalid property value. Valid values are: %s", String.join((CharSequence)",", vals)));
    }

    public Connection createSerialConnection(JposEntry jposentry) throws JposException {
        log.debug("Creating serial connection");
        SerialPortConnection result = new SerialPortConnection();
        if (jposentry.getProp(P_PORT) == null) {
            throw new JposException(111, "Required property 'port' is missing in serial connection configuration");
        }
        result.setPortName(jposentry.getPropertyValue(P_PORT).toString());
        log.debug(String.format("  serial port: '%s'", result.getPortName()));
        result.setBaudRate(Integer.parseInt(this.propValueDefault(jposentry, P_BAUDRATE, result.getBaudRate())));
        result.setBits(Integer.parseInt(this.propValueDefault(jposentry, P_BITS, result.getBits())));
        String pv = this.propValueDefault(jposentry, P_FLOWCTRL, this.revLookupValue(result.getFlowControl(), V_FLOW, VI_FLOW));
        result.setFlowControl(this.lookupValue(pv, V_FLOW, VI_FLOW));
        pv = this.propValueDefault(jposentry, P_PARITY, this.revLookupValue(result.getParity(), V_PARITY, VI_PARITY));
        result.setParity(this.lookupValue(pv, V_PARITY, VI_PARITY));
        pv = this.propValueDefault(jposentry, P_STOPBITS, this.revLookupValue(result.getStopBits(), V_STOPBITS, VI_STOPBITS));
        result.setStopBits(this.lookupValue(pv, V_STOPBITS, VI_STOPBITS));
        result.setTimeout(Integer.parseInt(this.propValueDefault(jposentry, P_TIMEOUT, result.getTimeout())));
        result.setBits(Integer.parseInt(this.propValueDefault(jposentry, P_TIMEOUT, result.getBits())));
        return result;
    }
}

